/*
 * Decompiled with CFR 0.152.
 */
package net.gleamynode.netty2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.gleamynode.netty2.Check;
import net.gleamynode.netty2.Controller;
import net.gleamynode.netty2.Event;
import net.gleamynode.netty2.EventQueue;
import net.gleamynode.netty2.EventType;
import net.gleamynode.netty2.ExceptionLoggingMonitor;
import net.gleamynode.netty2.ExceptionMonitor;
import net.gleamynode.netty2.IoProcessorMBean;
import net.gleamynode.netty2.ReadController;
import net.gleamynode.netty2.Session;
import net.gleamynode.netty2.WriteController;

public class IoProcessor
implements IoProcessorMBean {
    private static final String DEFAULT_THREAD_NAME_PREFIX = "netty-io";
    private final EventQueue eventQueue = new EventQueue(16);
    private int threadId = 0;
    private int controllerThreadPriority = 5;
    private int threadPriority = 5;
    private String threadNamePrefix = "netty-io";
    private boolean started;
    private int threadPoolSize = Runtime.getRuntime().availableProcessors() * 2;
    private final List workers = new ArrayList();
    private Controller readController;
    private Controller writeController;
    private ExceptionMonitor monitor = ExceptionLoggingMonitor.getInstance();

    public IoProcessor() {
        if (this.threadPoolSize <= 0) {
            this.threadPoolSize = 2;
        }
    }

    public synchronized void start() throws IOException {
        if (this.started) {
            return;
        }
        this.checkPoolSize();
        this.readController = new ReadController(this);
        this.writeController = new WriteController(this);
        this.readController.init();
        this.writeController.init();
        this.forkThreads(this.threadPoolSize);
        this.started = true;
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.forkThreads(-this.threadPoolSize);
        this.readController.startDestroy();
        this.writeController.startDestroy();
        this.readController.finishDestroy();
        this.writeController.finishDestroy();
        this.readController = null;
        this.writeController = null;
    }

    public boolean isStarted() {
        return this.started;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public synchronized void setThreadPoolSize(int newSize) {
        Check.threadPoolSize(newSize);
        if (this.started) {
            this.forkThreads(newSize - this.threadPoolSize);
        }
        this.threadPoolSize = newSize;
    }

    public int getControllerThreadPriority() {
        return this.controllerThreadPriority;
    }

    public void setControllerThreadPriority(int newPriority) {
        Check.threadPriority(newPriority);
        this.controllerThreadPriority = newPriority;
        if (this.started) {
            this.readController.setThreadPriority(newPriority);
            this.writeController.setThreadPriority(newPriority);
        }
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public synchronized void setThreadPriority(int newPriority) {
        Check.threadPriority(newPriority);
        this.threadPriority = newPriority;
        if (this.started) {
            Iterator it = this.workers.iterator();
            while (it.hasNext()) {
                Worker worker = (Worker)it.next();
                worker.setPriority(newPriority);
            }
        }
    }

    public int getReadTries() {
        return Integer.MAX_VALUE;
    }

    public void setReadTries(int readTries) {
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        Check.notNull(threadNamePrefix, "threadNamePrefix");
        this.threadNamePrefix = threadNamePrefix;
    }

    public ExceptionMonitor getExceptionMonitor() {
        return this.monitor;
    }

    public void setExceptionMonitor(ExceptionMonitor monitor) {
        Check.notNull(monitor, "exception monitor");
        this.monitor = monitor;
    }

    Controller getReadController() {
        return this.readController;
    }

    Controller getWriteController() {
        return this.writeController;
    }

    void push(Event event) {
        this.ensureStarted();
        this.eventQueue.push(event);
    }

    void notifyWriteRequest(Session session) {
        this.ensureStarted();
        this.writeController.addSession(session);
    }

    void notifyEstablishedSession(Session session) {
        this.ensureStarted();
        this.readController.addSession(session);
    }

    private void ensureStarted() {
        if (!this.started) {
            throw new IllegalStateException("IoProcessor is not started.");
        }
    }

    private void forkThreads(int delta) {
        if (delta == 0) {
            return;
        }
        if (delta > 0) {
            while (delta > 0) {
                new Worker();
                --delta;
            }
        } else {
            while (delta < 0) {
                this.eventQueue.push(Event.FEWER_THREADS);
                ++delta;
            }
        }
    }

    private void process(Event event) {
        Controller controller;
        if (this.writeController.isProcessable(event)) {
            controller = this.writeController;
        } else if (this.readController.isProcessable(event)) {
            controller = this.readController;
        } else {
            throw new RuntimeException("unknown event: " + event);
        }
        controller.processEvent(event);
    }

    private void checkPoolSize() {
        Check.threadPoolSize(this.threadPoolSize);
    }

    private class Worker
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Worker() {
            super(IoProcessor.this.threadNamePrefix + '-' + IoProcessor.this.threadId++);
            this.setPriority(IoProcessor.this.threadPriority);
            this.setDaemon(true);
            IoProcessor ioProcessor2 = IoProcessor.this;
            synchronized (ioProcessor2) {
                IoProcessor.this.workers.add(this);
            }
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Event event;
            while ((event = IoProcessor.this.eventQueue.fetch()).getType() != EventType.FEWER_THREADS) {
                IoProcessor.this.process(event);
                if (IoProcessor.this.started) continue;
            }
            IoProcessor ioProcessor = IoProcessor.this;
            synchronized (ioProcessor) {
                IoProcessor.this.workers.remove(this);
            }
        }
    }
}

