/*
 * Decompiled with CFR 0.152.
 */
package net.gleamynode.netty2;

import net.gleamynode.netty2.Event;
import net.gleamynode.netty2.EventDispatcher;
import net.gleamynode.netty2.EventQueue;
import net.gleamynode.netty2.EventType;
import net.gleamynode.netty2.LowLatencyEventDispatcherMBean;
import net.gleamynode.netty2.Message;

public class LowLatencyEventDispatcher
implements EventDispatcher,
LowLatencyEventDispatcherMBean {
    private final EventQueue eventQueue = new EventQueue(16);

    public int getWaitingEventSize() {
        return this.eventQueue.size();
    }

    public void fire(Event event) {
        this.eventQueue.push(event);
    }

    public void flush() {
        Event event;
        while ((event = this.eventQueue.fetchNow()) != null) {
            EventType type = event.getType();
            if (type == EventType.RECEIVED) {
                event.getSession().fireMessageReceived((Message)event.getItem());
                continue;
            }
            if (type == EventType.SENT) {
                event.getSession().fireMessageSent((Message)event.getItem());
                continue;
            }
            if (type == EventType.CONNECTED) {
                event.getSession().fireConnectionEstablished();
                continue;
            }
            if (type == EventType.DISCONNECTED) {
                event.getSession().fireConnectionClosed();
                continue;
            }
            if (type == EventType.EXCEPTION) {
                event.getSession().fireExceptionCaught((Throwable)event.getItem());
                continue;
            }
            if (type == EventType.IDLE) {
                event.getSession().fireSessionIdle();
                continue;
            }
            throw new RuntimeException("Invalid event type: " + type);
        }
    }
}

