/*
 * Decompiled with CFR 0.152.
 */
package net.gleamynode.netty2;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import net.gleamynode.netty2.AbstractThreadPooledEventDispatcher;
import net.gleamynode.netty2.Event;
import net.gleamynode.netty2.EventQueue;
import net.gleamynode.netty2.EventType;
import net.gleamynode.netty2.OrderedEventDispatcherMBean;
import net.gleamynode.netty2.Session;
import net.gleamynode.netty2.ThreadPooledEventDispatcher;

public class OrderedEventDispatcher
extends AbstractThreadPooledEventDispatcher
implements ThreadPooledEventDispatcher,
OrderedEventDispatcherMBean {
    private final Map sessionMap = new IdentityHashMap();
    private int nextWorkerIdx = 0;

    public synchronized int getWaitingEventSize() {
        int sum = 0;
        Iterator it = this.workers.iterator();
        while (it.hasNext()) {
            Worker worker = (Worker)it.next();
            sum += worker.localEventQueue.size();
        }
        return sum;
    }

    protected AbstractThreadPooledEventDispatcher.AbstractWorker newWorker() {
        return new Worker();
    }

    protected synchronized AbstractThreadPooledEventDispatcher.AbstractWorker removeWorker() {
        AbstractThreadPooledEventDispatcher.AbstractWorker worker = (AbstractThreadPooledEventDispatcher.AbstractWorker)this.workers.get(this.workers.size() - 1);
        worker.localEventQueue.push(Event.FEWER_THREADS);
        return worker;
    }

    public synchronized void fire(Event event) {
        if (!this.isStarted()) {
            throw new IllegalStateException("not running");
        }
        SessionInfo info = this.getSessionInfo(event.getSession());
        if (event.getType() == EventType.SENT) {
            info.writeWorker.localEventQueue.push(event);
        } else {
            info.readWorker.localEventQueue.push(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionInfo getSessionInfo(Session session) {
        SessionInfo info;
        Map map = this.sessionMap;
        synchronized (map) {
            info = (SessionInfo)this.sessionMap.get(session);
            if (info == null && (info = (SessionInfo)this.sessionMap.get(session)) == null) {
                info = new SessionInfo();
                this.sessionMap.put(session, info);
            }
            if (info.readWorker == null) {
                info.readWorker = this.nextWorker();
            }
            if (info.writeWorker == null) {
                info.writeWorker = this.nextWorker();
            }
        }
        return info;
    }

    private synchronized Worker nextWorker() {
        int workerIdx = this.nextWorkerIdx++;
        this.nextWorkerIdx %= this.workers.size();
        return (Worker)this.workers.get(workerIdx);
    }

    private static class SessionInfo {
        public volatile int eventCount;
        public Worker readWorker;
        public Worker writeWorker;

        private SessionInfo() {
        }
    }

    private class Worker
    extends AbstractThreadPooledEventDispatcher.AbstractWorker {
        public Worker() {
            super(new EventQueue(16));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onDisconnection(Session session) {
            Map map = OrderedEventDispatcher.this.sessionMap;
            synchronized (map) {
                OrderedEventDispatcher.this.sessionMap.remove(session);
            }
        }

        protected void onEnd() {
        }
    }
}

