/*
 * Decompiled with CFR 0.152.
 */
package net.gleamynode.netty2;

import java.util.Arrays;

class Queue {
    private Object[] items;
    private int first = 0;
    private int last = 0;
    private int size = 0;
    private boolean open = false;

    public Queue(int initialCapacity) {
        this.items = new Object[initialCapacity];
    }

    public void open() {
        this.clear();
        this.open = true;
    }

    public void close() {
        this.open = false;
        this.clear();
    }

    private void clear() {
        Arrays.fill(this.items, null);
        this.first = 0;
        this.last = 0;
        this.size = 0;
    }

    public Object pop() {
        if (this.size == 0) {
            return null;
        }
        Object ret = this.items[this.first];
        this.items[this.first] = null;
        this.first = (this.first + 1) % this.items.length;
        --this.size;
        return ret;
    }

    public boolean push(Object obj) {
        if (!this.open) {
            return false;
        }
        if (this.size == this.items.length) {
            int oldLen = this.items.length;
            Object[] tmp = new Object[oldLen * 2];
            if (this.first < this.last) {
                System.arraycopy(this.items, this.first, tmp, 0, this.last - this.first);
            } else {
                System.arraycopy(this.items, this.first, tmp, 0, oldLen - this.first);
                System.arraycopy(this.items, 0, tmp, oldLen - this.first, this.last);
            }
            this.first = 0;
            this.last = oldLen;
            this.items = tmp;
        }
        this.items[this.last] = obj;
        this.last = (this.last + 1) % this.items.length;
        ++this.size;
        return true;
    }

    public Object first() {
        if (!this.open) {
            return null;
        }
        if (this.size == 0) {
            return null;
        }
        return this.items[this.first];
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }
}

