/*
 * Decompiled with CFR 0.152.
 */
package net.gleamynode.netty2;

import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import net.gleamynode.netty2.Controller;
import net.gleamynode.netty2.Event;
import net.gleamynode.netty2.EventType;
import net.gleamynode.netty2.IoProcessor;
import net.gleamynode.netty2.Message;
import net.gleamynode.netty2.MessageParseException;
import net.gleamynode.netty2.MessageRecognizer;
import net.gleamynode.netty2.Queue;
import net.gleamynode.netty2.Session;
import net.gleamynode.netty2.SessionConfig;

class ReadController
extends Controller
implements Runnable {
    private final Queue sessionQueue = new Queue(16);
    private final IoProcessor ioProcessor;
    private final Selector selector;
    private Thread thread;
    private volatile boolean waitingForCompletion;
    private volatile int remainingRequests;
    private long lastIdleCheckTime = System.currentTimeMillis();
    private boolean timeToStop;

    public ReadController(IoProcessor ioProcessor) throws IOException {
        this.ioProcessor = ioProcessor;
        this.selector = Selector.open();
        this.sessionQueue.open();
    }

    public void setThreadPriority(int newPriority) {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.setPriority(newPriority);
        }
    }

    public void init() {
        this.thread = new Thread((Runnable)this, this.ioProcessor.getThreadNamePrefix() + "-rc");
        this.thread.setPriority(this.ioProcessor.getControllerThreadPriority());
        this.thread.start();
    }

    public void startDestroy() {
        this.timeToStop = true;
        this.selector.wakeup();
    }

    public void finishDestroy() {
        while (this.thread.isAlive()) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(Session session) {
        Queue queue = this.sessionQueue;
        synchronized (queue) {
            this.sessionQueue.push(session);
        }
        this.selector.wakeup();
    }

    public void notifyOpWrite(Session session) {
        this.selector.wakeup();
        session.getSelectionKey().interestOps(5);
    }

    public void run() {
        while (!this.timeToStop) {
            try {
                int nKeys = this.selector.select(1000L);
                if (this.timeToStop) break;
                this.processIdleOrTimedOutSessions();
                this.processNewSessions();
                this.processReadySessions(nKeys);
                this.waitForCompletion();
            }
            catch (IOException ioe) {
                this.ioProcessor.getExceptionMonitor().exceptionCaught(ioe);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (Throwable t) {
                this.ioProcessor.getExceptionMonitor().exceptionCaught(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processNewSessions() {
        if (this.sessionQueue.size() <= 0) return;
        Queue queue = this.sessionQueue;
        synchronized (queue) {
            Session session;
            while ((session = (Session)this.sessionQueue.pop()) != null) {
                try {
                    if (session.isClosing()) {
                        this.processClosingSession(session);
                        continue;
                    }
                    this.processOpeningSession(session);
                }
                catch (IOException ioe) {
                    this.increaseRemainingRequests();
                    this.ioProcessor.push(new Event(EventType.EXCEPTION, session, ioe));
                }
            }
            return;
        }
    }

    private void processClosingSession(Session session) {
        this.increaseRemainingRequests();
        this.ioProcessor.push(session.EVENT_CLOSE_REQUEST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOpeningSession(Session session) throws SocketException, IOException, ClosedChannelException {
        Selector selector = this.selector;
        SocketChannel channel = session.getChannel();
        if (channel != null) {
            if (session.getSelectionKey() != null) {
                session.getSelectionKey().interestOps(5);
            } else {
                Socket s = channel.socket();
                s.setKeepAlive(true);
                channel.configureBlocking(false);
                this.pushConnected(session, channel, selector);
            }
        } else {
            boolean connected;
            channel = SocketChannel.open();
            Socket s = channel.socket();
            s.setKeepAlive(true);
            channel.configureBlocking(false);
            boolean done = false;
            try {
                connected = channel.connect(session.getSocketAddress());
                done = true;
            }
            finally {
                if (done) {
                    session.setChannel(channel, false);
                } else {
                    session.setChannel(null, false);
                }
            }
            if (connected) {
                this.pushConnected(session, channel, selector);
            } else {
                channel.register(selector, 8, session);
                session.setSelectionKey(channel.keyFor(selector));
            }
        }
    }

    private void pushConnected(Session session, SocketChannel channel, Selector selector) throws IOException {
        channel.register(selector, 1, session);
        session.setSelectionKey(channel.keyFor(selector));
        this.increaseRemainingRequests();
        this.ioProcessor.push(session.EVENT_CONNECTED);
    }

    private void processIdleOrTimedOutSessions() {
        Set<SelectionKey> keys = this.selector.keys();
        Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
        long currentTime = System.currentTimeMillis();
        if (keys != null && currentTime - this.lastIdleCheckTime >= 1000L) {
            this.lastIdleCheckTime = currentTime;
            Iterator<SelectionKey> it = keys.iterator();
            while (it.hasNext()) {
                int timeout;
                SelectionKey key = it.next();
                Session session = (Session)key.attachment();
                SessionConfig config = session.getConfig();
                if (!session.getChannel().isConnected() && (timeout = config.getConnectTimeoutInMillis()) > 0 && currentTime - session.getLastIoTime() >= (long)timeout) {
                    selectedKeys.remove(key);
                    this.increaseRemainingRequests();
                    this.ioProcessor.push(session.EVENT_NOT_CONNECTED);
                }
                if (config.getIdleTimeInMillis() > 0 && !session.isIdle() && currentTime - session.getLastIoTime() >= (long)config.getIdleTimeInMillis()) {
                    session.setIdle(true);
                    this.increaseRemainingRequests();
                    this.ioProcessor.push(session.EVENT_IDLE);
                    continue;
                }
                if (!session.isWriteTimedOut(currentTime)) continue;
                this.ioProcessor.push(new Event(EventType.EXCEPTION, session, new SocketTimeoutException("write timed out")));
            }
        }
    }

    private void processReadySessions(int nKeys) {
        Iterator<SelectionKey> it;
        if (nKeys <= 0) {
            return;
        }
        Set<SelectionKey> keys = this.selector.selectedKeys();
        if (keys != null && !keys.isEmpty() && (it = keys.iterator()).hasNext()) {
            do {
                SelectionKey key = it.next();
                it.remove();
                Session session = (Session)key.attachment();
                if (key.isConnectable()) {
                    this.increaseRemainingRequests();
                    this.ioProcessor.push(session.EVENT_CONNECTED);
                    continue;
                }
                if (key.isReadable()) {
                    this.increaseRemainingRequests();
                    this.ioProcessor.push(session.EVENT_READY_TO_READ);
                    continue;
                }
                if (!key.isWritable()) continue;
                session.setWriteBufferFull(false);
                key.interestOps(1);
                this.ioProcessor.getWriteController().addSession(session);
            } while (it.hasNext());
        }
    }

    private synchronized void increaseRemainingRequests() {
        ++this.remainingRequests;
    }

    private synchronized void decreaseRemainingRequests() {
        --this.remainingRequests;
        if (this.remainingRequests == 0 && this.waitingForCompletion) {
            this.notify();
        }
    }

    private synchronized void waitForCompletion() {
        this.waitingForCompletion = true;
        while (this.remainingRequests > 0 && !this.timeToStop) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.waitingForCompletion = false;
    }

    public boolean isProcessable(Event e) {
        return e.getType() != EventType.READY_TO_WRITE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(Event event) {
        EventType type = event.getType();
        Session session = event.getSession();
        try {
            if (type == EventType.READY_TO_READ) {
                this.doRead(session);
            } else if (type == EventType.EXCEPTION) {
                session.getEventDispatcher().fire(event);
            } else if (type == EventType.CLOSE_REQUEST) {
                ReadController.doClose(session);
            } else if (type == EventType.CONNECTED) {
                this.doConnected(session);
            } else if (type == EventType.CONNECTION_TIMEOUT) {
                this.doConnectionTimeout(session);
            }
            if (type == EventType.IDLE) {
                session.getEventDispatcher().fire(event);
            } else {
                session.setLastIoTime(System.currentTimeMillis());
            }
        }
        catch (AsynchronousCloseException e) {
        }
        catch (CancelledKeyException cke) {
            this.ioProcessor.getExceptionMonitor().exceptionCaught(cke);
        }
        catch (Throwable t) {
            session.getEventDispatcher().fire(new Event(EventType.EXCEPTION, session, t));
            if (t instanceof IOException) {
                ReadController.doClose(session);
            }
        }
        finally {
            this.decreaseRemainingRequests();
            session.getEventDispatcher().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnected(Session session) throws IOException {
        SocketChannel channel = session.getChannel();
        if (!channel.isConnected()) {
            boolean done = false;
            try {
                channel.finishConnect();
                done = true;
            }
            finally {
                if (!done) {
                    try {
                        channel.close();
                    }
                    catch (IOException e) {}
                    session.setChannel(null, false);
                }
            }
            channel.register(this.selector, 1, session);
            session.setSelectionKey(channel.keyFor(this.selector));
        }
        Socket s = channel.socket();
        s.setReceiveBufferSize(8192);
        s.setSendBufferSize(8192);
        session.openBuffers();
        session.getEventDispatcher().fire(session.EVENT_CONNECTED);
    }

    private void doConnectionTimeout(Session session) throws IOException {
        session.getSelectionKey().cancel();
        SocketChannel channel = session.getChannel();
        if (channel != null) {
            if (channel.finishConnect()) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            session.setChannel(null, false);
        }
        session.getEventDispatcher().fire(new Event(EventType.EXCEPTION, session, new ConnectException("timeout (" + session.getConfig().getConnectTimeout() + " seconds)")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRead(Session session) throws IOException {
        boolean streamClosed;
        block19: {
            SocketChannel channel = session.getChannel();
            ByteBuffer readBuf = session.getReadBuffer();
            if (channel == null || readBuf == null) {
                return;
            }
            int readBytes = 0;
            streamClosed = false;
            while (true) {
                int n;
                if ((n = channel.read(readBuf)) < 0) {
                    streamClosed = true;
                    break;
                }
                if (n <= 0) break;
                readBytes += n;
            }
            if (readBytes > 0) {
                block20: {
                    while (true) {
                        boolean done;
                        int limit;
                        readBuf.flip();
                        Message m = session.getReadingMessage();
                        if (m == null) {
                            MessageRecognizer recognizer = session.getMessageRecognizer();
                            limit = readBuf.limit();
                            Exception exception = null;
                            try {
                                m = recognizer.recognize(readBuf);
                            }
                            catch (Exception e) {
                                exception = e;
                                if (e instanceof MessageParseException) {
                                    MessageParseException mpe = (MessageParseException)e;
                                    readBuf.limit(limit);
                                    readBuf.position(0);
                                    ByteBuffer readBufCopy = ByteBuffer.allocate(limit);
                                    readBufCopy.put(readBuf);
                                    readBufCopy.clear();
                                    mpe.setBuffer(readBufCopy);
                                }
                                break block19;
                            }
                            finally {
                                if (exception == null && m == null) {
                                    readBuf.limit(readBuf.capacity());
                                    readBuf.position(limit);
                                } else {
                                    readBuf.limit(limit);
                                    readBuf.position(0);
                                    if (exception != null) {
                                        session.getEventDispatcher().fire(new Event(EventType.EXCEPTION, session, exception));
                                    }
                                }
                            }
                            if (m == null) break block19;
                            session.setReadingMessage(m);
                        }
                        limit = readBuf.limit();
                        try {
                            done = m.read(readBuf);
                        }
                        catch (MessageParseException mpe) {
                            readBuf.position(0);
                            readBuf.limit(limit);
                            mpe.setBuffer(readBuf);
                            session.getEventDispatcher().fire(new Event(EventType.EXCEPTION, session, mpe));
                            break block19;
                        }
                        if (!done) break block20;
                        session.setReadingMessage(null);
                        session.getEventDispatcher().fire(new Event(EventType.RECEIVED, session, m));
                        if (readBuf.remaining() <= 0) break;
                        readBuf.compact();
                    }
                    readBuf.clear();
                    break block19;
                }
                readBuf.compact();
            }
        }
        if (streamClosed) {
            ReadController.doClose(session);
        }
    }

    private static void doClose(Session session) {
        SelectionKey key = session.getSelectionKey();
        if (key != null) {
            key.cancel();
        }
        session.closeBuffers();
        if (session.isConnected()) {
            try {
                session.getChannel().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            session.setChannel(null, false);
            session.getEventDispatcher().fire(session.EVENT_DISCONNECTED);
        } else {
            session.setChannel(null, false);
        }
    }
}

