/*
 * Decompiled with CFR 0.152.
 */
package net.gleamynode.netty2;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import net.gleamynode.netty2.ByteBufferPool;
import net.gleamynode.netty2.Check;
import net.gleamynode.netty2.Event;
import net.gleamynode.netty2.EventDispatcher;
import net.gleamynode.netty2.EventType;
import net.gleamynode.netty2.ExceptionLoggingMonitor;
import net.gleamynode.netty2.ExceptionMonitor;
import net.gleamynode.netty2.IoProcessor;
import net.gleamynode.netty2.Message;
import net.gleamynode.netty2.MessageRecognizer;
import net.gleamynode.netty2.Queue;
import net.gleamynode.netty2.SessionConfig;
import net.gleamynode.netty2.SessionListener;
import net.gleamynode.netty2.WriteQueue;

public class Session {
    final Event EVENT_CLOSE_REQUEST = new Event(EventType.CLOSE_REQUEST, this, null);
    final Event EVENT_CONNECTED = new Event(EventType.CONNECTED, this, null);
    final Event EVENT_DISCONNECTED = new Event(EventType.DISCONNECTED, this, null);
    final Event EVENT_NOT_CONNECTED = new Event(EventType.CONNECTION_TIMEOUT, this, null);
    final Event EVENT_IDLE = new Event(EventType.IDLE, this, null);
    final Event EVENT_READY_TO_READ = new Event(EventType.READY_TO_READ, this, null);
    final Event EVENT_READY_TO_WRITE = new Event(EventType.READY_TO_WRITE, this, null);
    private SessionConfig config;
    private IoProcessor ioProcessor;
    private EventDispatcher eventDispatcher;
    private MessageRecognizer messageRecognizer;
    private List sessionListeners = new ArrayList();
    private Object[] safeSessionListeners = new SessionListener[0];
    private boolean started;
    private boolean closing;
    private boolean idle;
    private long lastIoTime;
    private Object attachment;
    private SelectionKey selectionKey;
    private SocketChannel channel;
    private SocketAddress socketAddress;
    private String socketAddressString;
    private long writeStartTime;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private final WriteQueue writeRequestQueue = new WriteQueue(16);
    private Message readingMessage;
    private Message writingMessage;
    private boolean writingLastPart;
    private boolean writeBufferFull;
    private ExceptionMonitor monitor = ExceptionLoggingMonitor.getInstance();

    public Session() {
        this.config = new SessionConfig();
    }

    public Session(IoProcessor ioProcessor, SocketChannel channel, MessageRecognizer messageRecognizer, EventDispatcher eventDispatcher) {
        this(ioProcessor, channel, messageRecognizer, eventDispatcher, new SessionConfig());
    }

    public Session(IoProcessor ioProcessor, SocketAddress socketAddress, MessageRecognizer messageRecognizer, EventDispatcher eventDispatcher) {
        this(ioProcessor, socketAddress, messageRecognizer, eventDispatcher, new SessionConfig());
    }

    public Session(IoProcessor ioProcessor, SocketChannel channel, MessageRecognizer messageRecognizer, EventDispatcher eventDispatcher, SessionConfig config) {
        this.setIoProcessor(ioProcessor);
        this.setChannel(channel, true);
        this.setMessageRecognizer(messageRecognizer);
        this.setEventDispatcher(eventDispatcher);
        this.setConfig(config);
    }

    public Session(IoProcessor ioProcessor, SocketAddress socketAddress, MessageRecognizer messageRecognizer, EventDispatcher eventDispatcher, SessionConfig config) {
        this.channel = null;
        this.setIoProcessor(ioProcessor);
        this.setSocketAddress(socketAddress);
        this.setMessageRecognizer(messageRecognizer);
        this.setEventDispatcher(eventDispatcher);
        this.setConfig(config);
    }

    public synchronized void addSessionListener(SessionListener listener) {
        Check.notNull(listener, "listener");
        this.sessionListeners.add(listener);
        this.safeSessionListeners = this.sessionListeners.toArray();
    }

    public synchronized void removeSessionListener(SessionListener listener) {
        Check.notNull(listener, "listener");
        this.sessionListeners.remove(listener);
        this.safeSessionListeners = this.sessionListeners.toArray();
    }

    void setSessionListeners(List listeners) {
        Check.notNull(listeners, "listeners");
        this.sessionListeners = listeners;
        this.safeSessionListeners = listeners.toArray();
    }

    public synchronized boolean start() {
        if (this.started || this.closing) {
            return false;
        }
        if (this.ioProcessor == null) {
            throw new IllegalStateException("ioProcessor is not specified.");
        }
        if (this.eventDispatcher == null) {
            throw new IllegalStateException("eventDispatcher is not specified.");
        }
        if (this.channel == null && this.socketAddress == null) {
            throw new IllegalStateException("Neither channel nor socket address is specified.  Please call setChannel(SocketChannel) or setSocketAddress(SocketAddress) method to initialize the session.");
        }
        this.started = true;
        this.setReadingMessage(null);
        this.setWritingMessage(null);
        this.setWritingLastPart(false);
        this.setWriteBufferFull(false);
        this.setIdle(false);
        this.setLastIoTime(System.currentTimeMillis());
        this.setSelectionKey(null);
        this.ioProcessor.notifyEstablishedSession(this);
        return true;
    }

    public synchronized void close() {
        if (!this.started || this.closing) {
            return;
        }
        this.closing = true;
        this.ioProcessor.notifyEstablishedSession(this);
    }

    public SessionConfig getConfig() {
        return this.config;
    }

    public void setConfig(SessionConfig config) {
        Check.notNull(config, "config");
        this.config = config;
    }

    public boolean write(Message message) {
        return this.write(message, Long.MAX_VALUE);
    }

    public boolean write(Message message, long timeout) {
        if (this.isClosed() || this.closing) {
            return false;
        }
        Check.notNull(message, "message");
        this.writeRequestQueue.setMaxSize(this.config.getMaxQueuedWriteCount());
        if (this.writeRequestQueue.push(message, timeout)) {
            this.ioProcessor.notifyWriteRequest(this);
            return true;
        }
        return false;
    }

    public int getQueuedWriteCount() {
        return this.writeRequestQueue.size();
    }

    public boolean isIdle() {
        return this.idle;
    }

    void setIdle(boolean idle) {
        this.idle = idle;
    }

    public long getLastIoTime() {
        return this.lastIoTime;
    }

    void setLastIoTime(long lastIoTime) {
        this.lastIoTime = lastIoTime;
        this.idle = false;
    }

    boolean isWriteTimedOut(long currentTime) {
        return this.config.getWriteTimeoutInMillis() > 0 && this.getWritingMessage() != null && currentTime - this.getWriteStartTime() >= (long)this.config.getWriteTimeoutInMillis();
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isConnected() {
        SocketChannel channel = this.channel;
        return channel != null && channel.isConnected();
    }

    public boolean isClosed() {
        SocketChannel channel = this.channel;
        return channel == null || !channel.isConnected();
    }

    public boolean isClosing() {
        return this.closing;
    }

    public boolean isConnectionPending() {
        SocketChannel channel = this.channel;
        return channel != null && channel.isConnectionPending();
    }

    public SocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public String getSocketAddressString() {
        return this.socketAddressString;
    }

    public void setSocketAddress(SocketAddress socketAddress) {
        if (this.started) {
            throw new IllegalStateException("already started");
        }
        Check.notNull(socketAddress, "socketAddress");
        this.socketAddress = socketAddress;
        this.socketAddressString = socketAddress.toString();
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object newAttachment) {
        this.attachment = newAttachment;
    }

    public Message getReadingMessage() {
        return this.readingMessage;
    }

    void setReadingMessage(Message m) {
        this.readingMessage = m;
    }

    public Message getWritingMessage() {
        return this.writingMessage;
    }

    void setWritingMessage(Message m) {
        this.writingMessage = m;
    }

    public IoProcessor getIoProcessor() {
        return this.ioProcessor;
    }

    public void setIoProcessor(IoProcessor ioProcessor) {
        Check.notNull(ioProcessor, "ioProcessor");
        if (this.ioProcessor != null) {
            throw new IllegalStateException("ioProcessor cannot be set more than once.");
        }
        this.ioProcessor = ioProcessor;
    }

    public MessageRecognizer getMessageRecognizer() {
        return this.messageRecognizer;
    }

    public void setMessageRecognizer(MessageRecognizer messageRecognizer) {
        Check.notNull(messageRecognizer, "messageRecognizer");
        this.messageRecognizer = messageRecognizer;
    }

    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public void setEventDispatcher(EventDispatcher eventDispatcher) {
        Check.notNull(eventDispatcher, "eventDispatcher");
        if (this.eventDispatcher != null) {
            throw new IllegalStateException("eventDispatcher cannot be set more than once.");
        }
        this.eventDispatcher = eventDispatcher;
    }

    public ExceptionMonitor getExceptionMonitor() {
        return this.monitor;
    }

    public void setExceptionMonitor(ExceptionMonitor monitor) {
        Check.notNull(monitor, "exception monitor");
        this.monitor = monitor;
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public void setChannel(SocketChannel channel) {
        if (this.started) {
            throw new IllegalStateException("already started");
        }
        this.setChannel(channel, true);
    }

    void setChannel(SocketChannel channel, boolean connected) {
        if (connected) {
            Check.notNull(channel, "channel");
            if (!channel.isConnected()) {
                throw new IllegalArgumentException("channel is not connected");
            }
            Socket s = channel.socket();
            this.setSocketAddress(new InetSocketAddress(s.getInetAddress(), s.getPort()));
        }
        if (channel == null) {
            this.started = false;
            this.closing = false;
        }
        this.channel = channel;
    }

    SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    void setSelectionKey(SelectionKey key) {
        this.selectionKey = key;
    }

    void openBuffers() {
        this.readBuffer = ByteBufferPool.open();
        this.writeBuffer = ByteBufferPool.open();
        this.readBuffer.order(this.config.getByteOrder());
        this.writeBuffer.order(this.config.getByteOrder());
        this.writeBuffer.limit(0);
        this.writeRequestQueue.open();
    }

    void closeBuffers() {
        this.writeRequestQueue.close();
        if (this.readBuffer != null) {
            ByteBufferPool.close(this.readBuffer);
            this.readBuffer = null;
        }
        if (this.writeBuffer != null) {
            ByteBufferPool.close(this.writeBuffer);
            this.writeBuffer = null;
        }
    }

    ByteBuffer getReadBuffer() {
        return this.readBuffer;
    }

    ByteBuffer getWriteBuffer() {
        return this.writeBuffer;
    }

    Queue getWriteRequestQueue() {
        return this.writeRequestQueue;
    }

    long getWriteStartTime() {
        return this.writeStartTime;
    }

    void setWriteStartTime(long writeStartTime) {
        this.writeStartTime = writeStartTime;
    }

    boolean isWritingLastPart() {
        return this.writingLastPart;
    }

    void setWritingLastPart(boolean writingLastPart) {
        this.writingLastPart = writingLastPart;
    }

    boolean isWriteBufferFull() {
        return this.writeBufferFull;
    }

    void setWriteBufferFull(boolean writeBufferFull) {
        this.writeBufferFull = writeBufferFull;
    }

    public void fireConnectionEstablished() {
        Object[] listeners = this.safeSessionListeners;
        int size = listeners.length;
        for (int i = 0; i < size; ++i) {
            ((SessionListener)listeners[i]).connectionEstablished(this);
        }
    }

    public void fireConnectionClosed() {
        Object[] listeners = this.safeSessionListeners;
        int size = listeners.length;
        for (int i = 0; i < size; ++i) {
            ((SessionListener)listeners[i]).connectionClosed(this);
        }
    }

    public void fireMessageReceived(Message m) {
        Object[] listeners = this.safeSessionListeners;
        int size = listeners.length;
        for (int i = 0; i < size; ++i) {
            ((SessionListener)listeners[i]).messageReceived(this, m);
        }
    }

    public void fireMessageSent(Message m) {
        Object[] listeners = this.safeSessionListeners;
        int size = listeners.length;
        for (int i = 0; i < size; ++i) {
            ((SessionListener)listeners[i]).messageSent(this, m);
        }
    }

    public void fireSessionIdle() {
        Object[] listeners = this.safeSessionListeners;
        int size = listeners.length;
        for (int i = 0; i < size; ++i) {
            ((SessionListener)listeners[i]).sessionIdle(this);
        }
    }

    public void fireExceptionCaught(Throwable t) {
        Object[] listeners = this.safeSessionListeners;
        int size = listeners.length;
        try {
            for (int i = 0; i < size; ++i) {
                ((SessionListener)listeners[i]).exceptionCaught(this, t);
            }
        }
        catch (Throwable uncaught) {
            this.monitor.exceptionCaught(uncaught);
        }
    }

    public int getConnectTimeout() {
        return this.config.getConnectTimeout();
    }

    public int getConnectTimeoutInMillis() {
        return this.config.getConnectTimeoutInMillis();
    }

    public void setConnectTimeout(int connectTimeout) {
        this.config.setConnectTimeout(connectTimeout);
    }

    public int getIdleTime() {
        return this.config.getIdleTime();
    }

    public int getIdleTimeInMillis() {
        return this.config.getIdleTimeInMillis();
    }

    public void setIdleTime(int idleTime) {
        this.config.setIdleTime(idleTime);
    }

    public int getMaxQueuedWriteCount() {
        return this.config.getMaxQueuedWriteCount();
    }

    public void setMaxQueuedWriteCount(int newLimit) {
        this.config.setMaxQueuedWriteCount(newLimit);
    }

    public int getWriteTimeout() {
        return this.config.getWriteTimeout();
    }

    public int getWriteTimeoutInMillis() {
        return this.config.getWriteTimeoutInMillis();
    }

    public void setWriteTimeout(int writeTimeout) {
        this.config.setWriteTimeout(writeTimeout);
    }
}

