/*
 * Decompiled with CFR 0.152.
 */
package net.gleamynode.netty2;

import java.nio.ByteOrder;
import net.gleamynode.netty2.Check;
import net.gleamynode.netty2.SessionConfigMBean;

public class SessionConfig
implements SessionConfigMBean {
    private int idleTime;
    private int connectTimeout;
    private int writeTimeout;
    private int maxQueuedWriteCount;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;

    public int getConnectTimeout() {
        return this.connectTimeout / 1000;
    }

    public int getConnectTimeoutInMillis() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        Check.timeInSeconds(connectTimeout, "connecTimeout");
        this.connectTimeout = connectTimeout * 1000;
    }

    public int getIdleTime() {
        return this.idleTime / 1000;
    }

    public int getIdleTimeInMillis() {
        return this.idleTime;
    }

    public void setIdleTime(int idleTime) {
        Check.timeInSeconds(idleTime, "idleTime");
        this.idleTime = idleTime * 1000;
    }

    public int getMaxQueuedWriteCount() {
        return this.maxQueuedWriteCount;
    }

    public void setMaxQueuedWriteCount(int newLimit) {
        if (newLimit < 0) {
            throw new IllegalArgumentException("queued write limit: " + newLimit);
        }
        this.maxQueuedWriteCount = newLimit;
    }

    public int getWriteTimeout() {
        return this.writeTimeout / 1000;
    }

    public int getWriteTimeoutInMillis() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        Check.timeInSeconds(writeTimeout, "writeTimeout");
        this.writeTimeout = writeTimeout * 1000;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        if (byteOrder == null) {
            throw new NullPointerException("byteOrder");
        }
        this.byteOrder = byteOrder;
    }
}

