/*
 * Decompiled with CFR 0.152.
 */
package net.gleamynode.netty2;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import net.gleamynode.netty2.Check;
import net.gleamynode.netty2.EventDispatcher;
import net.gleamynode.netty2.ExceptionLoggingMonitor;
import net.gleamynode.netty2.ExceptionMonitor;
import net.gleamynode.netty2.IoProcessor;
import net.gleamynode.netty2.MessageRecognizer;
import net.gleamynode.netty2.Session;
import net.gleamynode.netty2.SessionConfig;
import net.gleamynode.netty2.SessionListener;

public class SessionServer {
    private static int id = 0;
    private IoProcessor ioProcessor;
    private EventDispatcher eventDispatcher;
    private MessageRecognizer messageRecognizer;
    private SocketAddress bindAddress;
    private int backlog = 50;
    private SessionConfig defaultConfig = new SessionConfig();
    private final ArrayList sessionListeners = new ArrayList();
    private List safeSessionListeners = new ArrayList();
    private String threadName = "SessionServer-" + ++id;
    private int threadPriority = 5;
    private ServerSocketChannel ssc;
    private Worker worker;
    private boolean started;
    private boolean timeToStop;
    private ExceptionMonitor monitor = ExceptionLoggingMonitor.getInstance();

    public SocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public synchronized void setBindAddress(SocketAddress bindAddress) {
        this.ensureNotStarted();
        Check.notNull(bindAddress, "bindAddress");
        this.bindAddress = bindAddress;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public synchronized void setBacklog(int backLog) {
        this.ensureNotStarted();
        if (backLog < 0) {
            throw new IllegalArgumentException("backLog: " + backLog);
        }
        this.backlog = backLog;
    }

    public SessionConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(SessionConfig defaultConfig) {
        Check.notNull(defaultConfig, "defaultConfig");
        this.defaultConfig = defaultConfig;
    }

    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public synchronized void setEventDispatcher(EventDispatcher eventDispatcher) {
        this.ensureNotStarted();
        Check.notNull(eventDispatcher, "eventDispatcher");
        this.eventDispatcher = eventDispatcher;
    }

    public IoProcessor getIoProcessor() {
        return this.ioProcessor;
    }

    public synchronized void setIoProcessor(IoProcessor ioProcessor) {
        this.ensureNotStarted();
        Check.notNull(ioProcessor, "ioProcessor");
        this.ioProcessor = ioProcessor;
    }

    public MessageRecognizer getMessageRecognizer() {
        return this.messageRecognizer;
    }

    public void setMessageRecognizer(MessageRecognizer messageRecognizer) {
        Check.notNull(messageRecognizer, "messageRecognizer");
        this.messageRecognizer = messageRecognizer;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public synchronized void setThreadName(String threadName) {
        Check.notNull(threadName, "threadName");
        this.threadName = threadName;
        if (this.worker != null) {
            this.worker.setName(threadName);
        }
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public synchronized void setThreadPriority(int threadPriority) {
        Check.threadPriority(threadPriority);
        this.threadPriority = threadPriority;
        if (this.worker != null) {
            this.worker.setPriority(threadPriority);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public synchronized void addSessionListener(SessionListener listener) {
        Check.notNull(listener, "listener");
        this.sessionListeners.add(listener);
        this.safeSessionListeners = (List)this.sessionListeners.clone();
    }

    public synchronized void removeSessionListener(SessionListener listener) {
        Check.notNull(listener, "listener");
        this.sessionListeners.remove(listener);
        this.safeSessionListeners = (List)this.sessionListeners.clone();
    }

    public ExceptionMonitor getExceptionMonitor() {
        return this.monitor;
    }

    public void setExceptionMonitor(ExceptionMonitor monitor) {
        Check.notNull(monitor, "exception monitor");
        this.monitor = monitor;
    }

    public synchronized void start() throws IOException {
        if (this.started) {
            return;
        }
        if (this.ioProcessor == null) {
            throw new IllegalStateException("ioProcessor is not specified.");
        }
        if (this.eventDispatcher == null) {
            throw new IllegalStateException("eventDispatcher is not specified.");
        }
        if (this.messageRecognizer == null) {
            throw new IllegalStateException("messageRecognizer is not specified.");
        }
        if (this.bindAddress == null) {
            throw new IllegalStateException("bindAddress is not specified.");
        }
        this.ssc = ServerSocketChannel.open();
        this.ssc.socket().bind(this.bindAddress, this.backlog);
        this.ssc.socket().setReuseAddress(true);
        this.timeToStop = false;
        this.worker = new Worker();
        this.worker.start();
        this.started = true;
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.timeToStop = true;
        while (this.worker.isAlive()) {
            this.worker.interrupt();
            try {
                this.worker.join(1000L);
            }
            catch (InterruptedException e) {}
        }
        this.worker = null;
        try {
            this.ssc.close();
        }
        catch (IOException e) {
            this.monitor.exceptionCaught(e);
        }
        this.ssc = null;
        this.started = false;
    }

    private void ensureNotStarted() {
        if (this.started) {
            throw new IllegalStateException("Cannot be changed while running");
        }
    }

    private class Worker
    extends Thread {
        public Worker() {
            super(SessionServer.this.threadName);
            this.setPriority(SessionServer.this.threadPriority);
        }

        public void run() {
            while (!SessionServer.this.timeToStop) {
                try {
                    this.startSession(SessionServer.this.ssc.accept());
                }
                catch (ClosedByInterruptException e) {
                }
                catch (IOException e) {
                    SessionServer.this.monitor.exceptionCaught(e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        private void startSession(SocketChannel ch) {
            Session s = new Session(SessionServer.this.ioProcessor, ch, SessionServer.this.messageRecognizer, SessionServer.this.eventDispatcher, SessionServer.this.defaultConfig);
            s.setSessionListeners(SessionServer.this.safeSessionListeners);
            s.start();
        }
    }
}

