/*
 * Decompiled with CFR 0.152.
 */
package net.gleamynode.netty2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SocketChannel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.gleamynode.netty2.Controller;
import net.gleamynode.netty2.Event;
import net.gleamynode.netty2.EventType;
import net.gleamynode.netty2.IoProcessor;
import net.gleamynode.netty2.Message;
import net.gleamynode.netty2.Queue;
import net.gleamynode.netty2.ReadController;
import net.gleamynode.netty2.Session;

class WriteController
extends Controller
implements Runnable {
    private final Set sessions = new HashSet();
    private final IoProcessor ioProcessor;
    private Thread thread;
    private volatile boolean waitingForCompletion;
    private volatile int remainingRequests;
    private boolean timeToStop;

    public WriteController(IoProcessor ioProcessor) {
        this.ioProcessor = ioProcessor;
    }

    public void setThreadPriority(int newPriority) {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.setPriority(newPriority);
        }
    }

    public void init() {
        this.thread = new Thread((Runnable)this, this.ioProcessor.getThreadNamePrefix() + "-wc");
        this.thread.setPriority(this.ioProcessor.getControllerThreadPriority());
        this.thread.start();
    }

    public synchronized void startDestroy() {
        this.timeToStop = true;
        this.notify();
    }

    public void finishDestroy() {
        while (this.thread.isAlive()) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void addSession(Session s) {
        if (s.isWriteBufferFull()) {
            return;
        }
        this.sessions.add(s);
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Session[] readySessions = new Session[16];
        int readySessionSize = 0;
        while (!this.timeToStop) {
            WriteController writeController = this;
            synchronized (writeController) {
                while (this.sessions.size() <= 0) {
                    if (this.timeToStop) {
                        return;
                    }
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException ie) {}
                }
                readySessionSize = this.sessions.size();
                if (readySessions.length < readySessionSize) {
                    readySessions = new Session[readySessionSize];
                }
                Iterator it = this.sessions.iterator();
                for (int i = --readySessionSize; i >= 0; --i) {
                    readySessions[i] = (Session)it.next();
                    it.remove();
                }
            }
            for (int i = readySessionSize; i >= 0; --i) {
                this.increaseRemainingRequests();
                this.ioProcessor.push(readySessions[i].EVENT_READY_TO_WRITE);
            }
            this.waitForWriteCompletion();
        }
    }

    private synchronized void increaseRemainingRequests() {
        ++this.remainingRequests;
    }

    private synchronized void decreaseRemainingRequests() {
        if (--this.remainingRequests == 0 && this.waitingForCompletion) {
            this.notify();
        }
    }

    private synchronized void waitForWriteCompletion() {
        this.waitingForCompletion = true;
        while (this.remainingRequests > 0 && !this.timeToStop) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.waitingForCompletion = false;
    }

    public boolean isProcessable(Event event) {
        return event.getType() == EventType.READY_TO_WRITE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(Event event) {
        Session session = event.getSession();
        try {
            if (event.getType() == EventType.READY_TO_WRITE) {
                this.doWrite(session);
            }
            session.setLastIoTime(System.currentTimeMillis());
        }
        catch (AsynchronousCloseException e) {
        }
        catch (CancelledKeyException e) {
            this.ioProcessor.getExceptionMonitor().exceptionCaught(e);
        }
        catch (Throwable t) {
            session.getEventDispatcher().fire(new Event(EventType.EXCEPTION, session, t));
            if (t instanceof IOException) {
                session.close();
            }
        }
        finally {
            this.decreaseRemainingRequests();
            session.getEventDispatcher().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWrite(Session session) throws IOException {
        if (session.isWriteBufferFull()) {
            return;
        }
        Queue queue = session.getWriteRequestQueue();
        ByteBuffer writeBuf = session.getWriteBuffer();
        if (session.isClosed() || writeBuf == null) {
            queue.close();
            WriteController writeController = this;
            synchronized (writeController) {
                this.sessions.remove(session);
            }
            return;
        }
        while (true) {
            Message m;
            if (session.getWritingMessage() == null) {
                m = (Message)queue.pop();
                if (m == null) {
                    session.setWriteBufferFull(false);
                    return;
                }
                session.setWritingMessage(m);
                session.setWriteStartTime(System.currentTimeMillis());
            }
            m = session.getWritingMessage();
            boolean wroteLastPart = m.write(writeBuf);
            session.setWritingLastPart(wroteLastPart);
            boolean allWritten = this.flush(session);
            if (!allWritten) break;
            writeBuf.clear();
            if (!wroteLastPart) continue;
            session.setWritingMessage(null);
            session.getEventDispatcher().fire(new Event(EventType.SENT, session, m));
        }
        writeBuf.compact();
        session.setWriteBufferFull(true);
        ((ReadController)this.ioProcessor.getReadController()).notifyOpWrite(session);
    }

    private boolean flush(Session session) throws IOException {
        SocketChannel channel = session.getChannel();
        ByteBuffer writeBuf = session.getWriteBuffer();
        writeBuf.flip();
        while (writeBuf.remaining() > 0) {
            if (channel.write(writeBuf) != 0) continue;
            return false;
        }
        return true;
    }
}

