/*
 * Decompiled with CFR 0.152.
 */
package net.gleamynode.netty2;

import net.gleamynode.netty2.Queue;

class WriteQueue
extends Queue {
    private int waitingForPop;
    private int maxSize;

    public WriteQueue(int initialCapacity) {
        super(initialCapacity);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public synchronized void open() {
        super.open();
    }

    public synchronized void close() {
        super.close();
        if (this.waitingForPop > 0) {
            this.notifyAll();
        }
    }

    public synchronized Object first() {
        return super.first();
    }

    public synchronized Object pop() {
        Object result = super.pop();
        if (this.waitingForPop > 0 && this.size() < this.maxSize) {
            this.notifyAll();
        }
        return result;
    }

    public boolean push(Object obj) {
        return this.push(obj, Long.MAX_VALUE);
    }

    public synchronized boolean push(Object obj, long timeout) {
        if (this.maxSize > 0) {
            long startTime;
            ++this.waitingForPop;
            long currentTime = startTime = System.currentTimeMillis();
            while (this.size() >= this.maxSize) {
                try {
                    this.wait(timeout - (currentTime - startTime));
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if ((currentTime = System.currentTimeMillis()) - startTime < timeout) continue;
                return false;
            }
            --this.waitingForPop;
        }
        return super.push(obj);
    }
}

