/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.recycleradapter;

import android.view.ViewGroup;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.gotev.recycleradapter.AdapterItem;
import net.gotev.recycleradapter.ExtensionsKt;
import net.gotev.recycleradapter.RecyclerAdapterNotifier;
import net.gotev.recycleradapter.RecyclerAdapterViewHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001>B\u0005\u00a2\u0006\u0002\u0010\u0004J)\u0010\u0014\u001a\u00020\u00002\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0018J#\u0010\u0014\u001a\u00020\u00002\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00072\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u001c\u001a\u00020\u00002\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0016J\u0012\u0010\u001c\u001a\u00020\u00002\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0007J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u000fH\u0002J\u0006\u0010!\u001a\u00020\u001eJ\u0010\u0010\"\u001a\u00020\u001e2\b\u0010#\u001a\u0004\u0018\u00010$J\u0016\u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\b\u0010&\u001a\u00020\u0012H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u001a\u001a\u00020\u0012H\u0016J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0012H\u0016J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u0010\u0010+\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\u0018\u0010,\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0012H\u0016J&\u0010,\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00122\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.H\u0016J\u0018\u00100\u001a\u00020\u00022\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0012H\u0016J\u0010\u00104\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\u0014\u00105\u001a\u00020\u001e2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J\u0012\u00106\u001a\u00020\u000f2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0007J\u000e\u00107\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0012J\u0016\u00108\u001a\u00020\u001e2\u0006\u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020\u0012J\u0018\u0010;\u001a\u00020\u00002\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0016J \u0010<\u001a\u00020\u001e2\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\f\u0010=\u001a\u00020\u000f*\u00020\u0012H\u0002R\u001b\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u00020\u00070\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u001c\u0010\r\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u0010\u001a&\u0012\u0004\u0012\u00020\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0011j\u0012\u0012\u0004\u0012\u00020\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lnet/gotev/recycleradapter/RecyclerAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lnet/gotev/recycleradapter/RecyclerAdapterViewHolder;", "Lnet/gotev/recycleradapter/RecyclerAdapterNotifier;", "()V", "adapterItems", "Ljava/util/ArrayList;", "Lnet/gotev/recycleradapter/AdapterItem;", "getAdapterItems", "()Ljava/util/ArrayList;", "filtered", "items", "getItems", "itemsList", "showFiltered", "", "types", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "add", "newItems", "", "startingPosition", "(Ljava/util/List;Ljava/lang/Integer;)Lnet/gotev/recycleradapter/RecyclerAdapter;", "item", "position", "(Lnet/gotev/recycleradapter/AdapterItem;Ljava/lang/Integer;)Lnet/gotev/recycleradapter/RecyclerAdapter;", "addOrUpdate", "bindItem", "", "holder", "firstTime", "clear", "filter", "searchTerm", "", "getAdapterItem", "getItemCount", "getItemId", "", "getItemViewType", "notifyChangedPosition", "notifyItemChanged", "onBindViewHolder", "payloads", "", "", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onViewRecycled", "registerItemType", "removeItem", "removeItemAtPosition", "swap", "sourcePosition", "targetPosition", "syncWithItems", "updateItemAtPosition", "isOutOfItemsRange", "Differ", "recycleradapter_release"})
public final class RecyclerAdapter
extends RecyclerView.Adapter<RecyclerAdapterViewHolder>
implements RecyclerAdapterNotifier {
    private final ArrayList<AdapterItem<? super RecyclerAdapterViewHolder>> itemsList = new ArrayList();
    private final LinkedHashMap<Integer, AdapterItem<?>> types = new LinkedHashMap();
    private ArrayList<AdapterItem<? super RecyclerAdapterViewHolder>> filtered = new ArrayList();
    private boolean showFiltered;

    private final ArrayList<AdapterItem<? super RecyclerAdapterViewHolder>> getItems() {
        return this.showFiltered ? this.filtered : this.itemsList;
    }

    private final void notifyChangedPosition(int position) {
        this.notifyItemChanged(position, true);
    }

    @NotNull
    public final ArrayList<AdapterItem<?>> getAdapterItems() {
        return new ArrayList((Collection)this.itemsList);
    }

    private final boolean isOutOfItemsRange(int $this$isOutOfItemsRange) {
        return $this$isOutOfItemsRange < 0 || $this$isOutOfItemsRange >= this.getItems().size();
    }

    private final void updateItemAtPosition(AdapterItem<? super RecyclerAdapterViewHolder> item, int position) {
        this.getItems().set(position, item);
        this.notifyChangedPosition(position);
    }

    private final void registerItemType(AdapterItem<?> item) {
        int classType = ExtensionsKt.viewType(item);
        if (!this.types.containsKey(classType)) {
            ((Map)this.types).put(classType, item);
        }
    }

    public int getItemViewType(int position) {
        return ExtensionsKt.viewType(this.getItems().get(position));
    }

    public long getItemId(int position) {
        return this.getItems().get(position).diffingId().hashCode();
    }

    @NotNull
    public RecyclerAdapterViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        AdapterItem item = (AdapterItem)MapsKt.getValue((Map)this.types, (Object)viewType);
        return item.createItemViewHolder(parent);
    }

    private final void bindItem(RecyclerAdapterViewHolder holder, int position, boolean firstTime) {
        AdapterItem<? super RecyclerAdapterViewHolder> adapterItem = this.getItems().get(position);
        Intrinsics.checkNotNullExpressionValue(adapterItem, (String)"items[position]");
        AdapterItem<? super RecyclerAdapterViewHolder> item = adapterItem;
        holder.setAdapter(this);
        item.bind(firstTime, holder);
    }

    public void onBindViewHolder(@NotNull RecyclerAdapterViewHolder holder, int position, @NotNull List<Object> payloads) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Intrinsics.checkNotNullParameter(payloads, (String)"payloads");
        this.bindItem(holder, position, payloads.isEmpty());
    }

    public void onBindViewHolder(@NotNull RecyclerAdapterViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        this.bindItem(holder, position, true);
    }

    public void onViewRecycled(@NotNull RecyclerAdapterViewHolder holder) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
        holder.prepareForReuse();
    }

    public int getItemCount() {
        return this.getItems().size();
    }

    @Override
    @Nullable
    public AdapterItem<?> getAdapterItem(@NotNull RecyclerAdapterViewHolder holder) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Integer n = holder.getBindingAdapterPosition();
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Integer n2 = !this.isOutOfItemsRange(it) ? n : null;
        if (n2 == null) {
            return null;
        }
        int position = n2;
        return this.getItems().get(position);
    }

    @Override
    public void notifyItemChanged(@NotNull RecyclerAdapterViewHolder holder) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Integer n = holder.getBindingAdapterPosition();
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Integer n2 = !this.isOutOfItemsRange(it) ? n : null;
        if (n2 == null) {
            return;
        }
        int position = n2;
        this.notifyChangedPosition(position);
    }

    @NotNull
    public final RecyclerAdapter add(@NotNull AdapterItem<?> item, @Nullable Integer position) {
        int n;
        Intrinsics.checkNotNullParameter(item, (String)"item");
        if (position != null) {
            if (position >= this.getItems().size()) {
                this.getItems().add(ExtensionsKt.castAsIn(item));
                n = CollectionsKt.getLastIndex((List)this.getItems());
            } else if (position < 0) {
                this.getItems().add(0, ExtensionsKt.castAsIn(item));
                n = 0;
            } else {
                this.getItems().add(position, ExtensionsKt.castAsIn(item));
                n = position;
            }
        } else {
            this.getItems().add(ExtensionsKt.castAsIn(item));
            n = CollectionsKt.getLastIndex((List)this.getItems());
        }
        int insertPosition = n;
        this.registerItemType(item);
        this.notifyItemInserted(insertPosition);
        return this;
    }

    public static /* synthetic */ RecyclerAdapter add$default(RecyclerAdapter recyclerAdapter, AdapterItem adapterItem, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return recyclerAdapter.add(adapterItem, n);
    }

    @NotNull
    public final RecyclerAdapter add(@NotNull List<? extends AdapterItem<?>> newItems, @Nullable Integer startingPosition) {
        Intrinsics.checkNotNullParameter(newItems, (String)"newItems");
        if (newItems.isEmpty()) {
            return this;
        }
        int firstIndex = this.getItems().size();
        if (startingPosition == null) {
            this.getItems().ensureCapacity(this.getItems().size() + newItems.size());
            Iterable $this$forEach$iv = newItems;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AdapterItem it = (AdapterItem)element$iv;
                boolean bl = false;
                this.registerItemType(it);
                this.getItems().add(ExtensionsKt.castAsIn(it));
            }
        } else {
            Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)newItems);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AdapterItem it = (AdapterItem)element$iv;
                boolean bl = false;
                this.registerItemType(it);
                this.getItems().add(startingPosition, ExtensionsKt.castAsIn(it));
            }
        }
        this.notifyItemRangeInserted(firstIndex, newItems.size());
        return this;
    }

    public static /* synthetic */ RecyclerAdapter add$default(RecyclerAdapter recyclerAdapter, List list, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return recyclerAdapter.add(list, n);
    }

    @NotNull
    public final RecyclerAdapter addOrUpdate(@NotNull AdapterItem<?> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        Integer n = CollectionsKt.indexOf((List)this.getItems(), item);
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Integer n2 = it >= 0 ? n : null;
        if (n2 == null) {
            return RecyclerAdapter.add$default(this, item, null, 2, null);
        }
        int itemIndex = n2;
        if (this.getItems().get(itemIndex).hasToBeReplacedBy(item)) {
            this.updateItemAtPosition(ExtensionsKt.castAsIn(item), itemIndex);
        }
        return this;
    }

    @NotNull
    public final RecyclerAdapter addOrUpdate(@NotNull List<? extends AdapterItem<?>> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Iterable $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AdapterItem it = (AdapterItem)element$iv;
            boolean bl = false;
            this.addOrUpdate(it);
        }
        return this;
    }

    @NotNull
    public final RecyclerAdapter syncWithItems(@NotNull List<? extends AdapterItem<?>> newItems) {
        Intrinsics.checkNotNullParameter(newItems, (String)"newItems");
        if (newItems.isEmpty()) {
            this.clear();
            return this;
        }
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new Differ((List)this.getItems(), newItems));
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"DiffUtil.calculateDiff(D\u2026ems, newList = newItems))");
        DiffUtil.DiffResult diffResult2 = diffResult;
        this.getItems().clear();
        this.types.clear();
        Iterable $this$forEach$iv = newItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AdapterItem it = (AdapterItem)element$iv;
            boolean bl = false;
            AdapterItem newItem = ExtensionsKt.castAsIn(it);
            this.registerItemType(newItem);
            this.getItems().add(newItem);
        }
        diffResult2.dispatchUpdatesTo((RecyclerView.Adapter)this);
        return this;
    }

    public final boolean removeItem(@NotNull AdapterItem<?> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        Integer n = CollectionsKt.indexOf((List)this.getItems(), item);
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Integer n2 = it >= 0 ? n : null;
        if (n2 == null) {
            return false;
        }
        int itemIndex = n2;
        return this.removeItemAtPosition(itemIndex);
    }

    public final boolean removeItemAtPosition(int position) {
        boolean bl;
        ArrayList<AdapterItem<? super RecyclerAdapterViewHolder>> arrayList = this.getItems();
        boolean bl2 = false;
        boolean bl3 = false;
        ArrayList<AdapterItem<? super RecyclerAdapterViewHolder>> it = arrayList;
        boolean bl4 = false;
        Collection collection = it;
        boolean bl5 = false;
        ArrayList<AdapterItem<? super RecyclerAdapterViewHolder>> arrayList2 = !collection.isEmpty() && !this.isOutOfItemsRange(position) ? arrayList : null;
        if (arrayList2 != null) {
            arrayList = arrayList2;
            bl2 = false;
            bl3 = false;
            ArrayList<AdapterItem<? super RecyclerAdapterViewHolder>> items = arrayList;
            boolean bl6 = false;
            items.remove(position);
            this.notifyItemRemoved(position);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void clear() {
        ArrayList<AdapterItem<? super RecyclerAdapterViewHolder>> arrayList = this.getItems();
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<AdapterItem<? super RecyclerAdapterViewHolder>> it = arrayList;
        boolean bl3 = false;
        int itemsSize = it.size();
        it.clear();
        if (itemsSize > 0) {
            this.notifyItemRangeRemoved(0, itemsSize);
        }
    }

    public final void swap(int sourcePosition, int targetPosition) {
        Collections.swap((List)this.getItems(), sourcePosition, targetPosition);
        this.notifyItemMoved(sourcePosition, targetPosition);
    }

    /*
     * WARNING - void declaration
     */
    public final void filter(@Nullable String searchTerm) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        if (this.itemsList.isEmpty()) {
            return;
        }
        Object object = searchTerm;
        boolean bl = false;
        boolean bl2 = false;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            this.showFiltered = false;
            this.notifyDataSetChanged();
            return;
        }
        object = this.filtered;
        bl = false;
        bl2 = false;
        Object $this$apply = object;
        boolean bl3 = false;
        ((ArrayList)$this$apply).clear();
        Iterable iterable = this.itemsList;
        Object object2 = $this$apply;
        boolean $i$f$filter = false;
        void var10_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AdapterItem it = (AdapterItem)element$iv$iv;
            boolean bl4 = false;
            if (!it.onFilter(searchTerm)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        ((ArrayList)object2).addAll(list);
        this.showFiltered = true;
        this.notifyDataSetChanged();
    }

    public RecyclerAdapter() {
        this.setHasStableIds(true);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u001d\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016R\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/gotev/recycleradapter/RecyclerAdapter$Differ;", "Landroidx/recyclerview/widget/DiffUtil$Callback;", "oldList", "", "Lnet/gotev/recycleradapter/AdapterItem;", "newList", "(Ljava/util/List;Ljava/util/List;)V", "areContentsTheSame", "", "oldItemPosition", "", "newItemPosition", "areItemsTheSame", "getChangePayload", "(II)Ljava/lang/Boolean;", "getNewListSize", "getOldListSize", "recycleradapter_release"})
    private static final class Differ
    extends DiffUtil.Callback {
        private final List<AdapterItem<?>> oldList;
        private final List<AdapterItem<?>> newList;

        public int getOldListSize() {
            return this.oldList.size();
        }

        public int getNewListSize() {
            return this.newList.size();
        }

        public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
            return Intrinsics.areEqual(this.oldList.get(oldItemPosition), this.newList.get(newItemPosition));
        }

        public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
            return !this.oldList.get(oldItemPosition).hasToBeReplacedBy(this.newList.get(newItemPosition));
        }

        @NotNull
        public Boolean getChangePayload(int oldItemPosition, int newItemPosition) {
            return true;
        }

        public Differ(@NotNull List<? extends AdapterItem<?>> oldList, @NotNull List<? extends AdapterItem<?>> newList) {
            Intrinsics.checkNotNullParameter(oldList, (String)"oldList");
            Intrinsics.checkNotNullParameter(newList, (String)"newList");
            this.oldList = oldList;
            this.newList = newList;
        }
    }
}

