/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.speech;

import android.content.Context;
import android.os.Handler;
import java.util.Timer;
import java.util.TimerTask;
import net.gotev.speech.Logger;

public class DelayedOperation {
    private static final String LOG_TAG = DelayedOperation.class.getSimpleName();
    private long mDelay;
    private Operation mOperation;
    private Timer mTimer;
    private boolean started;
    private Context mContext;
    private String mTag;

    public DelayedOperation(Context context, String tag, long delayInMilliseconds) {
        if (context == null) {
            throw new IllegalArgumentException("Context is null");
        }
        if (delayInMilliseconds <= 0L) {
            throw new IllegalArgumentException("The delay in milliseconds must be > 0");
        }
        this.mContext = context;
        this.mTag = tag;
        this.mDelay = delayInMilliseconds;
        Logger.debug(LOG_TAG, "created delayed operation with tag: " + this.mTag);
    }

    public void start(Operation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("The operation must be defined!");
        }
        Logger.debug(LOG_TAG, "starting delayed operation with tag: " + this.mTag);
        this.mOperation = operation;
        this.cancel();
        this.started = true;
        this.resetTimer();
    }

    public void resetTimer() {
        if (!this.started) {
            return;
        }
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
        Logger.debug(LOG_TAG, "resetting delayed operation with tag: " + this.mTag);
        this.mTimer = new Timer();
        this.mTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (DelayedOperation.this.mOperation.shouldExecuteDelayedOperation()) {
                    Logger.debug(LOG_TAG, "executing delayed operation with tag: " + DelayedOperation.this.mTag);
                    new Handler(DelayedOperation.this.mContext.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            DelayedOperation.this.mOperation.onDelayedOperation();
                        }
                    });
                }
                this.cancel();
            }
        }, this.mDelay);
    }

    public void cancel() {
        if (this.mTimer != null) {
            Logger.debug(LOG_TAG, "cancelled delayed operation with tag: " + this.mTag);
            this.mTimer.cancel();
            this.mTimer = null;
        }
        this.started = false;
    }

    public static interface Operation {
        public void onDelayedOperation();

        public boolean shouldExecuteDelayedOperation();
    }
}

