/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.speech;

import net.gotev.speech.DefaultLoggerDelegate;

public class Logger {
    private LogLevel mLogLevel = LogLevel.OFF;
    private LoggerDelegate mDelegate = new DefaultLoggerDelegate();

    private Logger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetLoggerDelegate() {
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            SingletonHolder.instance.mDelegate = new DefaultLoggerDelegate();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoggerDelegate(LoggerDelegate delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate MUST not be null!");
        }
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            SingletonHolder.instance.mDelegate = delegate;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogLevel(LogLevel level) {
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            SingletonHolder.instance.mLogLevel = level;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void error(String tag, String message) {
        if (SingletonHolder.instance.mLogLevel.compareTo(LogLevel.ERROR) <= 0) {
            SingletonHolder.instance.mDelegate.error(tag, message);
        }
    }

    public static void error(String tag, String message, Throwable exception) {
        if (SingletonHolder.instance.mLogLevel.compareTo(LogLevel.ERROR) <= 0) {
            SingletonHolder.instance.mDelegate.error(tag, message, exception);
        }
    }

    public static void info(String tag, String message) {
        if (SingletonHolder.instance.mLogLevel.compareTo(LogLevel.INFO) <= 0) {
            SingletonHolder.instance.mDelegate.info(tag, message);
        }
    }

    public static void debug(String tag, String message) {
        if (SingletonHolder.instance.mLogLevel.compareTo(LogLevel.DEBUG) <= 0) {
            SingletonHolder.instance.mDelegate.debug(tag, message);
        }
    }

    private static class SingletonHolder {
        private static final Logger instance = new Logger();

        private SingletonHolder() {
        }
    }

    public static interface LoggerDelegate {
        public void error(String var1, String var2);

        public void error(String var1, String var2, Throwable var3);

        public void debug(String var1, String var2);

        public void info(String var1, String var2);
    }

    public static enum LogLevel {
        DEBUG,
        INFO,
        ERROR,
        OFF;

    }
}

