/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.speech;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.speech.RecognizerIntent;
import android.speech.tts.TextToSpeech;
import android.speech.tts.Voice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.gotev.speech.GoogleVoiceTypingDisabledException;
import net.gotev.speech.SpeechDelegate;
import net.gotev.speech.SpeechRecognitionNotAvailable;
import net.gotev.speech.SupportedLanguagesListener;
import net.gotev.speech.TextToSpeechCallback;
import net.gotev.speech.UnsupportedReason;
import net.gotev.speech.engine.BaseSpeechRecognitionEngine;
import net.gotev.speech.engine.BaseTextToSpeechEngine;
import net.gotev.speech.engine.DummyOnInitListener;
import net.gotev.speech.engine.SpeechRecognitionEngine;
import net.gotev.speech.engine.TextToSpeechEngine;
import net.gotev.speech.ui.SpeechProgressView;

public class Speech {
    private static Speech instance = null;
    protected static String GOOGLE_APP_PACKAGE = "com.google.android.googlequicksearchbox";
    private Context mContext;
    private TextToSpeechEngine textToSpeechEngine;
    private SpeechRecognitionEngine speechRecognitionEngine;

    private Speech(Context context, String callingPackage, TextToSpeech.OnInitListener onInitListener, SpeechRecognitionEngine speechRecognitionEngine, TextToSpeechEngine textToSpeechEngine) {
        this.mContext = context;
        this.speechRecognitionEngine = speechRecognitionEngine;
        this.speechRecognitionEngine.setCallingPackage(callingPackage);
        this.speechRecognitionEngine.initSpeechRecognizer(context);
        this.textToSpeechEngine = textToSpeechEngine;
        this.textToSpeechEngine.setOnInitListener(onInitListener);
        this.textToSpeechEngine.initTextToSpeech(context);
    }

    public static Speech init(Context context) {
        if (instance == null) {
            instance = new Speech(context, null, new DummyOnInitListener(), new BaseSpeechRecognitionEngine(), new BaseTextToSpeechEngine());
        }
        return instance;
    }

    public static Speech init(Context context, String callingPackage) {
        if (instance == null) {
            instance = new Speech(context, callingPackage, new DummyOnInitListener(), new BaseSpeechRecognitionEngine(), new BaseTextToSpeechEngine());
        }
        return instance;
    }

    public static Speech init(Context context, String callingPackage, TextToSpeech.OnInitListener onInitListener) {
        if (instance == null) {
            instance = new Speech(context, callingPackage, onInitListener, new BaseSpeechRecognitionEngine(), new BaseTextToSpeechEngine());
        }
        return instance;
    }

    public static Speech init(Context context, String callingPackage, TextToSpeech.OnInitListener onInitListener, SpeechRecognitionEngine speechRecognitionEngine, TextToSpeechEngine textToSpeechEngine) {
        if (instance == null) {
            instance = new Speech(context, callingPackage, onInitListener, speechRecognitionEngine, textToSpeechEngine);
        }
        return instance;
    }

    public synchronized void shutdown() {
        this.speechRecognitionEngine.shutdown();
        this.textToSpeechEngine.shutdown();
        instance = null;
    }

    public static Speech getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Speech recognition has not been initialized! call init method first!");
        }
        return instance;
    }

    public void startListening(SpeechDelegate delegate) throws SpeechRecognitionNotAvailable, GoogleVoiceTypingDisabledException {
        this.startListening(null, delegate);
    }

    public void startListening(SpeechProgressView progressView, SpeechDelegate delegate) throws SpeechRecognitionNotAvailable, GoogleVoiceTypingDisabledException {
        this.speechRecognitionEngine.startListening(progressView, delegate);
    }

    public void stopListening() {
        this.speechRecognitionEngine.stopListening();
    }

    public boolean isListening() {
        return this.speechRecognitionEngine.isListening();
    }

    public boolean isSpeaking() {
        return this.textToSpeechEngine.isSpeaking();
    }

    public void say(String message) {
        this.say(message, null);
    }

    public void say(String message, TextToSpeechCallback callback) {
        this.textToSpeechEngine.say(message, callback);
    }

    public void stopTextToSpeech() {
        this.textToSpeechEngine.stop();
    }

    public Speech setPreferOffline(boolean preferOffline) {
        this.speechRecognitionEngine.setPreferOffline(preferOffline);
        return this;
    }

    public Speech setGetPartialResults(boolean getPartialResults) {
        this.speechRecognitionEngine.setPartialResults(getPartialResults);
        return this;
    }

    public Speech setLocale(Locale locale) {
        this.speechRecognitionEngine.setLocale(locale);
        this.textToSpeechEngine.setLocale(locale);
        return this;
    }

    public Speech setTextToSpeechRate(float rate) {
        this.textToSpeechEngine.setSpeechRate(rate);
        return this;
    }

    public Speech setVoice(Voice voice) {
        this.textToSpeechEngine.setVoice(voice);
        return this;
    }

    public Speech setTextToSpeechPitch(float pitch) {
        this.textToSpeechEngine.setPitch(pitch);
        return this;
    }

    public Speech setStopListeningAfterInactivity(long milliseconds) {
        this.speechRecognitionEngine.setStopListeningAfterInactivity(milliseconds);
        this.speechRecognitionEngine.init(this.mContext);
        return this;
    }

    public Speech setTransitionMinimumDelay(long milliseconds) {
        this.speechRecognitionEngine.setTransitionMinimumDelay(milliseconds);
        return this;
    }

    public Speech setTextToSpeechQueueMode(int mode) {
        this.textToSpeechEngine.setTextToSpeechQueueMode(mode);
        return this;
    }

    public Speech setAudioStream(int audioStream) {
        this.textToSpeechEngine.setAudioStream(audioStream);
        return this;
    }

    private boolean isGoogleAppInstalled() {
        PackageManager packageManager = this.mContext.getPackageManager();
        for (PackageInfo packageInfo : packageManager.getInstalledPackages(0)) {
            if (!packageInfo.packageName.contains(GOOGLE_APP_PACKAGE)) continue;
            return true;
        }
        return false;
    }

    public void getSupportedSpeechToTextLanguages(final SupportedLanguagesListener listener) {
        if (!this.isGoogleAppInstalled()) {
            listener.onNotSupported(UnsupportedReason.GOOGLE_APP_NOT_FOUND);
            return;
        }
        Intent intent = RecognizerIntent.getVoiceDetailsIntent((Context)this.mContext);
        if (intent == null) {
            intent = new Intent("android.speech.action.GET_LANGUAGE_DETAILS");
            intent.setPackage(GOOGLE_APP_PACKAGE);
        }
        this.mContext.sendOrderedBroadcast(intent, null, new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                Bundle extras = this.getResultExtras(true);
                if (extras != null && extras.containsKey("android.speech.extra.SUPPORTED_LANGUAGES")) {
                    ArrayList languages = extras.getStringArrayList("android.speech.extra.SUPPORTED_LANGUAGES");
                    if (languages == null || languages.isEmpty()) {
                        listener.onNotSupported(UnsupportedReason.EMPTY_SUPPORTED_LANGUAGES);
                    } else {
                        Collections.sort(languages);
                        listener.onSupportedLanguages(languages);
                    }
                } else {
                    listener.onNotSupported(UnsupportedReason.EMPTY_SUPPORTED_LANGUAGES);
                }
            }
        }, null, -1, null, null);
    }

    public List<Voice> getSupportedTextToSpeechVoices() {
        return this.textToSpeechEngine.getSupportedVoices();
    }

    public Locale getSpeechToTextLanguage() {
        return this.speechRecognitionEngine.getLocale();
    }

    public Voice getTextToSpeechVoice() {
        return this.textToSpeechEngine.getCurrentVoice();
    }
}

