/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.speech;

public class SpeechRecognitionException
extends Exception {
    private int code;

    public SpeechRecognitionException(int code) {
        super(SpeechRecognitionException.getMessage(code));
        this.code = code;
    }

    private static String getMessage(int code) {
        String message;
        switch (code) {
            case 3: {
                message = code + " - Audio recording error";
                break;
            }
            case 9: {
                message = code + " - Insufficient permissions. Request android.permission.RECORD_AUDIO";
                break;
            }
            case 5: {
                message = code + " - Client side error. Maybe your internet connection is poor!";
                break;
            }
            case 2: {
                message = code + " - Network error";
                break;
            }
            case 1: {
                message = code + " - Network operation timed out";
                break;
            }
            case 7: {
                message = code + " - No recognition result matched. Try turning on partial results as a workaround.";
                break;
            }
            case 8: {
                message = code + " - RecognitionService busy";
                break;
            }
            case 4: {
                message = code + " - Server sends error status";
                break;
            }
            case 6: {
                message = code + " - No speech input";
                break;
            }
            default: {
                message = code + " - Unknown exception";
            }
        }
        return message;
    }

    public int getCode() {
        return this.code;
    }
}

