/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.speech;

import android.content.Context;
import android.os.Handler;
import android.speech.tts.UtteranceProgressListener;
import java.lang.ref.WeakReference;
import java.util.Map;
import net.gotev.speech.TextToSpeechCallback;

public class TtsProgressListener
extends UtteranceProgressListener {
    private final Map<String, TextToSpeechCallback> mTtsCallbacks;
    private final WeakReference<Context> contextWeakReference;

    public TtsProgressListener(Context context, Map<String, TextToSpeechCallback> mTtsCallbacks) {
        this.contextWeakReference = new WeakReference<Context>(context);
        this.mTtsCallbacks = mTtsCallbacks;
    }

    public void onStart(String utteranceId) {
        final TextToSpeechCallback callback = this.mTtsCallbacks.get(utteranceId);
        Context context = (Context)this.contextWeakReference.get();
        if (callback != null && context != null) {
            new Handler(context.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    callback.onStart();
                }
            });
        }
    }

    public void onDone(final String utteranceId) {
        final TextToSpeechCallback callback = this.mTtsCallbacks.get(utteranceId);
        Context context = (Context)this.contextWeakReference.get();
        if (callback != null && context != null) {
            new Handler(context.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    callback.onCompleted();
                    TtsProgressListener.this.mTtsCallbacks.remove(utteranceId);
                }
            });
        }
    }

    public void onError(final String utteranceId) {
        final TextToSpeechCallback callback = this.mTtsCallbacks.get(utteranceId);
        Context context = (Context)this.contextWeakReference.get();
        if (callback != null && context != null) {
            new Handler(context.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    callback.onError();
                    TtsProgressListener.this.mTtsCallbacks.remove(utteranceId);
                }
            });
        }
    }
}

