/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.speech.engine;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.speech.RecognitionListener;
import android.speech.SpeechRecognizer;
import android.widget.LinearLayout;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.gotev.speech.DelayedOperation;
import net.gotev.speech.GoogleVoiceTypingDisabledException;
import net.gotev.speech.Logger;
import net.gotev.speech.SpeechDelegate;
import net.gotev.speech.SpeechRecognitionException;
import net.gotev.speech.SpeechRecognitionNotAvailable;
import net.gotev.speech.engine.SpeechRecognitionEngine;
import net.gotev.speech.ui.SpeechProgressView;

public class BaseSpeechRecognitionEngine
implements SpeechRecognitionEngine {
    private static final String LOG_TAG = BaseSpeechRecognitionEngine.class.getSimpleName();
    private Context mContext;
    private SpeechRecognizer mSpeechRecognizer;
    private SpeechDelegate mDelegate;
    private SpeechProgressView mProgressView;
    private String mCallingPackage;
    private String mUnstableData;
    private DelayedOperation mDelayedStopListening;
    private final List<String> mPartialData = new ArrayList<String>();
    private List<String> mLastPartialResults = null;
    private Locale mLocale = Locale.getDefault();
    private boolean mPreferOffline = false;
    private boolean mGetPartialResults = true;
    private boolean mIsListening = false;
    private long mLastActionTimestamp;
    private long mStopListeningDelayInMs = 4000L;
    private long mTransitionMinimumDelay = 1200L;

    @Override
    public void init(Context context) {
        this.initDelayedStopListening(context);
    }

    @Override
    public void clear() {
        this.mPartialData.clear();
        this.mUnstableData = null;
    }

    public void onReadyForSpeech(Bundle bundle) {
        this.mPartialData.clear();
        this.mUnstableData = null;
    }

    public void onBeginningOfSpeech() {
        if (this.mProgressView != null) {
            this.mProgressView.onBeginningOfSpeech();
        }
        this.mDelayedStopListening.start(new DelayedOperation.Operation(){

            @Override
            public void onDelayedOperation() {
                BaseSpeechRecognitionEngine.this.returnPartialResultsAndRecreateSpeechRecognizer();
            }

            @Override
            public boolean shouldExecuteDelayedOperation() {
                return true;
            }
        });
    }

    public void onRmsChanged(float v) {
        try {
            if (this.mDelegate != null) {
                this.mDelegate.onSpeechRmsChanged(v);
            }
        }
        catch (Throwable exc) {
            Logger.error(this.getClass().getSimpleName(), "Unhandled exception in delegate onSpeechRmsChanged", exc);
        }
        if (this.mProgressView != null) {
            this.mProgressView.onRmsChanged(v);
        }
    }

    public void onPartialResults(Bundle bundle) {
        this.mDelayedStopListening.resetTimer();
        ArrayList partialResults = bundle.getStringArrayList("results_recognition");
        ArrayList unstableData = bundle.getStringArrayList("android.speech.extra.UNSTABLE_TEXT");
        if (partialResults != null && !partialResults.isEmpty()) {
            this.mPartialData.clear();
            this.mPartialData.addAll(partialResults);
            this.mUnstableData = unstableData != null && !unstableData.isEmpty() ? (String)unstableData.get(0) : null;
            try {
                if (this.mLastPartialResults == null || !this.mLastPartialResults.equals(partialResults)) {
                    if (this.mDelegate != null) {
                        this.mDelegate.onSpeechPartialResults(partialResults);
                    }
                    this.mLastPartialResults = partialResults;
                }
            }
            catch (Throwable exc) {
                Logger.error(this.getClass().getSimpleName(), "Unhandled exception in delegate onSpeechPartialResults", exc);
            }
        }
    }

    public void onResults(Bundle bundle) {
        String result;
        this.mDelayedStopListening.cancel();
        ArrayList results = bundle.getStringArrayList("results_recognition");
        if (results != null && !results.isEmpty() && results.get(0) != null && !((String)results.get(0)).isEmpty()) {
            result = (String)results.get(0);
        } else {
            Logger.info(this.getClass().getSimpleName(), "No speech results, getting partial");
            result = this.getPartialResultsAsString();
        }
        this.mIsListening = false;
        try {
            if (this.mDelegate != null) {
                this.mDelegate.onSpeechResult(result.trim());
            }
        }
        catch (Throwable exc) {
            Logger.error(this.getClass().getSimpleName(), "Unhandled exception in delegate onSpeechResult", exc);
        }
        if (this.mProgressView != null) {
            this.mProgressView.onResultOrOnError();
        }
        this.initSpeechRecognizer(this.mContext);
    }

    public void onError(int code) {
        Logger.error(LOG_TAG, "Speech recognition error", new SpeechRecognitionException(code));
        this.returnPartialResultsAndRecreateSpeechRecognizer();
    }

    public void onBufferReceived(byte[] bytes) {
    }

    public void onEndOfSpeech() {
        if (this.mProgressView != null) {
            this.mProgressView.onEndOfSpeech();
        }
    }

    public void onEvent(int i, Bundle bundle) {
    }

    @Override
    public String getPartialResultsAsString() {
        StringBuilder out = new StringBuilder("");
        for (String partial : this.mPartialData) {
            out.append(partial).append(" ");
        }
        if (this.mUnstableData != null && !this.mUnstableData.isEmpty()) {
            out.append(this.mUnstableData);
        }
        return out.toString().trim();
    }

    @Override
    public void startListening(SpeechProgressView progressView, SpeechDelegate delegate) throws SpeechRecognitionNotAvailable, GoogleVoiceTypingDisabledException {
        if (this.mIsListening) {
            return;
        }
        if (this.mSpeechRecognizer == null) {
            throw new SpeechRecognitionNotAvailable();
        }
        if (delegate == null) {
            throw new IllegalArgumentException("delegate must be defined!");
        }
        if (this.throttleAction()) {
            Logger.debug(this.getClass().getSimpleName(), "Hey man calm down! Throttling start to prevent disaster!");
            return;
        }
        this.mProgressView = progressView;
        this.mDelegate = delegate;
        if (progressView != null && !(progressView.getParent() instanceof LinearLayout)) {
            throw new IllegalArgumentException("progressView must be put inside a LinearLayout!");
        }
        Intent intent = new Intent("android.speech.action.RECOGNIZE_SPEECH").putExtra("android.speech.extra.MAX_RESULTS", 1).putExtra("android.speech.extra.PARTIAL_RESULTS", this.mGetPartialResults).putExtra("android.speech.extra.LANGUAGE", this.mLocale.getLanguage()).putExtra("android.speech.extra.LANGUAGE_MODEL", "free_form");
        if (this.mCallingPackage != null && !this.mCallingPackage.isEmpty()) {
            intent.putExtra("calling_package", this.mCallingPackage);
        }
        if (Build.VERSION.SDK_INT >= 23) {
            intent.putExtra("android.speech.extra.PREFER_OFFLINE", this.mPreferOffline);
        }
        try {
            this.mSpeechRecognizer.startListening(intent);
        }
        catch (SecurityException exc) {
            throw new GoogleVoiceTypingDisabledException();
        }
        this.mIsListening = true;
        this.updateLastActionTimestamp();
        try {
            if (this.mDelegate != null) {
                this.mDelegate.onStartOfSpeech();
            }
        }
        catch (Throwable exc) {
            Logger.error(this.getClass().getSimpleName(), "Unhandled exception in delegate onStartOfSpeech", exc);
        }
    }

    @Override
    public boolean isListening() {
        return this.mIsListening;
    }

    @Override
    public Locale getLocale() {
        return this.mLocale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.mLocale = locale;
    }

    @Override
    public void stopListening() {
        if (!this.mIsListening) {
            return;
        }
        if (this.throttleAction()) {
            Logger.debug(this.getClass().getSimpleName(), "Hey man calm down! Throttling stop to prevent disaster!");
            return;
        }
        this.mIsListening = false;
        this.updateLastActionTimestamp();
        this.returnPartialResultsAndRecreateSpeechRecognizer();
    }

    @Override
    public void initSpeechRecognizer(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context must be defined!");
        }
        this.mContext = context;
        if (SpeechRecognizer.isRecognitionAvailable((Context)context)) {
            if (this.mSpeechRecognizer != null) {
                try {
                    this.mSpeechRecognizer.destroy();
                }
                catch (Throwable exc) {
                    Logger.debug(this.getClass().getSimpleName(), "Non-Fatal error while destroying speech. " + exc.getMessage());
                }
                finally {
                    this.mSpeechRecognizer = null;
                }
            }
            this.mSpeechRecognizer = SpeechRecognizer.createSpeechRecognizer((Context)context);
            this.mSpeechRecognizer.setRecognitionListener((RecognitionListener)this);
            this.init(context);
        } else {
            this.mSpeechRecognizer = null;
        }
        this.clear();
    }

    @Override
    public void returnPartialResultsAndRecreateSpeechRecognizer() {
        this.mIsListening = false;
        try {
            if (this.mDelegate != null) {
                this.mDelegate.onSpeechResult(this.getPartialResultsAsString());
            }
        }
        catch (Throwable exc) {
            Logger.error(this.getClass().getSimpleName(), "Unhandled exception in delegate onSpeechResult", exc);
        }
        if (this.mProgressView != null) {
            this.mProgressView.onResultOrOnError();
        }
        this.initSpeechRecognizer(this.mContext);
    }

    @Override
    public void setPartialResults(boolean getPartialResults) {
        this.mGetPartialResults = getPartialResults;
    }

    @Override
    public void unregisterDelegate() {
        this.mProgressView = null;
        this.mDelegate = null;
    }

    @Override
    public void setPreferOffline(boolean preferOffline) {
        this.mPreferOffline = preferOffline;
    }

    private void initDelayedStopListening(Context context) {
        if (this.mDelayedStopListening != null) {
            this.mDelayedStopListening.cancel();
            this.mDelayedStopListening = null;
            this.stopDueToDelay();
        }
        this.mDelayedStopListening = new DelayedOperation(context, "delayStopListening", this.mStopListeningDelayInMs);
    }

    protected void stopDueToDelay() {
    }

    private void updateLastActionTimestamp() {
        this.mLastActionTimestamp = new Date().getTime();
    }

    private boolean throttleAction() {
        return new Date().getTime() <= this.mLastActionTimestamp + this.mTransitionMinimumDelay;
    }

    @Override
    public void setCallingPackage(String callingPackage) {
        this.mCallingPackage = callingPackage;
    }

    @Override
    public void setTransitionMinimumDelay(long milliseconds) {
        this.mTransitionMinimumDelay = milliseconds;
    }

    @Override
    public void setStopListeningAfterInactivity(long milliseconds) {
        this.mStopListeningDelayInMs = milliseconds;
    }

    @Override
    public void shutdown() {
        if (this.mSpeechRecognizer != null) {
            try {
                this.mSpeechRecognizer.stopListening();
                this.mSpeechRecognizer.destroy();
            }
            catch (Exception exc) {
                Logger.error(this.getClass().getSimpleName(), "Warning while de-initing speech recognizer", exc);
            }
        }
        this.unregisterDelegate();
    }
}

