/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.speech.engine;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.speech.tts.TextToSpeech;
import android.speech.tts.UtteranceProgressListener;
import android.speech.tts.Voice;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.gotev.speech.Logger;
import net.gotev.speech.TextToSpeechCallback;
import net.gotev.speech.TtsProgressListener;
import net.gotev.speech.engine.TextToSpeechEngine;

public class BaseTextToSpeechEngine
implements TextToSpeechEngine {
    private TextToSpeech mTextToSpeech;
    private TextToSpeech.OnInitListener mTttsInitListener;
    private UtteranceProgressListener mTtsProgressListener;
    private float mTtsRate = 1.0f;
    private float mTtsPitch = 1.0f;
    private Locale mLocale = Locale.getDefault();
    private Voice voice;
    private int mTtsQueueMode = 0;
    private int mAudioStream = 3;
    private final Map<String, TextToSpeechCallback> mTtsCallbacks = new HashMap<String, TextToSpeechCallback>();

    @Override
    public void initTextToSpeech(Context context) {
        if (this.mTextToSpeech != null) {
            return;
        }
        this.mTtsProgressListener = new TtsProgressListener(context, this.mTtsCallbacks);
        this.mTextToSpeech = new TextToSpeech(context.getApplicationContext(), this.mTttsInitListener);
        this.mTextToSpeech.setOnUtteranceProgressListener(this.mTtsProgressListener);
        this.mTextToSpeech.setLanguage(this.mLocale);
        this.mTextToSpeech.setPitch(this.mTtsPitch);
        this.mTextToSpeech.setSpeechRate(this.mTtsRate);
        if (Build.VERSION.SDK_INT >= 21) {
            if (this.voice == null) {
                this.voice = this.mTextToSpeech.getDefaultVoice();
            }
            this.mTextToSpeech.setVoice(this.voice);
        }
    }

    @Override
    public boolean isSpeaking() {
        if (this.mTextToSpeech == null) {
            return false;
        }
        return this.mTextToSpeech.isSpeaking();
    }

    @Override
    public void setOnInitListener(TextToSpeech.OnInitListener onInitListener) {
        this.mTttsInitListener = onInitListener;
    }

    @Override
    public void setLocale(Locale locale) {
        this.mLocale = locale;
        if (this.mTextToSpeech != null) {
            this.mTextToSpeech.setLanguage(locale);
        }
    }

    @Override
    public void say(String message, TextToSpeechCallback callback) {
        String utteranceId = UUID.randomUUID().toString();
        if (callback != null) {
            this.mTtsCallbacks.put(utteranceId, callback);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            Bundle params = new Bundle();
            params.putString("streamType", String.valueOf(this.mAudioStream));
            this.mTextToSpeech.speak((CharSequence)message, this.mTtsQueueMode, params, utteranceId);
        } else {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("streamType", String.valueOf(this.mAudioStream));
            params.put("utteranceId", utteranceId);
            this.mTextToSpeech.speak(message, this.mTtsQueueMode, params);
        }
    }

    @Override
    public void shutdown() {
        if (this.mTextToSpeech != null) {
            try {
                this.mTtsCallbacks.clear();
                this.mTextToSpeech.stop();
                this.mTextToSpeech.shutdown();
            }
            catch (Exception exc) {
                Logger.error(this.getClass().getSimpleName(), "Warning while de-initing text to speech", exc);
            }
        }
    }

    @Override
    public void setTextToSpeechQueueMode(int mode) {
        this.mTtsQueueMode = mode;
    }

    @Override
    public void setAudioStream(int audioStream) {
        this.mAudioStream = audioStream;
    }

    @Override
    public void stop() {
        if (this.mTextToSpeech != null) {
            this.mTextToSpeech.stop();
        }
    }

    @Override
    public void setPitch(float pitch) {
        this.mTtsPitch = pitch;
        if (this.mTextToSpeech != null) {
            this.mTextToSpeech.setPitch(pitch);
        }
    }

    @Override
    public void setSpeechRate(float rate) {
        this.mTtsRate = rate;
        if (this.mTextToSpeech != null) {
            this.mTextToSpeech.setSpeechRate(rate);
        }
    }

    @Override
    public void setVoice(Voice voice) {
        this.voice = voice;
        if (this.mTextToSpeech != null && Build.VERSION.SDK_INT >= 21) {
            this.mTextToSpeech.setVoice(voice);
        }
    }

    @Override
    public List<Voice> getSupportedVoices() {
        if (this.mTextToSpeech != null && Build.VERSION.SDK_INT >= 23) {
            Set voices = this.mTextToSpeech.getVoices();
            ArrayList<Voice> voicesList = new ArrayList<Voice>(voices.size());
            voicesList.addAll(voices);
            return voicesList;
        }
        return new ArrayList<Voice>(1);
    }

    @Override
    public Voice getCurrentVoice() {
        if (this.mTextToSpeech != null && Build.VERSION.SDK_INT >= 23) {
            return this.mTextToSpeech.getVoice();
        }
        return null;
    }
}

