/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.speech.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import java.util.ArrayList;
import java.util.List;
import net.gotev.speech.ui.SpeechBar;
import net.gotev.speech.ui.animators.BarParamsAnimator;
import net.gotev.speech.ui.animators.IdleAnimator;
import net.gotev.speech.ui.animators.RmsAnimator;
import net.gotev.speech.ui.animators.RotatingAnimator;
import net.gotev.speech.ui.animators.TransformAnimator;

public class SpeechProgressView
extends View {
    public static final int BARS_COUNT = 5;
    private static final int CIRCLE_RADIUS_DP = 5;
    private static final int CIRCLE_SPACING_DP = 11;
    private static final int ROTATION_RADIUS_DP = 25;
    private static final int IDLE_FLOATING_AMPLITUDE_DP = 3;
    private static final int[] DEFAULT_BARS_HEIGHT_DP = new int[]{60, 46, 70, 54, 64};
    private static final float MDPI_DENSITY = 1.5f;
    private final List<SpeechBar> speechBars = new ArrayList<SpeechBar>();
    private Paint paint;
    private BarParamsAnimator animator;
    private int radius;
    private int spacing;
    private int rotationRadius;
    private int amplitude;
    private float density;
    private boolean isSpeaking;
    private boolean animating;
    private int barColor = -1;
    private int[] barColors = new int[]{Color.parseColor((String)"#3164d7"), Color.parseColor((String)"#d92d29"), Color.parseColor((String)"#eeaa10"), Color.parseColor((String)"#3164d7"), Color.parseColor((String)"#2e9641")};
    private int[] barMaxHeights = new int[]{60, 76, 58, 80, 55};

    public SpeechProgressView(Context context) {
        super(context);
        this.init();
    }

    public SpeechProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SpeechProgressView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void play() {
        this.startIdleInterpolation();
        this.animating = true;
    }

    public void stop() {
        if (this.animator != null) {
            this.animator.stop();
            this.animator = null;
        }
        this.isSpeaking = false;
        this.animating = false;
        this.resetBars();
    }

    public void setSingleColor(int color) {
        this.barColor = color;
    }

    public void setColors(int[] colors) {
        if (colors == null) {
            return;
        }
        this.barColors = new int[5];
        if (colors.length < 5) {
            System.arraycopy(colors, 0, this.barColors, 0, colors.length);
            for (int i = colors.length; i < 5; ++i) {
                this.barColors[i] = colors[0];
            }
        } else {
            System.arraycopy(colors, 0, this.barColors, 0, 5);
        }
    }

    public void setBarMaxHeightsInDp(int[] heights) {
        if (heights == null) {
            return;
        }
        this.barMaxHeights = new int[5];
        if (heights.length < 5) {
            System.arraycopy(heights, 0, this.barMaxHeights, 0, heights.length);
            for (int i = heights.length; i < 5; ++i) {
                this.barMaxHeights[i] = heights[0];
            }
        } else {
            System.arraycopy(heights, 0, this.barMaxHeights, 0, 5);
        }
    }

    private void init() {
        this.paint = new Paint();
        this.paint.setFlags(1);
        this.paint.setColor(-7829368);
        this.density = this.getResources().getDisplayMetrics().density;
        this.radius = (int)(5.0f * this.density);
        this.spacing = (int)(11.0f * this.density);
        this.rotationRadius = (int)(25.0f * this.density);
        this.amplitude = (int)(3.0f * this.density);
        if (this.density <= 1.5f) {
            this.amplitude *= 2;
        }
        this.startIdleInterpolation();
        this.animating = true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.speechBars.isEmpty()) {
            this.initBars();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.speechBars.isEmpty()) {
            return;
        }
        if (this.animating) {
            this.animator.animate();
        }
        for (int i = 0; i < this.speechBars.size(); ++i) {
            SpeechBar bar = this.speechBars.get(i);
            if (this.barColors != null) {
                this.paint.setColor(this.barColors[i]);
            } else if (this.barColor != -1) {
                this.paint.setColor(this.barColor);
            }
            canvas.drawRoundRect(bar.getRect(), (float)this.radius, (float)this.radius, this.paint);
        }
        if (this.animating) {
            this.invalidate();
        }
    }

    private void initBars() {
        List<Integer> heights = this.initBarHeights();
        int firstCirclePosition = this.getMeasuredWidth() / 2 - 2 * this.spacing - 4 * this.radius;
        for (int i = 0; i < 5; ++i) {
            int x = firstCirclePosition + (2 * this.radius + this.spacing) * i;
            SpeechBar bar = new SpeechBar(x, this.getMeasuredHeight() / 2, 2 * this.radius, heights.get(i), this.radius);
            this.speechBars.add(bar);
        }
    }

    private List<Integer> initBarHeights() {
        ArrayList<Integer> barHeights = new ArrayList<Integer>();
        if (this.barMaxHeights == null) {
            for (int i = 0; i < 5; ++i) {
                barHeights.add((int)((float)DEFAULT_BARS_HEIGHT_DP[i] * this.density));
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                barHeights.add((int)((float)this.barMaxHeights[i] * this.density));
            }
        }
        return barHeights;
    }

    private void resetBars() {
        for (SpeechBar bar : this.speechBars) {
            bar.setX(bar.getStartX());
            bar.setY(bar.getStartY());
            bar.setHeight(this.radius * 2);
            bar.update();
        }
    }

    private void startIdleInterpolation() {
        this.animator = new IdleAnimator(this.speechBars, this.amplitude);
        this.animator.start();
    }

    private void startRmsInterpolation() {
        this.resetBars();
        this.animator = new RmsAnimator(this.speechBars);
        this.animator.start();
    }

    private void startTransformInterpolation() {
        this.resetBars();
        this.animator = new TransformAnimator(this.speechBars, this.getWidth() / 2, this.getHeight() / 2, this.rotationRadius);
        this.animator.start();
        ((TransformAnimator)this.animator).setOnInterpolationFinishedListener(new TransformAnimator.OnInterpolationFinishedListener(){

            @Override
            public void onFinished() {
                SpeechProgressView.this.startRotateInterpolation();
            }
        });
    }

    private void startRotateInterpolation() {
        this.animator = new RotatingAnimator(this.speechBars, this.getWidth() / 2, this.getHeight() / 2);
        this.animator.start();
    }

    public void onBeginningOfSpeech() {
        this.isSpeaking = true;
    }

    public void onRmsChanged(float rmsdB) {
        if (this.animator == null || rmsdB < 1.0f) {
            return;
        }
        if (!(this.animator instanceof RmsAnimator) && this.isSpeaking) {
            this.startRmsInterpolation();
        }
        if (this.animator instanceof RmsAnimator) {
            ((RmsAnimator)this.animator).onRmsChanged(rmsdB);
        }
    }

    public void onEndOfSpeech() {
        this.isSpeaking = false;
        this.startTransformInterpolation();
    }

    public void onResultOrOnError() {
        this.stop();
        this.play();
    }
}

