/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.speech.ui.animators;

import java.util.List;
import net.gotev.speech.ui.SpeechBar;
import net.gotev.speech.ui.animators.BarParamsAnimator;

public class IdleAnimator
implements BarParamsAnimator {
    private static final long IDLE_DURATION = 1500L;
    private long startTimestamp;
    private boolean isPlaying;
    private final int floatingAmplitude;
    private final List<SpeechBar> bars;

    public IdleAnimator(List<SpeechBar> bars, int floatingAmplitude) {
        this.floatingAmplitude = floatingAmplitude;
        this.bars = bars;
    }

    @Override
    public void start() {
        this.isPlaying = true;
        this.startTimestamp = System.currentTimeMillis();
    }

    @Override
    public void stop() {
        this.isPlaying = false;
    }

    @Override
    public void animate() {
        if (this.isPlaying) {
            this.update(this.bars);
        }
    }

    public void update(List<SpeechBar> bars) {
        long currTimestamp = System.currentTimeMillis();
        if (currTimestamp - this.startTimestamp > 1500L) {
            this.startTimestamp += 1500L;
        }
        long delta = currTimestamp - this.startTimestamp;
        int i = 0;
        for (SpeechBar bar : bars) {
            this.updateCirclePosition(bar, delta, i);
            ++i;
        }
    }

    private void updateCirclePosition(SpeechBar bar, long delta, int num) {
        float angle = (float)delta / 1500.0f * 360.0f + 120.0f * (float)num;
        int y = (int)(Math.sin(Math.toRadians(angle)) * (double)this.floatingAmplitude) + bar.getStartY();
        bar.setY(y);
        bar.update();
    }
}

