/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.speech.ui.animators;

import android.graphics.Point;
import android.view.animation.AccelerateDecelerateInterpolator;
import java.util.ArrayList;
import java.util.List;
import net.gotev.speech.ui.SpeechBar;
import net.gotev.speech.ui.animators.BarParamsAnimator;

public class RotatingAnimator
implements BarParamsAnimator {
    private static final long DURATION = 2000L;
    private static final long ACCELERATE_ROTATION_DURATION = 1000L;
    private static final long DECELERATE_ROTATION_DURATION = 1000L;
    private static final float ROTATION_DEGREES = 720.0f;
    private static final float ACCELERATION_ROTATION_DEGREES = 40.0f;
    private long startTimestamp;
    private boolean isPlaying;
    private final int centerX;
    private final int centerY;
    private final List<Point> startPositions;
    private final List<SpeechBar> bars;

    public RotatingAnimator(List<SpeechBar> bars, int centerX, int centerY) {
        this.centerX = centerX;
        this.centerY = centerY;
        this.bars = bars;
        this.startPositions = new ArrayList<Point>();
        for (SpeechBar bar : bars) {
            this.startPositions.add(new Point(bar.getX(), bar.getY()));
        }
    }

    @Override
    public void start() {
        this.isPlaying = true;
        this.startTimestamp = System.currentTimeMillis();
    }

    @Override
    public void stop() {
        this.isPlaying = false;
    }

    @Override
    public void animate() {
        if (!this.isPlaying) {
            return;
        }
        long currTimestamp = System.currentTimeMillis();
        if (currTimestamp - this.startTimestamp > 2000L) {
            this.startTimestamp += 2000L;
        }
        long delta = currTimestamp - this.startTimestamp;
        float interpolatedTime = (float)delta / 2000.0f;
        float angle = interpolatedTime * 720.0f;
        int i = 0;
        for (SpeechBar bar : this.bars) {
            float finalAngle = angle;
            if (i > 0 && delta > 1000L) {
                finalAngle += this.decelerate(delta, this.bars.size() - i);
            } else if (i > 0) {
                finalAngle += this.accelerate(delta, this.bars.size() - i);
            }
            this.rotate(bar, finalAngle, this.startPositions.get(i));
            ++i;
        }
    }

    private float decelerate(long delta, int scale) {
        long accelerationDelta = delta - 1000L;
        AccelerateDecelerateInterpolator interpolator = new AccelerateDecelerateInterpolator();
        float interpolatedTime = interpolator.getInterpolation((float)accelerationDelta / 1000.0f);
        float decelerationAngle = -interpolatedTime * (40.0f * (float)scale);
        return 40.0f * (float)scale + decelerationAngle;
    }

    private float accelerate(long delta, int scale) {
        long accelerationDelta = delta;
        AccelerateDecelerateInterpolator interpolator = new AccelerateDecelerateInterpolator();
        float interpolatedTime = interpolator.getInterpolation((float)accelerationDelta / 1000.0f);
        float accelerationAngle = interpolatedTime * (40.0f * (float)scale);
        return accelerationAngle;
    }

    private void rotate(SpeechBar bar, double degrees, Point startPosition) {
        double angle = Math.toRadians(degrees);
        int x = this.centerX + (int)((double)(startPosition.x - this.centerX) * Math.cos(angle) - (double)(startPosition.y - this.centerY) * Math.sin(angle));
        int y = this.centerY + (int)((double)(startPosition.x - this.centerX) * Math.sin(angle) + (double)(startPosition.y - this.centerY) * Math.cos(angle));
        bar.setX(x);
        bar.setY(y);
        bar.update();
    }
}

