/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.okhttp;

import android.os.Build;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import net.gotev.uploadservice.Logger;
import net.gotev.uploadservice.NameValue;
import net.gotev.uploadservice.ServerResponse;
import net.gotev.uploadservice.http.BodyWriter;
import net.gotev.uploadservice.http.HttpConnection;
import net.gotev.uploadservice.okhttp.OkHttpBodyWriter;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;
import okio.BufferedSink;

public class OkHttpStackConnection
implements HttpConnection {
    private static final String LOG_TAG = OkHttpStackConnection.class.getSimpleName();
    private OkHttpClient mClient;
    private Request.Builder mRequestBuilder;
    private String mMethod;
    private long mBodyLength;
    private String mContentType;
    private Response mResponse;

    public OkHttpStackConnection(OkHttpClient client, String method, String url) throws IOException {
        Logger.debug((String)this.getClass().getSimpleName(), (String)"creating new connection");
        this.mResponse = null;
        this.mClient = client;
        this.mMethod = method;
        this.mRequestBuilder = new Request.Builder().url(new URL(url));
    }

    public void setHeaders(List<NameValue> requestHeaders) throws IOException {
        for (NameValue param : requestHeaders) {
            if ("Content-Type".equalsIgnoreCase(param.getName())) {
                this.mContentType = param.getValue();
            }
            this.mRequestBuilder.header(param.getName(), param.getValue());
        }
    }

    public void setTotalBodyBytes(long totalBodyBytes, boolean isFixedLengthStreamingMode) {
        if (isFixedLengthStreamingMode) {
            if (Build.VERSION.SDK_INT < 19 && totalBodyBytes > Integer.MAX_VALUE) {
                throw new RuntimeException("You need Android API version 19 or newer to upload more than 2GB in a single request using fixed size content length. Try switching to chunked mode instead, but make sure your server side supports it!");
            }
            this.mBodyLength = totalBodyBytes;
        } else {
            this.mBodyLength = -1L;
        }
    }

    private LinkedHashMap<String, String> getServerResponseHeaders(Headers headers) throws IOException {
        LinkedHashMap<String, String> out = new LinkedHashMap<String, String>(headers.size());
        for (String headerName : headers.names()) {
            out.put(headerName, headers.get(headerName));
        }
        return out;
    }

    public ServerResponse getResponse(final HttpConnection.RequestBodyDelegate delegate) throws IOException {
        if (HttpMethod.permitsRequestBody((String)this.mMethod) || HttpMethod.requiresRequestBody((String)this.mMethod)) {
            RequestBody body = new RequestBody(){

                public long contentLength() throws IOException {
                    return OkHttpStackConnection.this.mBodyLength;
                }

                public MediaType contentType() {
                    if (OkHttpStackConnection.this.mContentType == null) {
                        return null;
                    }
                    return MediaType.parse((String)OkHttpStackConnection.this.mContentType);
                }

                public void writeTo(BufferedSink sink) throws IOException {
                    OkHttpBodyWriter bodyWriter = new OkHttpBodyWriter(sink);
                    delegate.onBodyReady((BodyWriter)bodyWriter);
                    bodyWriter.flush();
                }
            };
            this.mRequestBuilder.method(this.mMethod, body);
        } else {
            this.mRequestBuilder.method(this.mMethod, null);
        }
        this.mResponse = this.mClient.newCall(this.mRequestBuilder.build()).execute();
        return new ServerResponse(this.mResponse.code(), this.mResponse.body().bytes(), this.getServerResponseHeaders(this.mResponse.headers()));
    }

    public void close() {
        Logger.debug((String)this.getClass().getSimpleName(), (String)"closing connection");
        if (this.mResponse != null) {
            try {
                this.mResponse.close();
            }
            catch (Throwable exc) {
                Logger.error((String)LOG_TAG, (String)"Error while closing connection", (Throwable)exc);
            }
        }
    }
}

