/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.okhttp;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.gotev.uploadservice.data.NameValue;
import net.gotev.uploadservice.logger.UploadServiceLogger;
import net.gotev.uploadservice.network.BodyWriter;
import net.gotev.uploadservice.network.HttpRequest;
import net.gotev.uploadservice.network.ServerResponse;
import net.gotev.uploadservice.okhttp.OkHttpBodyWriter;
import net.gotev.uploadservice.okhttp.OkHttpExtensionsKt;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u001c\u001a\u00020\u00012\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J\u0018\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lnet/gotev/uploadservice/okhttp/OkHttpStackRequest;", "Lnet/gotev/uploadservice/network/HttpRequest;", "uploadId", "", "httpClient", "Lokhttp3/OkHttpClient;", "httpMethod", "url", "(Ljava/lang/String;Lokhttp3/OkHttpClient;Ljava/lang/String;Ljava/lang/String;)V", "bodyLength", "", "contentType", "Lokhttp3/MediaType;", "requestBuilder", "Lokhttp3/Request$Builder;", "uuid", "close", "", "createBody", "Lokhttp3/RequestBody;", "delegate", "Lnet/gotev/uploadservice/network/HttpRequest$RequestBodyDelegate;", "listener", "Lnet/gotev/uploadservice/network/BodyWriter$OnStreamWriteListener;", "getResponse", "Lnet/gotev/uploadservice/network/ServerResponse;", "request", "Lokhttp3/Request;", "setHeaders", "requestHeaders", "", "Lnet/gotev/uploadservice/data/NameValue;", "setTotalBodyBytes", "totalBodyBytes", "isFixedLengthStreamingMode", "", "uploadservice-okhttp_release"})
public final class OkHttpStackRequest
implements HttpRequest {
    private final Request.Builder requestBuilder;
    private long bodyLength;
    private MediaType contentType;
    private final String uuid;
    private final String uploadId;
    private final OkHttpClient httpClient;
    private final String httpMethod;

    @NotNull
    public HttpRequest setHeaders(@NotNull List<NameValue> requestHeaders) throws IOException {
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        for (NameValue param : requestHeaders) {
            Locale locale;
            String string = param.getName();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)Locale.getDefault(), (String)"Locale.getDefault()");
            boolean bl2 = false;
            String string3 = string;
            boolean bl3 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
            if (Intrinsics.areEqual((Object)"content-type", (Object)string5)) {
                string = param.getValue();
                boolean bl4 = false;
                String string6 = string;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                this.contentType = MediaType.Companion.parse(((Object)StringsKt.trim((CharSequence)string6)).toString());
            }
            string = param.getName();
            bl = false;
            String string7 = string;
            if (string7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = param.getValue();
            bl = false;
            String string8 = string;
            if (string8 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            this.requestBuilder.header(((Object)StringsKt.trim((CharSequence)string7)).toString(), ((Object)StringsKt.trim((CharSequence)string8)).toString());
        }
        return this;
    }

    @NotNull
    public HttpRequest setTotalBodyBytes(long totalBodyBytes, boolean isFixedLengthStreamingMode) {
        this.bodyLength = isFixedLengthStreamingMode ? totalBodyBytes : -1L;
        return this;
    }

    private final RequestBody createBody(HttpRequest.RequestBodyDelegate delegate, BodyWriter.OnStreamWriteListener listener) {
        if (!OkHttpExtensionsKt.hasBody(this.httpMethod)) {
            return null;
        }
        return new RequestBody(this, listener, delegate){
            final /* synthetic */ OkHttpStackRequest this$0;
            final /* synthetic */ BodyWriter.OnStreamWriteListener $listener;
            final /* synthetic */ HttpRequest.RequestBodyDelegate $delegate;

            public long contentLength() {
                return OkHttpStackRequest.access$getBodyLength$p(this.this$0);
            }

            @Nullable
            public MediaType contentType() {
                return OkHttpStackRequest.access$getContentType$p(this.this$0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void writeTo(@NotNull BufferedSink sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                Closeable closeable = (Closeable)((Object)new OkHttpBodyWriter(sink, this.$listener));
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    OkHttpBodyWriter it = (OkHttpBodyWriter)((Object)closeable);
                    boolean bl3 = false;
                    this.$delegate.onWriteRequestBody((BodyWriter)it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            {
                this.this$0 = this$0;
                this.$listener = $captured_local_variable$1;
                this.$delegate = $captured_local_variable$2;
            }
        };
    }

    private final Request request(HttpRequest.RequestBodyDelegate delegate, BodyWriter.OnStreamWriteListener listener) {
        return this.requestBuilder.method(this.httpMethod, this.createBody(delegate, listener)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ServerResponse getResponse(@NotNull HttpRequest.RequestBodyDelegate delegate, @NotNull BodyWriter.OnStreamWriteListener listener) throws IOException {
        ServerResponse serverResponse;
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        OkHttpStackRequest okHttpStackRequest = this;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ServerResponse serverResponse2;
            OkHttpStackRequest it = okHttpStackRequest;
            boolean bl3 = false;
            Closeable closeable = (Closeable)this.httpClient.newCall(this.request(delegate, listener)).execute();
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                Response it2 = (Response)closeable;
                boolean bl6 = false;
                serverResponse2 = OkHttpExtensionsKt.asServerResponse(it2);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
            serverResponse = serverResponse2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)((Object)okHttpStackRequest), (Throwable)throwable);
        }
        return serverResponse;
    }

    public void close() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        UploadServiceLogger.debug((String)string, (String)this.uploadId, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ OkHttpStackRequest this$0;

            @NotNull
            public final String invoke() {
                return "closing OkHttp connection (uuid: " + OkHttpStackRequest.access$getUuid$p(this.this$0) + ')';
            }
            {
                this.this$0 = okHttpStackRequest;
                super(0);
            }
        }));
    }

    public OkHttpStackRequest(@NotNull String uploadId, @NotNull OkHttpClient httpClient, @NotNull String httpMethod, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)httpMethod, (String)"httpMethod");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.uploadId = uploadId;
        this.httpClient = httpClient;
        this.httpMethod = httpMethod;
        this.requestBuilder = new Request.Builder().url(new URL(url));
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
        this.uuid = string;
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"javaClass.simpleName");
        UploadServiceLogger.debug((String)string2, (String)this.uploadId, (Function0)((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                return "creating new OkHttp connection (uuid: " + uuid + ')';
            }
        }));
    }

    public static final /* synthetic */ long access$getBodyLength$p(OkHttpStackRequest $this) {
        return $this.bodyLength;
    }

    public static final /* synthetic */ void access$setBodyLength$p(OkHttpStackRequest $this, long l) {
        $this.bodyLength = l;
    }

    public static final /* synthetic */ MediaType access$getContentType$p(OkHttpStackRequest $this) {
        return $this.contentType;
    }

    public static final /* synthetic */ void access$setContentType$p(OkHttpStackRequest $this, MediaType mediaType) {
        $this.contentType = mediaType;
    }
}

