/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.util.Base64;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import net.gotev.uploadservice.HttpUploadTaskParameters;
import net.gotev.uploadservice.UploadRequest;

public abstract class HttpUploadRequest<B extends HttpUploadRequest<B>>
extends UploadRequest<B> {
    protected final HttpUploadTaskParameters httpParams = new HttpUploadTaskParameters();

    public HttpUploadRequest(Context context, String uploadId, String serverUrl) throws MalformedURLException, IllegalArgumentException {
        super(context, uploadId, serverUrl);
        if (!this.params.serverUrl.startsWith("http://") && !this.params.serverUrl.startsWith("https://")) {
            throw new IllegalArgumentException("Specify either http:// or https:// as protocol");
        }
        new URL(this.params.serverUrl);
    }

    @Override
    protected void initializeIntent(Intent intent) {
        super.initializeIntent(intent);
        intent.putExtra("httpTaskParameters", (Parcelable)this.httpParams);
    }

    public B addHeader(String headerName, String headerValue) {
        this.httpParams.addHeader(headerName, headerValue);
        return (B)((HttpUploadRequest)this.self());
    }

    public B setBasicAuth(String username, String password) {
        String auth = Base64.encodeToString((byte[])(username + ":" + password).getBytes(), (int)2);
        this.httpParams.addHeader("Authorization", "Basic " + auth);
        return (B)((HttpUploadRequest)this.self());
    }

    public B addParameter(String paramName, String paramValue) {
        this.httpParams.addParameter(paramName, paramValue);
        return (B)((HttpUploadRequest)this.self());
    }

    public B addArrayParameter(String paramName, String ... array) {
        for (String value : array) {
            this.httpParams.addParameter(paramName, value);
        }
        return (B)((HttpUploadRequest)this.self());
    }

    public B addArrayParameter(String paramName, List<String> list) {
        for (String value : list) {
            this.httpParams.addParameter(paramName, value);
        }
        return (B)((HttpUploadRequest)this.self());
    }

    public B setMethod(String method) {
        this.httpParams.method = method;
        return (B)((HttpUploadRequest)this.self());
    }

    public B setCustomUserAgent(String customUserAgent) {
        if (customUserAgent != null && !customUserAgent.isEmpty()) {
            this.httpParams.customUserAgent = customUserAgent;
        }
        return (B)((HttpUploadRequest)this.self());
    }

    public B setUsesFixedLengthStreamingMode(boolean fixedLength) {
        this.httpParams.usesFixedLengthStreamingMode = fixedLength;
        return (B)((HttpUploadRequest)this.self());
    }
}

