/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import net.gotev.uploadservice.NameValue;

public final class HttpUploadTaskParameters
implements Parcelable {
    protected static final String PARAM_HTTP_TASK_PARAMETERS = "httpTaskParameters";
    public String customUserAgent;
    public String method = "POST";
    public boolean usesFixedLengthStreamingMode = true;
    private ArrayList<NameValue> requestHeaders = new ArrayList(10);
    private ArrayList<NameValue> requestParameters = new ArrayList(10);
    public static final Parcelable.Creator<HttpUploadTaskParameters> CREATOR = new Parcelable.Creator<HttpUploadTaskParameters>(){

        public HttpUploadTaskParameters createFromParcel(Parcel in) {
            return new HttpUploadTaskParameters(in);
        }

        public HttpUploadTaskParameters[] newArray(int size) {
            return new HttpUploadTaskParameters[size];
        }
    };

    public HttpUploadTaskParameters() {
    }

    public void writeToParcel(Parcel parcel, int arg1) {
        parcel.writeString(this.method);
        parcel.writeString(this.customUserAgent);
        parcel.writeByte((byte)(this.usesFixedLengthStreamingMode ? 1 : 0));
        parcel.writeList(this.requestHeaders);
        parcel.writeList(this.requestParameters);
    }

    private HttpUploadTaskParameters(Parcel in) {
        this.method = in.readString();
        this.customUserAgent = in.readString();
        this.usesFixedLengthStreamingMode = in.readByte() == 1;
        in.readList(this.requestHeaders, NameValue.class.getClassLoader());
        in.readList(this.requestParameters, NameValue.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public boolean isCustomUserAgentDefined() {
        return this.customUserAgent != null && !"".equals(this.customUserAgent);
    }

    public HttpUploadTaskParameters addHeader(String name, String value) {
        this.requestHeaders.add(NameValue.header(name, value));
        return this;
    }

    public ArrayList<NameValue> getRequestHeaders() {
        return this.requestHeaders;
    }

    public HttpUploadTaskParameters addParameter(String name, String value) {
        this.requestParameters.add(new NameValue(name, value));
        return this;
    }

    public ArrayList<NameValue> getRequestParameters() {
        return this.requestParameters;
    }
}

