/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice;

import android.content.Context;
import android.content.Intent;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import net.gotev.uploadservice.HttpUploadRequest;
import net.gotev.uploadservice.Logger;
import net.gotev.uploadservice.MultipartUploadTask;
import net.gotev.uploadservice.UploadFile;
import net.gotev.uploadservice.UploadTask;

public class MultipartUploadRequest
extends HttpUploadRequest<MultipartUploadRequest> {
    private static final String LOG_TAG = MultipartUploadRequest.class.getSimpleName();
    private boolean isUtf8Charset = false;

    public MultipartUploadRequest(Context context, String uploadId, String serverUrl) throws IllegalArgumentException, MalformedURLException {
        super(context, uploadId, serverUrl);
    }

    public MultipartUploadRequest(Context context, String serverUrl) throws MalformedURLException, IllegalArgumentException {
        this(context, null, serverUrl);
    }

    @Override
    protected void initializeIntent(Intent intent) {
        super.initializeIntent(intent);
        intent.putExtra("multipartUtf8Charset", this.isUtf8Charset);
    }

    @Override
    protected Class<? extends UploadTask> getTaskClass() {
        return MultipartUploadTask.class;
    }

    public MultipartUploadRequest addFileToUpload(String filePath, String parameterName, String fileName, String contentType) throws FileNotFoundException, IllegalArgumentException {
        UploadFile file = new UploadFile(filePath);
        filePath = file.getPath();
        if (parameterName == null || "".equals(parameterName)) {
            throw new IllegalArgumentException("Please specify parameterName value for file: " + filePath);
        }
        file.setProperty("httpParamName", parameterName);
        if (contentType == null || contentType.isEmpty()) {
            contentType = file.getContentType(this.context);
            Logger.debug(LOG_TAG, "Auto-detected MIME type for " + filePath + " is: " + contentType);
        } else {
            Logger.debug(LOG_TAG, "Content Type set for " + filePath + " is: " + contentType);
        }
        file.setProperty("httpContentType", contentType);
        if (fileName == null || "".equals(fileName)) {
            fileName = file.getName(this.context);
            Logger.debug(LOG_TAG, "Using original file name: " + fileName);
        } else {
            Logger.debug(LOG_TAG, "Using custom file name: " + fileName);
        }
        file.setProperty("httpRemoteFileName", fileName);
        this.params.files.add(file);
        return this;
    }

    public MultipartUploadRequest addFileToUpload(String path, String parameterName, String fileName) throws FileNotFoundException, IllegalArgumentException {
        return this.addFileToUpload(path, parameterName, fileName, null);
    }

    public MultipartUploadRequest addFileToUpload(String path, String parameterName) throws FileNotFoundException, IllegalArgumentException {
        return this.addFileToUpload(path, parameterName, null, null);
    }

    public MultipartUploadRequest setUtf8Charset() {
        this.isUtf8Charset = true;
        return this;
    }
}

