/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice;

import android.content.Context;
import android.content.Intent;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import net.gotev.uploadservice.HttpUploadTask;
import net.gotev.uploadservice.NameValue;
import net.gotev.uploadservice.UploadFile;
import net.gotev.uploadservice.UploadService;
import net.gotev.uploadservice.http.BodyWriter;

public class MultipartUploadTask
extends HttpUploadTask {
    protected static final String PARAM_UTF8_CHARSET = "multipartUtf8Charset";
    private static final String BOUNDARY_SIGNATURE = "-------AndroidUploadService";
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    private static final String NEW_LINE = "\r\n";
    private static final String TWO_HYPHENS = "--";
    protected static final String PROPERTY_REMOTE_FILE_NAME = "httpRemoteFileName";
    protected static final String PROPERTY_CONTENT_TYPE = "httpContentType";
    protected static final String PROPERTY_PARAM_NAME = "httpParamName";
    private byte[] boundaryBytes;
    private byte[] trailerBytes;
    private Charset charset;

    @Override
    protected void init(UploadService service, Intent intent) throws IOException {
        super.init(service, intent);
        String boundary = BOUNDARY_SIGNATURE + System.nanoTime();
        this.boundaryBytes = (TWO_HYPHENS + boundary + NEW_LINE).getBytes(US_ASCII);
        this.trailerBytes = (TWO_HYPHENS + boundary + TWO_HYPHENS + NEW_LINE).getBytes(US_ASCII);
        Charset charset = this.charset = intent.getBooleanExtra(PARAM_UTF8_CHARSET, false) ? Charset.forName("UTF-8") : US_ASCII;
        if (this.params.files.size() <= 1) {
            this.httpParams.addHeader("Connection", "close");
        } else {
            this.httpParams.addHeader("Connection", "Keep-Alive");
        }
        this.httpParams.addHeader("Content-Type", "multipart/form-data; boundary=" + boundary);
    }

    @Override
    protected long getBodyLength() throws UnsupportedEncodingException {
        return this.getRequestParametersLength() + this.getFilesLength() + (long)this.trailerBytes.length;
    }

    @Override
    public void onBodyReady(BodyWriter bodyWriter) throws IOException {
        this.uploadedBytes = 0L;
        this.writeRequestParameters(bodyWriter);
        this.writeFiles(bodyWriter);
        bodyWriter.write(this.trailerBytes);
    }

    private long getFilesLength() throws UnsupportedEncodingException {
        long total = 0L;
        for (UploadFile file : this.params.files) {
            total += this.getTotalMultipartBytes(file);
        }
        return total;
    }

    private long getRequestParametersLength() throws UnsupportedEncodingException {
        long parametersBytes = 0L;
        if (!this.httpParams.getRequestParameters().isEmpty()) {
            for (NameValue parameter : this.httpParams.getRequestParameters()) {
                parametersBytes += (long)(this.boundaryBytes.length + this.getMultipartBytes(parameter).length);
            }
        }
        return parametersBytes;
    }

    private byte[] getMultipartBytes(NameValue parameter) throws UnsupportedEncodingException {
        return ("Content-Disposition: form-data; name=\"" + parameter.getName() + "\"" + NEW_LINE + NEW_LINE + parameter.getValue() + NEW_LINE).getBytes(this.charset);
    }

    private byte[] getMultipartHeader(UploadFile file) throws UnsupportedEncodingException {
        String header = "Content-Disposition: form-data; name=\"" + file.getProperty(PROPERTY_PARAM_NAME) + "\"; filename=\"" + file.getProperty(PROPERTY_REMOTE_FILE_NAME) + "\"" + NEW_LINE + "Content-Type: " + file.getProperty(PROPERTY_CONTENT_TYPE) + NEW_LINE + NEW_LINE;
        return header.getBytes(this.charset);
    }

    private long getTotalMultipartBytes(UploadFile file) throws UnsupportedEncodingException {
        return (long)(this.boundaryBytes.length + this.getMultipartHeader(file).length) + file.length((Context)this.service) + (long)NEW_LINE.getBytes(this.charset).length;
    }

    private void writeRequestParameters(BodyWriter bodyWriter) throws IOException {
        if (!this.httpParams.getRequestParameters().isEmpty()) {
            for (NameValue parameter : this.httpParams.getRequestParameters()) {
                bodyWriter.write(this.boundaryBytes);
                byte[] formItemBytes = this.getMultipartBytes(parameter);
                bodyWriter.write(formItemBytes);
                this.uploadedBytes += (long)(this.boundaryBytes.length + formItemBytes.length);
                this.broadcastProgress(this.uploadedBytes, this.totalBytes);
            }
        }
    }

    private void writeFiles(BodyWriter bodyWriter) throws IOException {
        for (UploadFile file : this.params.files) {
            if (!this.shouldContinue) break;
            bodyWriter.write(this.boundaryBytes);
            byte[] headerBytes = this.getMultipartHeader(file);
            bodyWriter.write(headerBytes);
            this.uploadedBytes += (long)(this.boundaryBytes.length + headerBytes.length);
            this.broadcastProgress(this.uploadedBytes, this.totalBytes);
            InputStream stream = file.getStream((Context)this.service);
            bodyWriter.writeStream(stream, this);
            stream.close();
            bodyWriter.write(NEW_LINE.getBytes(this.charset));
        }
    }

    @Override
    protected void onSuccessfulUpload() {
        this.addAllFilesToSuccessfullyUploadedFiles();
    }
}

