/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice;

import android.os.Parcel;
import android.os.Parcelable;

public final class NameValue
implements Parcelable {
    private final String name;
    private final String value;
    public static final Parcelable.Creator<NameValue> CREATOR = new Parcelable.Creator<NameValue>(){

        public NameValue createFromParcel(Parcel in) {
            return new NameValue(in);
        }

        public NameValue[] newArray(int size) {
            return new NameValue[size];
        }
    };

    public static NameValue header(String name, String value) {
        if (!NameValue.isAllASCII(name) || !NameValue.isAllASCII(value)) {
            throw new IllegalArgumentException("Header " + name + " must be ASCII only! Read http://stackoverflow.com/a/4410331");
        }
        return new NameValue(name, value);
    }

    public NameValue(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public final String getName() {
        return this.name;
    }

    public final String getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        boolean areEqual;
        if (object instanceof NameValue) {
            NameValue other = (NameValue)object;
            areEqual = this.name.equals(other.name) && this.value.equals(other.value);
        } else {
            areEqual = false;
        }
        return areEqual;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int arg1) {
        parcel.writeString(this.name);
        parcel.writeString(this.value);
    }

    private NameValue(Parcel in) {
        this.name = in.readString();
        this.value = in.readString();
    }

    private static boolean isAllASCII(String input) {
        if (input == null || input.isEmpty()) {
            return false;
        }
        boolean isASCII = true;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c <= '\u007f') continue;
            isASCII = false;
            break;
        }
        return isASCII;
    }
}

