/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import net.gotev.uploadservice.schemehandlers.SchemeHandler;
import net.gotev.uploadservice.schemehandlers.SchemeHandlerFactory;

public class UploadFile
implements Parcelable {
    protected final String path;
    private LinkedHashMap<String, String> properties = new LinkedHashMap();
    protected final SchemeHandler handler;
    public static final Parcelable.Creator<UploadFile> CREATOR = new Parcelable.Creator<UploadFile>(){

        public UploadFile createFromParcel(Parcel in) {
            return new UploadFile(in);
        }

        public UploadFile[] newArray(int size) {
            return new UploadFile[size];
        }
    };

    public UploadFile(String path) throws FileNotFoundException {
        if (path == null || "".equals(path)) {
            throw new IllegalArgumentException("Please specify a file path!");
        }
        if (!SchemeHandlerFactory.getInstance().isSupported(path)) {
            throw new UnsupportedOperationException("Unsupported scheme: " + path);
        }
        this.path = path;
        try {
            this.handler = SchemeHandlerFactory.getInstance().get(path);
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    public long length(Context context) {
        return this.handler.getLength(context);
    }

    public final InputStream getStream(Context context) throws FileNotFoundException {
        return this.handler.getInputStream(context);
    }

    public final String getContentType(Context context) {
        return this.handler.getContentType(context);
    }

    public final String getName(Context context) {
        return this.handler.getName(context);
    }

    public final String getPath() {
        return this.path;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int arg1) {
        parcel.writeString(this.path);
        parcel.writeSerializable(this.properties);
    }

    private UploadFile(Parcel in) {
        this.path = in.readString();
        this.properties = (LinkedHashMap)in.readSerializable();
        try {
            this.handler = SchemeHandlerFactory.getInstance().get(this.path);
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        String val = this.properties.get(key);
        if (val == null) {
            val = defaultValue;
        }
        return val;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UploadFile)) {
            return false;
        }
        UploadFile that = (UploadFile)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

