/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class UploadInfo
implements Parcelable {
    private String uploadId;
    private long startTime;
    private long currentTime;
    private long uploadedBytes;
    private long totalBytes;
    private int numberOfRetries;
    private Integer notificationID;
    private ArrayList<String> filesLeft = new ArrayList();
    private ArrayList<String> successfullyUploadedFiles = new ArrayList();
    public static final Parcelable.Creator<UploadInfo> CREATOR = new Parcelable.Creator<UploadInfo>(){

        public UploadInfo createFromParcel(Parcel in) {
            return new UploadInfo(in);
        }

        public UploadInfo[] newArray(int size) {
            return new UploadInfo[size];
        }
    };

    protected UploadInfo(String uploadId) {
        this.uploadId = uploadId;
        this.startTime = 0L;
        this.currentTime = 0L;
        this.uploadedBytes = 0L;
        this.totalBytes = 0L;
        this.numberOfRetries = 0;
        this.notificationID = null;
    }

    protected UploadInfo(String uploadId, long startTime, long uploadedBytes, long totalBytes, int numberOfRetries, List<String> uploadedFiles, List<String> filesLeft) {
        this.uploadId = uploadId;
        this.startTime = startTime;
        this.currentTime = new Date().getTime();
        this.uploadedBytes = uploadedBytes;
        this.totalBytes = totalBytes;
        this.numberOfRetries = numberOfRetries;
        if (filesLeft != null && !filesLeft.isEmpty()) {
            this.filesLeft.addAll(filesLeft);
        }
        if (uploadedFiles != null && !uploadedFiles.isEmpty()) {
            this.successfullyUploadedFiles.addAll(uploadedFiles);
        }
    }

    public void writeToParcel(Parcel parcel, int arg1) {
        parcel.writeString(this.uploadId);
        parcel.writeLong(this.startTime);
        parcel.writeLong(this.currentTime);
        parcel.writeLong(this.uploadedBytes);
        parcel.writeLong(this.totalBytes);
        parcel.writeInt(this.numberOfRetries);
        parcel.writeInt(this.notificationID == null ? -1 : this.notificationID);
        parcel.writeStringList(this.filesLeft);
        parcel.writeStringList(this.successfullyUploadedFiles);
    }

    private UploadInfo(Parcel in) {
        this.uploadId = in.readString();
        this.startTime = in.readLong();
        this.currentTime = in.readLong();
        this.uploadedBytes = in.readLong();
        this.totalBytes = in.readLong();
        this.numberOfRetries = in.readInt();
        this.notificationID = in.readInt();
        if (this.notificationID == -1) {
            this.notificationID = null;
        }
        in.readStringList(this.filesLeft);
        in.readStringList(this.successfullyUploadedFiles);
    }

    public int describeContents() {
        return 0;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getElapsedTime() {
        return this.currentTime - this.startTime;
    }

    public String getElapsedTimeString() {
        int elapsedSeconds = (int)(this.getElapsedTime() / 1000L);
        if (elapsedSeconds == 0) {
            return "0s";
        }
        int minutes = elapsedSeconds / 60;
        elapsedSeconds -= 60 * minutes;
        if (minutes == 0) {
            return elapsedSeconds + "s";
        }
        return minutes + "m " + elapsedSeconds + "s";
    }

    public double getUploadRate() {
        long elapsedTime = this.getElapsedTime();
        if (elapsedTime < 1000L) {
            return 0.0;
        }
        return (double)this.uploadedBytes / 1024.0 * 8.0 / (double)(elapsedTime / 1000L);
    }

    public String getUploadRateString() {
        double uploadRate = this.getUploadRate();
        if (uploadRate < 1.0) {
            return (int)(uploadRate * 1000.0) + " bit/s";
        }
        if (uploadRate >= 1024.0) {
            return (int)(uploadRate / 1024.0) + " Mbit/s";
        }
        return (int)uploadRate + " Kbit/s";
    }

    public ArrayList<String> getSuccessfullyUploadedFiles() {
        return this.successfullyUploadedFiles;
    }

    public ArrayList<String> getFilesLeft() {
        return this.filesLeft;
    }

    public long getUploadedBytes() {
        return this.uploadedBytes;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public int getProgressPercent() {
        if (this.totalBytes == 0L) {
            return 0;
        }
        return (int)(this.uploadedBytes * 100L / this.totalBytes);
    }

    public int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public int getTotalFiles() {
        return this.successfullyUploadedFiles.size() + this.filesLeft.size();
    }

    public Integer getNotificationID() {
        return this.notificationID;
    }

    protected void setNotificationID(int id) {
        this.notificationID = id;
    }
}

