/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice;

import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.PowerManager;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.gotev.uploadservice.Logger;
import net.gotev.uploadservice.UploadStatusDelegate;
import net.gotev.uploadservice.UploadTask;
import net.gotev.uploadservice.http.HttpStack;
import net.gotev.uploadservice.http.impl.HurlStack;

public final class UploadService
extends Service {
    private static final String TAG = UploadService.class.getSimpleName();
    public static int UPLOAD_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    public static int KEEP_ALIVE_TIME_IN_SECONDS = 5;
    public static int IDLE_TIMEOUT = 10000;
    public static boolean EXECUTE_IN_FOREGROUND = true;
    public static String NAMESPACE = "net.gotev";
    public static HttpStack HTTP_STACK = new HurlStack();
    public static int BUFFER_SIZE = 4096;
    public static int INITIAL_RETRY_WAIT_TIME = 1000;
    public static int BACKOFF_MULTIPLIER = 2;
    public static int MAX_RETRY_WAIT_TIME = 100000;
    protected static final int UPLOAD_NOTIFICATION_BASE_ID = 1234;
    protected static final long PROGRESS_REPORT_INTERVAL = 166L;
    private static final String ACTION_UPLOAD_SUFFIX = ".uploadservice.action.upload";
    protected static final String PARAM_TASK_PARAMETERS = "taskParameters";
    protected static final String PARAM_TASK_CLASS = "taskClass";
    private static final String BROADCAST_ACTION_SUFFIX = ".uploadservice.broadcast.status";
    protected static final String PARAM_BROADCAST_DATA = "broadcastData";
    private PowerManager.WakeLock wakeLock;
    private int notificationIncrementalId = 0;
    private static final Map<String, UploadTask> uploadTasksMap = new ConcurrentHashMap<String, UploadTask>();
    private static final Map<String, WeakReference<UploadStatusDelegate>> uploadDelegates = new ConcurrentHashMap<String, WeakReference<UploadStatusDelegate>>();
    private final BlockingQueue<Runnable> uploadTasksQueue = new LinkedBlockingQueue<Runnable>();
    private static volatile String foregroundUploadId = null;
    private ThreadPoolExecutor uploadThreadPool;
    private Timer idleTimer = null;

    protected static String getActionUpload() {
        return NAMESPACE + ACTION_UPLOAD_SUFFIX;
    }

    protected static String getActionBroadcast() {
        return NAMESPACE + BROADCAST_ACTION_SUFFIX;
    }

    public static synchronized void stopUpload(String uploadId) {
        UploadTask removedTask = uploadTasksMap.get(uploadId);
        if (removedTask != null) {
            removedTask.cancel();
        }
    }

    public static synchronized List<String> getTaskList() {
        ArrayList<String> tasks;
        if (uploadTasksMap.isEmpty()) {
            tasks = new ArrayList<String>(1);
        } else {
            tasks = new ArrayList(uploadTasksMap.size());
            tasks.addAll(uploadTasksMap.keySet());
        }
        return tasks;
    }

    public static synchronized void stopAllUploads() {
        if (uploadTasksMap.isEmpty()) {
            return;
        }
        Iterator<String> iterator = uploadTasksMap.keySet().iterator();
        while (iterator.hasNext()) {
            UploadTask taskToCancel = uploadTasksMap.get(iterator.next());
            taskToCancel.cancel();
        }
    }

    public static synchronized boolean stop(Context context) {
        return UploadService.stop(context, false);
    }

    public static synchronized boolean stop(Context context, boolean forceStop) {
        if (forceStop) {
            return context.stopService(new Intent(context, UploadService.class));
        }
        return uploadTasksMap.isEmpty() && context.stopService(new Intent(context, UploadService.class));
    }

    public void onCreate() {
        super.onCreate();
        PowerManager pm = (PowerManager)this.getSystemService("power");
        this.wakeLock = pm.newWakeLock(1, TAG);
        this.wakeLock.setReferenceCounted(false);
        if (!this.wakeLock.isHeld()) {
            this.wakeLock.acquire();
        }
        if (UPLOAD_POOL_SIZE <= 0) {
            UPLOAD_POOL_SIZE = Runtime.getRuntime().availableProcessors();
        }
        this.uploadThreadPool = new ThreadPoolExecutor(UPLOAD_POOL_SIZE, UPLOAD_POOL_SIZE, KEEP_ALIVE_TIME_IN_SECONDS, TimeUnit.SECONDS, this.uploadTasksQueue);
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent == null || !UploadService.getActionUpload().equals(intent.getAction())) {
            return this.shutdownIfThereArentAnyActiveTasks();
        }
        Logger.info(TAG, String.format(Locale.getDefault(), "Starting service with namespace: %s, upload pool size: %d, %ds idle thread keep alive time. Foreground execution is %s", NAMESPACE, UPLOAD_POOL_SIZE, KEEP_ALIVE_TIME_IN_SECONDS, EXECUTE_IN_FOREGROUND ? "enabled" : "disabled"));
        UploadTask currentTask = this.getTask(intent);
        if (currentTask == null) {
            return this.shutdownIfThereArentAnyActiveTasks();
        }
        if (uploadTasksMap.containsKey(currentTask.params.id)) {
            Logger.error(TAG, "Preventing upload with id: " + currentTask.params.id + " to be uploaded twice! Please check your code and fix it!");
            return this.shutdownIfThereArentAnyActiveTasks();
        }
        this.clearIdleTimer();
        this.notificationIncrementalId += 2;
        currentTask.setLastProgressNotificationTime(0L).setNotificationId(1234 + this.notificationIncrementalId);
        uploadTasksMap.put(currentTask.params.id, currentTask);
        this.uploadThreadPool.execute(currentTask);
        return 1;
    }

    private void clearIdleTimer() {
        if (this.idleTimer != null) {
            Logger.info(TAG, "Clearing idle timer");
            this.idleTimer.cancel();
            this.idleTimer = null;
        }
    }

    private int shutdownIfThereArentAnyActiveTasks() {
        if (uploadTasksMap.isEmpty()) {
            this.clearIdleTimer();
            Logger.info(TAG, "Service will be shut down in " + IDLE_TIMEOUT + "ms if no new tasks are received");
            this.idleTimer = new Timer(TAG + "IdleTimer");
            this.idleTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Logger.info(TAG, "Service is about to be stopped because idle timeout of " + IDLE_TIMEOUT + "ms has been reached");
                    UploadService.this.stopSelf();
                }
            }, IDLE_TIMEOUT);
            return 2;
        }
        return 1;
    }

    public void onDestroy() {
        super.onDestroy();
        UploadService.stopAllUploads();
        this.uploadThreadPool.shutdown();
        if (EXECUTE_IN_FOREGROUND) {
            Logger.debug(TAG, "Stopping foreground execution");
            this.stopForeground(true);
        }
        if (this.wakeLock.isHeld()) {
            this.wakeLock.release();
        }
        uploadTasksMap.clear();
        uploadDelegates.clear();
        Logger.debug(TAG, "UploadService destroyed");
    }

    UploadTask getTask(Intent intent) {
        String taskClass = intent.getStringExtra(PARAM_TASK_CLASS);
        if (taskClass == null) {
            return null;
        }
        UploadTask uploadTask = null;
        try {
            Class<?> task = Class.forName(taskClass);
            if (UploadTask.class.isAssignableFrom(task)) {
                uploadTask = (UploadTask)UploadTask.class.cast(task.newInstance());
                uploadTask.init(this, intent);
            } else {
                Logger.error(TAG, taskClass + " does not extend UploadTask!");
            }
            Logger.debug(TAG, "Successfully created new task with class: " + taskClass);
        }
        catch (Exception exc) {
            Logger.error(TAG, "Error while instantiating new task", exc);
        }
        return uploadTask;
    }

    protected synchronized boolean holdForegroundNotification(String uploadId, Notification notification) {
        if (!EXECUTE_IN_FOREGROUND) {
            return false;
        }
        if (foregroundUploadId == null) {
            foregroundUploadId = uploadId;
            Logger.debug(TAG, uploadId + " now holds the foreground notification");
        }
        if (uploadId.equals(foregroundUploadId)) {
            this.startForeground(1234, notification);
            return true;
        }
        return false;
    }

    protected synchronized void taskCompleted(String uploadId) {
        UploadTask task = uploadTasksMap.remove(uploadId);
        uploadDelegates.remove(uploadId);
        if (EXECUTE_IN_FOREGROUND && task != null && task.params.id.equals(foregroundUploadId)) {
            Logger.debug(TAG, uploadId + " now un-holded the foreground notification");
            foregroundUploadId = null;
        }
        if (EXECUTE_IN_FOREGROUND && uploadTasksMap.isEmpty()) {
            Logger.debug(TAG, "All tasks completed, stopping foreground execution");
            this.stopForeground(true);
            this.shutdownIfThereArentAnyActiveTasks();
        }
    }

    protected static void setUploadStatusDelegate(String uploadId, UploadStatusDelegate delegate) {
        if (delegate == null) {
            return;
        }
        uploadDelegates.put(uploadId, new WeakReference<UploadStatusDelegate>(delegate));
    }

    protected static UploadStatusDelegate getUploadStatusDelegate(String uploadId) {
        WeakReference<UploadStatusDelegate> reference = uploadDelegates.get(uploadId);
        if (reference == null) {
            return null;
        }
        UploadStatusDelegate delegate = (UploadStatusDelegate)reference.get();
        if (delegate == null) {
            uploadDelegates.remove(uploadId);
            Logger.info(TAG, "\n\n\nUpload delegate for upload with Id " + uploadId + " is gone!\n" + "Probably you have set it in an activity and the user navigated away from it\n" + "before the upload was completed. From now on, the events will be dispatched\n" + "with broadcast intents. If you see this message, consider switching to the\n" + "UploadServiceBroadcastReceiver registered globally in your manifest.\n" + "Read this:\n" + "https://github.com/gotev/android-upload-service/wiki/Monitoring-upload-status\n");
        }
        return delegate;
    }
}

