/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice;

import android.content.Context;
import java.lang.ref.WeakReference;
import net.gotev.uploadservice.ServerResponse;
import net.gotev.uploadservice.UploadInfo;
import net.gotev.uploadservice.UploadServiceBroadcastReceiver;
import net.gotev.uploadservice.UploadStatusDelegate;

public class UploadServiceSingleBroadcastReceiver
extends UploadServiceBroadcastReceiver {
    private WeakReference<UploadStatusDelegate> mDelegate;
    private String mUploadID = null;

    public UploadServiceSingleBroadcastReceiver(UploadStatusDelegate delegate) {
        this.mDelegate = new WeakReference<UploadStatusDelegate>(delegate);
    }

    public void setUploadID(String uploadID) {
        this.mUploadID = uploadID;
    }

    @Override
    protected boolean shouldAcceptEventFrom(UploadInfo uploadInfo) {
        return this.mUploadID != null && uploadInfo.getUploadId().equals(this.mUploadID);
    }

    @Override
    public final void onProgress(Context context, UploadInfo uploadInfo) {
        if (this.mDelegate != null && this.mDelegate.get() != null) {
            ((UploadStatusDelegate)this.mDelegate.get()).onProgress(context, uploadInfo);
        }
    }

    @Override
    public final void onError(Context context, UploadInfo uploadInfo, ServerResponse serverResponse, Exception exception) {
        if (this.mDelegate != null && this.mDelegate.get() != null) {
            ((UploadStatusDelegate)this.mDelegate.get()).onError(context, uploadInfo, serverResponse, exception);
        }
    }

    @Override
    public final void onCompleted(Context context, UploadInfo uploadInfo, ServerResponse serverResponse) {
        if (this.mDelegate != null && this.mDelegate.get() != null) {
            ((UploadStatusDelegate)this.mDelegate.get()).onCompleted(context, uploadInfo, serverResponse);
        }
    }

    @Override
    public final void onCancelled(Context context, UploadInfo uploadInfo) {
        if (this.mDelegate != null && this.mDelegate.get() != null) {
            ((UploadStatusDelegate)this.mDelegate.get()).onCancelled(context, uploadInfo);
        }
    }
}

