/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.http.impl;

import java.io.IOException;
import net.gotev.uploadservice.http.HttpConnection;
import net.gotev.uploadservice.http.HttpStack;
import net.gotev.uploadservice.http.impl.HurlStackConnection;

public class HurlStack
implements HttpStack {
    private boolean mFollowRedirects;
    private boolean mUseCaches;
    private int mConnectTimeout;
    private int mReadTimeout;

    public HurlStack() {
        this.mFollowRedirects = true;
        this.mUseCaches = false;
        this.mConnectTimeout = 15000;
        this.mReadTimeout = 30000;
    }

    public HurlStack(boolean followRedirects, boolean useCaches, int connectTimeout, int readTimeout) {
        this.mFollowRedirects = followRedirects;
        this.mUseCaches = useCaches;
        this.mConnectTimeout = connectTimeout;
        this.mReadTimeout = readTimeout;
    }

    @Override
    public HttpConnection createNewConnection(String method, String url) throws IOException {
        return new HurlStackConnection(method, url, this.mFollowRedirects, this.mUseCaches, this.mConnectTimeout, this.mReadTimeout);
    }
}

