/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.schemehandlers;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import net.gotev.uploadservice.Logger;
import net.gotev.uploadservice.schemehandlers.SchemeHandler;

class ContentSchemeHandler
implements SchemeHandler {
    private Uri uri;

    ContentSchemeHandler() {
    }

    @Override
    public void init(String path) {
        this.uri = Uri.parse((String)path);
    }

    @Override
    public long getLength(Context context) {
        return this.getUriSize(context);
    }

    @Override
    public InputStream getInputStream(Context context) throws FileNotFoundException {
        return context.getContentResolver().openInputStream(this.uri);
    }

    @Override
    public String getContentType(Context context) {
        String type = context.getContentResolver().getType(this.uri);
        if (type == null || type.isEmpty()) {
            type = "application/octet-stream";
        }
        return type;
    }

    @Override
    public String getName(Context context) {
        return this.getUriName(context);
    }

    private long getUriSize(Context context) {
        Cursor cursor = context.getContentResolver().query(this.uri, null, null, null, null);
        if (cursor == null) {
            Logger.error(this.getClass().getSimpleName(), "null cursor for " + this.uri + ", returning size 0");
            return 0L;
        }
        int sizeIndex = cursor.getColumnIndex("_size");
        cursor.moveToFirst();
        long size = cursor.getLong(sizeIndex);
        cursor.close();
        return size;
    }

    private String getUriName(Context context) {
        Cursor cursor = context.getContentResolver().query(this.uri, null, null, null, null);
        if (cursor == null) {
            return this.getUriNameFallback();
        }
        int nameIndex = cursor.getColumnIndex("_display_name");
        cursor.moveToFirst();
        String name = cursor.getString(nameIndex);
        cursor.close();
        return name;
    }

    private String getUriNameFallback() {
        String[] components = this.uri.toString().split(File.separator);
        return components[components.length - 1];
    }
}

