/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.data;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.android.parcel.Parcelize;
import net.gotev.uploadservice.data.UploadElapsedTime;
import net.gotev.uploadservice.data.UploadFile;
import net.gotev.uploadservice.data.UploadRate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001BG\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0005H\u00c6\u0003J\t\u0010+\u001a\u00020\u0005H\u00c6\u0003J\t\u0010,\u001a\u00020\u0005H\u00c6\u0003J\t\u0010-\u001a\u00020\tH\u00c6\u0003J\u000f\u0010.\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003JK\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0001J\t\u00100\u001a\u00020\tH\u00d6\u0001J\u0013\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u000104H\u00d6\u0003J\t\u00105\u001a\u00020\tH\u00d6\u0001J\t\u00106\u001a\u00020\u0003H\u00d6\u0001J\u0019\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\tH\u00d6\u0001R\u0017\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\u00020\t8F\u00a2\u0006\f\u0012\u0004\b\u0019\u0010\u0011\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\u00020\t8F\u00a2\u0006\f\u0012\u0004\b\u001e\u0010\u0011\u001a\u0004\b\u001f\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0017\u0010#\u001a\u00020$8F\u00a2\u0006\f\u0012\u0004\b%\u0010\u0011\u001a\u0004\b&\u0010'R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001c\u00a8\u0006<"}, d2={"Lnet/gotev/uploadservice/data/UploadInfo;", "Landroid/os/Parcelable;", "uploadId", "", "startTime", "", "uploadedBytes", "totalBytes", "numberOfRetries", "", "files", "Ljava/util/ArrayList;", "Lnet/gotev/uploadservice/data/UploadFile;", "(Ljava/lang/String;JJJILjava/util/ArrayList;)V", "elapsedTime", "Lnet/gotev/uploadservice/data/UploadElapsedTime;", "getElapsedTime$annotations", "()V", "getElapsedTime", "()Lnet/gotev/uploadservice/data/UploadElapsedTime;", "getFiles", "()Ljava/util/ArrayList;", "getNumberOfRetries", "()I", "progressPercent", "getProgressPercent$annotations", "getProgressPercent", "getStartTime", "()J", "successfullyUploadedFiles", "getSuccessfullyUploadedFiles$annotations", "getSuccessfullyUploadedFiles", "getTotalBytes", "getUploadId", "()Ljava/lang/String;", "uploadRate", "Lnet/gotev/uploadservice/data/UploadRate;", "getUploadRate$annotations", "getUploadRate", "()Lnet/gotev/uploadservice/data/UploadRate;", "getUploadedBytes", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "describeContents", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "uploadservice_release"})
@Parcelize
public final class UploadInfo
implements Parcelable {
    @NotNull
    private final String uploadId;
    private final long startTime;
    private final long uploadedBytes;
    private final long totalBytes;
    private final int numberOfRetries;
    @NotNull
    private final ArrayList<UploadFile> files;
    public static final Parcelable.Creator CREATOR = new Creator();

    public static /* synthetic */ void getElapsedTime$annotations() {
    }

    @NotNull
    public final UploadElapsedTime getElapsedTime() {
        int seconds = (int)((new Date().getTime() - this.startTime) / (long)1000);
        int minutes = seconds / 60;
        return new UploadElapsedTime(minutes, seconds -= 60 * minutes);
    }

    public static /* synthetic */ void getUploadRate$annotations() {
    }

    @NotNull
    public final UploadRate getUploadRate() {
        int elapsedSeconds = this.getElapsedTime().getTotalSeconds();
        double kilobitPerSecond = elapsedSeconds < 1 ? 0.0 : (double)this.uploadedBytes / (double)1000 * (double)8 / (double)elapsedSeconds;
        return kilobitPerSecond < 1.0 ? new UploadRate((int)(kilobitPerSecond * (double)1000), UploadRate.UploadRateUnit.BitPerSecond) : (kilobitPerSecond >= (double)1000 ? new UploadRate((int)(kilobitPerSecond / (double)1000), UploadRate.UploadRateUnit.MegabitPerSecond) : new UploadRate((int)kilobitPerSecond, UploadRate.UploadRateUnit.KilobitPerSecond));
    }

    public static /* synthetic */ void getProgressPercent$annotations() {
    }

    public final int getProgressPercent() {
        return this.totalBytes == 0L ? 0 : (int)(this.uploadedBytes * (long)100 / this.totalBytes);
    }

    public static /* synthetic */ void getSuccessfullyUploadedFiles$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    public final int getSuccessfullyUploadedFiles() {
        int n;
        Iterable $this$count$iv = this.files;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                UploadFile it = (UploadFile)element$iv;
                boolean bl = false;
                if (!it.getSuccessfullyUploaded()) continue;
                int n2 = ++count$iv;
                boolean bl2 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    @NotNull
    public final String getUploadId() {
        return this.uploadId;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final long getUploadedBytes() {
        return this.uploadedBytes;
    }

    public final long getTotalBytes() {
        return this.totalBytes;
    }

    public final int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    @NotNull
    public final ArrayList<UploadFile> getFiles() {
        return this.files;
    }

    @JvmOverloads
    public UploadInfo(@NotNull String uploadId, long startTime, long uploadedBytes, long totalBytes, int numberOfRetries, @NotNull ArrayList<UploadFile> files) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        this.uploadId = uploadId;
        this.startTime = startTime;
        this.uploadedBytes = uploadedBytes;
        this.totalBytes = totalBytes;
        this.numberOfRetries = numberOfRetries;
        this.files = files;
    }

    public /* synthetic */ UploadInfo(String string, long l, long l2, long l3, int n, ArrayList arrayList, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            l = 0L;
        }
        if ((n2 & 4) != 0) {
            l2 = 0L;
        }
        if ((n2 & 8) != 0) {
            l3 = 0L;
        }
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        if ((n2 & 0x20) != 0) {
            arrayList = new ArrayList<UploadFile>();
        }
        this(string, l, l2, l3, n, arrayList);
    }

    @JvmOverloads
    public UploadInfo(@NotNull String uploadId, long startTime, long uploadedBytes, long totalBytes, int numberOfRetries) {
        this(uploadId, startTime, uploadedBytes, totalBytes, numberOfRetries, null, 32, null);
    }

    @JvmOverloads
    public UploadInfo(@NotNull String uploadId, long startTime, long uploadedBytes, long totalBytes) {
        this(uploadId, startTime, uploadedBytes, totalBytes, 0, null, 48, null);
    }

    @JvmOverloads
    public UploadInfo(@NotNull String uploadId, long startTime, long uploadedBytes) {
        this(uploadId, startTime, uploadedBytes, 0L, 0, null, 56, null);
    }

    @JvmOverloads
    public UploadInfo(@NotNull String uploadId, long startTime) {
        this(uploadId, startTime, 0L, 0L, 0, null, 60, null);
    }

    @JvmOverloads
    public UploadInfo(@NotNull String uploadId) {
        this(uploadId, 0L, 0L, 0L, 0, null, 62, null);
    }

    @NotNull
    public final String component1() {
        return this.uploadId;
    }

    public final long component2() {
        return this.startTime;
    }

    public final long component3() {
        return this.uploadedBytes;
    }

    public final long component4() {
        return this.totalBytes;
    }

    public final int component5() {
        return this.numberOfRetries;
    }

    @NotNull
    public final ArrayList<UploadFile> component6() {
        return this.files;
    }

    @NotNull
    public final UploadInfo copy(@NotNull String uploadId, long startTime, long uploadedBytes, long totalBytes, int numberOfRetries, @NotNull ArrayList<UploadFile> files) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        return new UploadInfo(uploadId, startTime, uploadedBytes, totalBytes, numberOfRetries, files);
    }

    public static /* synthetic */ UploadInfo copy$default(UploadInfo uploadInfo, String string, long l, long l2, long l3, int n, ArrayList arrayList, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = uploadInfo.uploadId;
        }
        if ((n2 & 2) != 0) {
            l = uploadInfo.startTime;
        }
        if ((n2 & 4) != 0) {
            l2 = uploadInfo.uploadedBytes;
        }
        if ((n2 & 8) != 0) {
            l3 = uploadInfo.totalBytes;
        }
        if ((n2 & 0x10) != 0) {
            n = uploadInfo.numberOfRetries;
        }
        if ((n2 & 0x20) != 0) {
            arrayList = uploadInfo.files;
        }
        return uploadInfo.copy(string, l, l2, l3, n, arrayList);
    }

    @NotNull
    public String toString() {
        return "UploadInfo(uploadId=" + this.uploadId + ", startTime=" + this.startTime + ", uploadedBytes=" + this.uploadedBytes + ", totalBytes=" + this.totalBytes + ", numberOfRetries=" + this.numberOfRetries + ", files=" + this.files + ")";
    }

    public int hashCode() {
        String string = this.uploadId;
        long l = this.startTime;
        long l2 = this.uploadedBytes;
        long l3 = this.totalBytes;
        ArrayList<UploadFile> arrayList = this.files;
        return (((((string != null ? string.hashCode() : 0) * 31 + (int)(l ^ l >>> 32)) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (int)(l3 ^ l3 >>> 32)) * 31 + this.numberOfRetries) * 31 + (arrayList != null ? ((Object)arrayList).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof UploadInfo)) break block3;
                UploadInfo uploadInfo = (UploadInfo)object;
                if (!Intrinsics.areEqual((Object)this.uploadId, (Object)uploadInfo.uploadId) || this.startTime != uploadInfo.startTime || this.uploadedBytes != uploadInfo.uploadedBytes || this.totalBytes != uploadInfo.totalBytes || this.numberOfRetries != uploadInfo.numberOfRetries || !Intrinsics.areEqual(this.files, uploadInfo.files)) break block3;
            }
            return true;
        }
        return false;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel parcel, int flags) {
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        parcel.writeString(this.uploadId);
        parcel.writeLong(this.startTime);
        parcel.writeLong(this.uploadedBytes);
        parcel.writeLong(this.totalBytes);
        parcel.writeInt(this.numberOfRetries);
        ArrayList<UploadFile> arrayList = this.files;
        parcel.writeInt(arrayList.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            iterator = iterator;
            ((UploadFile)iterator.next()).writeToParcel(parcel, 0);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class Creator
    implements Parcelable.Creator {
        @NotNull
        public final Object[] newArray(int size2) {
            return new UploadInfo[size2];
        }

        @NotNull
        public final Object createFromParcel(@NotNull Parcel in) {
            int n;
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            String string = in.readString();
            long l = in.readLong();
            long l2 = in.readLong();
            long l3 = in.readLong();
            int n2 = n = in.readInt();
            ArrayList<UploadFile> arrayList = new ArrayList<UploadFile>(n);
            int n3 = n;
            while (n3 != 0) {
                arrayList.add((UploadFile)UploadFile.CREATOR.createFromParcel(in));
                arrayList = arrayList;
                n3 = n3 + -1;
            }
            return new UploadInfo(string, l, l2, l3, n2, arrayList);
        }
    }
}

