/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.observer.task;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.core.app.NotificationCompat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.android.parcel.Parcelize;
import net.gotev.uploadservice.UploadService;
import net.gotev.uploadservice.UploadServiceConfig;
import net.gotev.uploadservice.data.UploadInfo;
import net.gotev.uploadservice.data.UploadNotificationConfig;
import net.gotev.uploadservice.data.UploadNotificationStatusConfig;
import net.gotev.uploadservice.exceptions.UserCancelledUploadException;
import net.gotev.uploadservice.extensions.NotificationManagerExtensionsKt;
import net.gotev.uploadservice.network.ServerResponse;
import net.gotev.uploadservice.observer.task.UploadTaskObserver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0002*+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\rJ.\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\"2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0$H&J \u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010(\u001a\u00020)H\u0002R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lnet/gotev/uploadservice/observer/task/AbstractSingleNotificationHandler;", "Lnet/gotev/uploadservice/observer/task/UploadTaskObserver;", "service", "Lnet/gotev/uploadservice/UploadService;", "(Lnet/gotev/uploadservice/UploadService;)V", "notificationManager", "Landroid/app/NotificationManager;", "getNotificationManager", "()Landroid/app/NotificationManager;", "notificationManager$delegate", "Lkotlin/Lazy;", "tasks", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lnet/gotev/uploadservice/observer/task/AbstractSingleNotificationHandler$TaskData;", "onCompleted", "", "info", "Lnet/gotev/uploadservice/data/UploadInfo;", "notificationId", "", "notificationConfig", "Lnet/gotev/uploadservice/data/UploadNotificationConfig;", "onError", "exception", "", "onProgress", "onStart", "onSuccess", "response", "Lnet/gotev/uploadservice/network/ServerResponse;", "removeTask", "uploadId", "updateNotification", "Landroidx/core/app/NotificationCompat$Builder;", "notificationBuilder", "", "updateTask", "status", "Lnet/gotev/uploadservice/observer/task/AbstractSingleNotificationHandler$TaskStatus;", "config", "Lnet/gotev/uploadservice/data/UploadNotificationStatusConfig;", "TaskData", "TaskStatus", "uploadservice_release"})
public abstract class AbstractSingleNotificationHandler
implements UploadTaskObserver {
    private final ConcurrentHashMap<String, TaskData> tasks;
    private final Lazy notificationManager$delegate;
    private final UploadService service;

    private final NotificationManager getNotificationManager() {
        Lazy lazy = this.notificationManager$delegate;
        AbstractSingleNotificationHandler abstractSingleNotificationHandler = this;
        Object var3_3 = null;
        boolean bl = false;
        return (NotificationManager)lazy.getValue();
    }

    public final void removeTask(@NotNull String uploadId) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        this.tasks.remove(uploadId);
    }

    @Nullable
    public abstract NotificationCompat.Builder updateNotification(@NotNull NotificationManager var1, @NotNull NotificationCompat.Builder var2, @NotNull Map<String, TaskData> var3);

    private final synchronized void updateTask(TaskStatus status, UploadInfo info, UploadNotificationStatusConfig config) {
        ((Map)this.tasks).put(info.getUploadId(), new TaskData(status, info, config));
        Context context = (Context)this.service;
        String string = UploadServiceConfig.getDefaultNotificationChannel();
        Intrinsics.checkNotNull((Object)string);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context, string);
        NotificationCompat.Builder builder2 = this.updateNotification(this.getNotificationManager(), builder, new HashMap(this.tasks));
        if (builder2 == null || (builder2 = builder2.setGroup(UploadServiceConfig.getNamespace())) == null || (builder2 = builder2.setOngoing(true)) == null || (builder2 = builder2.build()) == null) {
            return;
        }
        NotificationCompat.Builder notification = builder2;
        String string2 = this.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"javaClass.name");
        this.service.holdForegroundNotification(string2, (Notification)notification);
    }

    @Override
    public void onStart(@NotNull UploadInfo info, int notificationId, @NotNull UploadNotificationConfig notificationConfig2) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)notificationConfig2, (String)"notificationConfig");
        this.updateTask(TaskStatus.InProgress, info, notificationConfig2.getProgress());
    }

    @Override
    public void onProgress(@NotNull UploadInfo info, int notificationId, @NotNull UploadNotificationConfig notificationConfig2) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)notificationConfig2, (String)"notificationConfig");
        this.updateTask(TaskStatus.InProgress, info, notificationConfig2.getProgress());
    }

    @Override
    public void onSuccess(@NotNull UploadInfo info, int notificationId, @NotNull UploadNotificationConfig notificationConfig2, @NotNull ServerResponse response) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)notificationConfig2, (String)"notificationConfig");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.updateTask(TaskStatus.Succeeded, info, notificationConfig2.getSuccess());
    }

    @Override
    public void onError(@NotNull UploadInfo info, int notificationId, @NotNull UploadNotificationConfig notificationConfig2, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)notificationConfig2, (String)"notificationConfig");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        if (exception instanceof UserCancelledUploadException) {
            this.updateTask(TaskStatus.Cancelled, info, notificationConfig2.getCancelled());
        } else {
            this.updateTask(TaskStatus.Failed, info, notificationConfig2.getCancelled());
        }
    }

    @Override
    public void onCompleted(@NotNull UploadInfo info, int notificationId, @NotNull UploadNotificationConfig notificationConfig2) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)notificationConfig2, (String)"notificationConfig");
    }

    public AbstractSingleNotificationHandler(@NotNull UploadService service) {
        Intrinsics.checkNotNullParameter((Object)((Object)service), (String)"service");
        this.service = service;
        this.tasks = new ConcurrentHashMap();
        this.notificationManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NotificationManager>(this){
            final /* synthetic */ AbstractSingleNotificationHandler this$0;

            @NotNull
            public final NotificationManager invoke() {
                Object object = AbstractSingleNotificationHandler.access$getService$p(this.this$0).getSystemService("notification");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.app.NotificationManager");
                }
                return (NotificationManager)object;
            }
            {
                this.this$0 = abstractSingleNotificationHandler;
                super(0);
            }
        }));
        NotificationManager notificationManager2 = this.getNotificationManager();
        String string = UploadServiceConfig.getDefaultNotificationChannel();
        Intrinsics.checkNotNull((Object)string);
        NotificationManagerExtensionsKt.validateNotificationChannel(notificationManager2, string);
    }

    public static final /* synthetic */ UploadService access$getService$p(AbstractSingleNotificationHandler $this) {
        return $this.service;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/gotev/uploadservice/observer/task/AbstractSingleNotificationHandler$TaskStatus;", "", "(Ljava/lang/String;I)V", "InProgress", "Succeeded", "Failed", "Cancelled", "uploadservice_release"})
    public static final class TaskStatus
    extends Enum<TaskStatus> {
        public static final /* enum */ TaskStatus InProgress;
        public static final /* enum */ TaskStatus Succeeded;
        public static final /* enum */ TaskStatus Failed;
        public static final /* enum */ TaskStatus Cancelled;
        private static final /* synthetic */ TaskStatus[] $VALUES;

        static {
            TaskStatus[] taskStatusArray = new TaskStatus[4];
            TaskStatus[] taskStatusArray2 = taskStatusArray;
            taskStatusArray[0] = InProgress = new TaskStatus();
            taskStatusArray[1] = Succeeded = new TaskStatus();
            taskStatusArray[2] = Failed = new TaskStatus();
            taskStatusArray[3] = Cancelled = new TaskStatus();
            $VALUES = taskStatusArray;
        }

        public static TaskStatus[] values() {
            return (TaskStatus[])$VALUES.clone();
        }

        public static TaskStatus valueOf(String string) {
            return Enum.valueOf(TaskStatus.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u0019\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lnet/gotev/uploadservice/observer/task/AbstractSingleNotificationHandler$TaskData;", "Landroid/os/Parcelable;", "status", "Lnet/gotev/uploadservice/observer/task/AbstractSingleNotificationHandler$TaskStatus;", "info", "Lnet/gotev/uploadservice/data/UploadInfo;", "config", "Lnet/gotev/uploadservice/data/UploadNotificationStatusConfig;", "(Lnet/gotev/uploadservice/observer/task/AbstractSingleNotificationHandler$TaskStatus;Lnet/gotev/uploadservice/data/UploadInfo;Lnet/gotev/uploadservice/data/UploadNotificationStatusConfig;)V", "getConfig", "()Lnet/gotev/uploadservice/data/UploadNotificationStatusConfig;", "getInfo", "()Lnet/gotev/uploadservice/data/UploadInfo;", "getStatus", "()Lnet/gotev/uploadservice/observer/task/AbstractSingleNotificationHandler$TaskStatus;", "component1", "component2", "component3", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "uploadservice_release"})
    @Parcelize
    public static final class TaskData
    implements Parcelable {
        @NotNull
        private final TaskStatus status;
        @NotNull
        private final UploadInfo info;
        @NotNull
        private final UploadNotificationStatusConfig config;
        public static final Parcelable.Creator CREATOR = new Creator();

        @NotNull
        public final TaskStatus getStatus() {
            return this.status;
        }

        @NotNull
        public final UploadInfo getInfo() {
            return this.info;
        }

        @NotNull
        public final UploadNotificationStatusConfig getConfig() {
            return this.config;
        }

        public TaskData(@NotNull TaskStatus status, @NotNull UploadInfo info, @NotNull UploadNotificationStatusConfig config) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.status = status;
            this.info = info;
            this.config = config;
        }

        @NotNull
        public final TaskStatus component1() {
            return this.status;
        }

        @NotNull
        public final UploadInfo component2() {
            return this.info;
        }

        @NotNull
        public final UploadNotificationStatusConfig component3() {
            return this.config;
        }

        @NotNull
        public final TaskData copy(@NotNull TaskStatus status, @NotNull UploadInfo info, @NotNull UploadNotificationStatusConfig config) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return new TaskData(status, info, config);
        }

        public static /* synthetic */ TaskData copy$default(TaskData taskData, TaskStatus taskStatus, UploadInfo uploadInfo, UploadNotificationStatusConfig uploadNotificationStatusConfig, int n, Object object) {
            if ((n & 1) != 0) {
                taskStatus = taskData.status;
            }
            if ((n & 2) != 0) {
                uploadInfo = taskData.info;
            }
            if ((n & 4) != 0) {
                uploadNotificationStatusConfig = taskData.config;
            }
            return taskData.copy(taskStatus, uploadInfo, uploadNotificationStatusConfig);
        }

        @NotNull
        public String toString() {
            return "TaskData(status=" + (Object)((Object)this.status) + ", info=" + this.info + ", config=" + this.config + ")";
        }

        public int hashCode() {
            TaskStatus taskStatus = this.status;
            UploadInfo uploadInfo = this.info;
            UploadNotificationStatusConfig uploadNotificationStatusConfig = this.config;
            return ((taskStatus != null ? ((Object)((Object)taskStatus)).hashCode() : 0) * 31 + (uploadInfo != null ? ((Object)uploadInfo).hashCode() : 0)) * 31 + (uploadNotificationStatusConfig != null ? ((Object)uploadNotificationStatusConfig).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof TaskData)) break block3;
                    TaskData taskData = (TaskData)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.status), (Object)((Object)taskData.status)) || !Intrinsics.areEqual((Object)this.info, (Object)taskData.info) || !Intrinsics.areEqual((Object)this.config, (Object)taskData.config)) break block3;
                }
                return true;
            }
            return false;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel parcel, int flags) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            parcel.writeString(this.status.name());
            this.info.writeToParcel(parcel, 0);
            this.config.writeToParcel(parcel, 0);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
        public static final class Creator
        implements Parcelable.Creator {
            @NotNull
            public final Object[] newArray(int size2) {
                return new TaskData[size2];
            }

            @NotNull
            public final Object createFromParcel(@NotNull Parcel in) {
                Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                return new TaskData(Enum.valueOf(TaskStatus.class, in.readString()), (UploadInfo)UploadInfo.CREATOR.createFromParcel(in), (UploadNotificationStatusConfig)UploadNotificationStatusConfig.CREATOR.createFromParcel(in));
            }
        }
    }
}

