/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice;

import android.content.Context;
import androidx.lifecycle.LifecycleOwner;
import java.util.ArrayList;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.gotev.uploadservice.UploadService;
import net.gotev.uploadservice.UploadServiceConfig;
import net.gotev.uploadservice.UploadTask;
import net.gotev.uploadservice.data.UploadFile;
import net.gotev.uploadservice.data.UploadNotificationConfig;
import net.gotev.uploadservice.data.UploadTaskParameters;
import net.gotev.uploadservice.extensions.ContextExtensionsKt;
import net.gotev.uploadservice.observer.request.RequestObserver;
import net.gotev.uploadservice.observer.request.RequestObserverDelegate;
import net.gotev.uploadservice.persistence.Persistable;
import net.gotev.uploadservice.persistence.PersistableData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u00103\u001a\u000204H$J\r\u00105\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u00106J\u0013\u00107\u001a\u00028\u00002\u0006\u00108\u001a\u00020\t\u00a2\u0006\u0002\u00109J\u0013\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010:JC\u0010#\u001a\u00028\u000026\u0010;\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u0003\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020 0\u001c\u00a2\u0006\u0002\u0010<J\u0013\u0010=\u001a\u00028\u00002\u0006\u0010>\u001a\u00020\u0006\u00a2\u0006\u0002\u0010?J\b\u0010@\u001a\u00020\u0006H\u0016J\u001e\u0010A\u001a\u00020B2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FJ\u000e\u0010A\u001a\u00020G2\u0006\u0010H\u001a\u00020BJ\b\u0010I\u001a\u000204H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aRJ\u0010\u001b\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u0003\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020 0\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010\u0005\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020,0+X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u000e\u0010\u001f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\u0002008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u0006J"}, d2={"Lnet/gotev/uploadservice/UploadRequest;", "B", "Lnet/gotev/uploadservice/persistence/Persistable;", "context", "Landroid/content/Context;", "serverUrl", "", "(Landroid/content/Context;Ljava/lang/String;)V", "autoDeleteSuccessfullyUploadedFiles", "", "getAutoDeleteSuccessfullyUploadedFiles", "()Z", "setAutoDeleteSuccessfullyUploadedFiles", "(Z)V", "getContext", "()Landroid/content/Context;", "files", "Ljava/util/ArrayList;", "Lnet/gotev/uploadservice/data/UploadFile;", "getFiles", "()Ljava/util/ArrayList;", "maxRetries", "", "getMaxRetries", "()I", "setMaxRetries", "(I)V", "notificationConfig", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "uploadId", "Lnet/gotev/uploadservice/data/UploadNotificationConfig;", "getNotificationConfig", "()Lkotlin/jvm/functions/Function2;", "setNotificationConfig", "(Lkotlin/jvm/functions/Function2;)V", "getServerUrl", "()Ljava/lang/String;", "setServerUrl", "(Ljava/lang/String;)V", "started", "taskClass", "Ljava/lang/Class;", "Lnet/gotev/uploadservice/UploadTask;", "getTaskClass", "()Ljava/lang/Class;", "uploadTaskParameters", "Lnet/gotev/uploadservice/data/UploadTaskParameters;", "getUploadTaskParameters", "()Lnet/gotev/uploadservice/data/UploadTaskParameters;", "getAdditionalParameters", "Lnet/gotev/uploadservice/persistence/PersistableData;", "self", "()Lnet/gotev/uploadservice/UploadRequest;", "setAutoDeleteFilesAfterSuccessfulUpload", "autoDeleteFiles", "(Z)Lnet/gotev/uploadservice/UploadRequest;", "(I)Lnet/gotev/uploadservice/UploadRequest;", "config", "(Lkotlin/jvm/functions/Function2;)Lnet/gotev/uploadservice/UploadRequest;", "setUploadID", "uploadID", "(Ljava/lang/String;)Lnet/gotev/uploadservice/UploadRequest;", "startUpload", "subscribe", "Lnet/gotev/uploadservice/observer/request/RequestObserver;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "delegate", "Lnet/gotev/uploadservice/observer/request/RequestObserverDelegate;", "", "observer", "toPersistableData", "uploadservice_release"})
public abstract class UploadRequest<B extends UploadRequest<B>>
implements Persistable {
    private String uploadId;
    private boolean started;
    private int maxRetries;
    private boolean autoDeleteSuccessfullyUploadedFiles;
    @NotNull
    private Function2<? super Context, ? super String, UploadNotificationConfig> notificationConfig;
    @NotNull
    private final ArrayList<UploadFile> files;
    @NotNull
    private final Context context;
    @NotNull
    private String serverUrl;

    protected final int getMaxRetries() {
        return this.maxRetries;
    }

    protected final void setMaxRetries(int n) {
        this.maxRetries = n;
    }

    protected final boolean getAutoDeleteSuccessfullyUploadedFiles() {
        return this.autoDeleteSuccessfullyUploadedFiles;
    }

    protected final void setAutoDeleteSuccessfullyUploadedFiles(boolean bl) {
        this.autoDeleteSuccessfullyUploadedFiles = bl;
    }

    @NotNull
    protected final Function2<Context, String, UploadNotificationConfig> getNotificationConfig() {
        return this.notificationConfig;
    }

    protected final void setNotificationConfig(@NotNull Function2<? super Context, ? super String, UploadNotificationConfig> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.notificationConfig = function2;
    }

    @NotNull
    protected final ArrayList<UploadFile> getFiles() {
        return this.files;
    }

    @NotNull
    protected abstract Class<? extends UploadTask> getTaskClass();

    private final UploadTaskParameters getUploadTaskParameters() {
        String string = this.getTaskClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"taskClass.name");
        return new UploadTaskParameters(string, this.uploadId, this.serverUrl, this.maxRetries, this.autoDeleteSuccessfullyUploadedFiles, this.files, this.getAdditionalParameters());
    }

    @NotNull
    public String startUpload() {
        boolean bl = !this.started;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "You have already called startUpload() on this Upload request instance once and you cannot call it multiple times. Check your code.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = !UploadService.Companion.getTaskList().contains(this.getUploadTaskParameters().getId());
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "You have tried to perform startUpload() using the same uploadID of an already running task. You're trying to use the same ID for multiple uploads.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.started = true;
        return ContextExtensionsKt.startNewUpload(this.context, this.getUploadTaskParameters(), (UploadNotificationConfig)this.notificationConfig.invoke((Object)this.context, (Object)this.uploadId));
    }

    public final void subscribe(@NotNull RequestObserver observer) {
        Intrinsics.checkNotNullParameter((Object)((Object)observer), (String)"observer");
        observer.subscribe(this);
    }

    @NotNull
    public final RequestObserver subscribe(@NotNull Context context, @NotNull LifecycleOwner lifecycleOwner, @NotNull RequestObserverDelegate delegate) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        RequestObserver requestObserver = new RequestObserver(context, lifecycleOwner, delegate, null, 8, null);
        boolean bl = false;
        boolean bl2 = false;
        RequestObserver $this$apply = requestObserver;
        boolean bl3 = false;
        $this$apply.subscribe(this);
        return requestObserver;
    }

    @NotNull
    protected abstract PersistableData getAdditionalParameters();

    @NotNull
    protected final B self() {
        UploadRequest uploadRequest = this;
        if (uploadRequest == null) {
            throw new NullPointerException("null cannot be cast to non-null type B");
        }
        return (B)uploadRequest;
    }

    @NotNull
    public final B setNotificationConfig(@NotNull Function2<? super Context, ? super String, UploadNotificationConfig> config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        this.notificationConfig = config;
        return this.self();
    }

    @NotNull
    public final B setAutoDeleteFilesAfterSuccessfulUpload(boolean autoDeleteFiles) {
        this.autoDeleteSuccessfullyUploadedFiles = autoDeleteFiles;
        return this.self();
    }

    @NotNull
    public final B setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this.self();
    }

    @NotNull
    public final B setUploadID(@NotNull String uploadID) {
        Intrinsics.checkNotNullParameter((Object)uploadID, (String)"uploadID");
        this.uploadId = uploadID;
        return this.self();
    }

    @Override
    @NotNull
    public PersistableData toPersistableData() {
        return this.getUploadTaskParameters().toPersistableData();
    }

    @NotNull
    protected final Context getContext() {
        return this.context;
    }

    @NotNull
    protected final String getServerUrl() {
        return this.serverUrl;
    }

    protected final void setServerUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.serverUrl = string;
    }

    public UploadRequest(@NotNull Context context, @NotNull String serverUrl) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        this.context = context;
        this.serverUrl = serverUrl;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
        this.uploadId = string;
        this.maxRetries = UploadServiceConfig.getRetryPolicy().getDefaultMaxRetries();
        this.notificationConfig = UploadServiceConfig.getNotificationConfigFactory();
        this.files = new ArrayList();
        CharSequence charSequence = this.serverUrl;
        boolean bl = false;
        boolean bl2 = !StringsKt.isBlank((CharSequence)charSequence);
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string2 = "Server URL cannot be empty";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
    }
}

