/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice;

import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.PowerManager;
import androidx.core.app.NotificationCompat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.gotev.uploadservice.UploadService;
import net.gotev.uploadservice.UploadServiceConfig;
import net.gotev.uploadservice.UploadTask;
import net.gotev.uploadservice.extensions.ContextExtensionsKt;
import net.gotev.uploadservice.extensions.UploadTaskCreationParameters;
import net.gotev.uploadservice.extensions.WakeLockExtensionsKt;
import net.gotev.uploadservice.logger.UploadServiceLogger;
import net.gotev.uploadservice.observer.request.NotificationActionsObserver;
import net.gotev.uploadservice.observer.task.BroadcastEmitter;
import net.gotev.uploadservice.observer.task.TaskCompletionNotifier;
import net.gotev.uploadservice.observer.task.UploadTaskObserver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0015H\u0016J\b\u0010!\u001a\u00020\u0015H\u0016J\"\u0010\"\u001a\u00020#2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#H\u0016J\b\u0010&\u001a\u00020#H\u0002J\u000e\u0010'\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\n\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\b\u0018\u00010\u0012R\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lnet/gotev/uploadservice/UploadService;", "Landroid/app/Service;", "()V", "idleTimer", "Ljava/util/Timer;", "notificationActionsObserver", "Lnet/gotev/uploadservice/observer/request/NotificationActionsObserver;", "getNotificationActionsObserver", "()Lnet/gotev/uploadservice/observer/request/NotificationActionsObserver;", "notificationActionsObserver$delegate", "Lkotlin/Lazy;", "taskObservers", "", "Lnet/gotev/uploadservice/observer/task/UploadTaskObserver;", "getTaskObservers", "()[Lnet/gotev/uploadservice/observer/task/UploadTaskObserver;", "taskObservers$delegate", "wakeLock", "Landroid/os/PowerManager$WakeLock;", "Landroid/os/PowerManager;", "clearIdleTimer", "", "holdForegroundNotification", "", "uploadId", "", "notification", "Landroid/app/Notification;", "onBind", "Landroid/os/IBinder;", "intent", "Landroid/content/Intent;", "onCreate", "onDestroy", "onStartCommand", "", "flags", "startId", "shutdownIfThereArentAnyActiveTasks", "taskCompleted", "Companion", "uploadservice_release"})
public final class UploadService
extends Service {
    private PowerManager.WakeLock wakeLock;
    private Timer idleTimer;
    private final Lazy taskObservers$delegate = LazyKt.lazy((Function0)((Function0)new Function0<UploadTaskObserver[]>(this){
        final /* synthetic */ UploadService this$0;

        @NotNull
        public final UploadTaskObserver[] invoke() {
            return new UploadTaskObserver[]{new BroadcastEmitter((Context)this.this$0), (UploadTaskObserver)UploadServiceConfig.getNotificationHandlerFactory().invoke((Object)((Object)this.this$0)), new TaskCompletionNotifier(this.this$0)};
        }
        {
            this.this$0 = uploadService;
            super(0);
        }
    }));
    private final Lazy notificationActionsObserver$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NotificationActionsObserver>(this){
        final /* synthetic */ UploadService this$0;

        @NotNull
        public final NotificationActionsObserver invoke() {
            return (NotificationActionsObserver)((Object)UploadServiceConfig.getNotificationActionsObserverFactory().invoke((Object)((Object)this.this$0)));
        }
        {
            this.this$0 = uploadService;
            super(0);
        }
    }));
    private static final String TAG;
    private static final int UPLOAD_NOTIFICATION_BASE_ID = 1234;
    private static int notificationIncrementalId;
    private static final ConcurrentHashMap<String, UploadTask> uploadTasksMap;
    private static volatile String foregroundUploadId;
    @NotNull
    public static final Companion Companion;

    private final UploadTaskObserver[] getTaskObservers() {
        Lazy lazy = this.taskObservers$delegate;
        UploadService uploadService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (UploadTaskObserver[])lazy.getValue();
    }

    private final NotificationActionsObserver getNotificationActionsObserver() {
        Lazy lazy = this.notificationActionsObserver$delegate;
        UploadService uploadService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (NotificationActionsObserver)((Object)lazy.getValue());
    }

    private final synchronized void clearIdleTimer() {
        Timer timer = this.idleTimer;
        if (timer != null) {
            Timer timer2 = timer;
            boolean bl = false;
            boolean bl2 = false;
            Timer $this$apply = timer2;
            boolean bl3 = false;
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            UploadServiceLogger.info(string, "N/A", (Function0<String>)((Function0)clearIdleTimer.1.1.INSTANCE));
            $this$apply.cancel();
        }
        this.idleTimer = null;
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized int shutdownIfThereArentAnyActiveTasks() {
        if (uploadTasksMap.isEmpty()) {
            void $this$apply;
            this.clearIdleTimer();
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            UploadServiceLogger.info(string, "N/A", (Function0<String>)((Function0)shutdownIfThereArentAnyActiveTasks.1.INSTANCE));
            Timer timer = new Timer(TAG + "IdleTimer");
            boolean bl = false;
            boolean bl2 = false;
            Timer timer2 = timer;
            UploadService uploadService = this;
            boolean bl3 = false;
            $this$apply.schedule(new TimerTask(this){
                final /* synthetic */ UploadService this$0;
                {
                    this.this$0 = uploadService;
                }

                public void run() {
                    String string = UploadService.Companion.getTAG$uploadservice_release();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                    UploadServiceLogger.info(string, "N/A", (Function0<String>)((Function0)shutdownIfThereArentAnyActiveTasks.2.run.1.INSTANCE));
                    this.this$0.stopSelf();
                }
            }, UploadServiceConfig.getIdleTimeoutSeconds() * 1000);
            Unit unit = Unit.INSTANCE;
            uploadService.idleTimer = timer;
            return 2;
        }
        return 1;
    }

    public final synchronized boolean holdForegroundNotification(@NotNull String uploadId, @NotNull Notification notification) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        if (!UploadServiceConfig.isForegroundService()) {
            return false;
        }
        if (foregroundUploadId == null) {
            foregroundUploadId = uploadId;
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            UploadServiceLogger.debug(string, uploadId, (Function0<String>)((Function0)holdForegroundNotification.1.INSTANCE));
        }
        if (Intrinsics.areEqual((Object)uploadId, (Object)foregroundUploadId)) {
            this.startForeground(1234, notification);
            return true;
        }
        return false;
    }

    public final synchronized void taskCompleted(@NotNull String uploadId) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        UploadTask task = uploadTasksMap.remove(uploadId);
        if (UploadServiceConfig.isForegroundService() && task != null && Intrinsics.areEqual((Object)task.getParams().getId(), (Object)foregroundUploadId)) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            UploadServiceLogger.debug(string, uploadId, (Function0<String>)((Function0)taskCompleted.1.INSTANCE));
            foregroundUploadId = null;
        }
        if (UploadServiceConfig.isForegroundService() && uploadTasksMap.isEmpty()) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            UploadServiceLogger.debug(string, "N/A", (Function0<String>)((Function0)taskCompleted.2.INSTANCE));
            this.stopForeground(true);
            this.shutdownIfThereArentAnyActiveTasks();
        }
    }

    public void onCreate() {
        super.onCreate();
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        this.wakeLock = WakeLockExtensionsKt.acquirePartialWakeLock((Context)this, this.wakeLock, string);
        this.getNotificationActionsObserver().register();
    }

    @Nullable
    public IBinder onBind(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        return null;
    }

    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        UploadServiceLogger.debug(string, "N/A", (Function0<String>)((Function0)onStartCommand.1.INSTANCE));
        Context context = (Context)this;
        String string2 = UploadServiceConfig.getDefaultNotificationChannel();
        Intrinsics.checkNotNull((Object)string2);
        Notification notification = new NotificationCompat.Builder(context, string2).setSmallIcon(17301589).setOngoing(true).setGroup(UploadServiceConfig.getNamespace()).build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"NotificationCompat.Build\u2026ace)\n            .build()");
        Notification notification2 = notification;
        this.startForeground(1234, notification2);
        UploadTaskCreationParameters uploadTaskCreationParameters = ContextExtensionsKt.getUploadTaskCreationParameters(intent);
        if (uploadTaskCreationParameters == null) {
            return this.shutdownIfThereArentAnyActiveTasks();
        }
        UploadTaskCreationParameters taskCreationParameters = uploadTaskCreationParameters;
        if (uploadTasksMap.containsKey(taskCreationParameters.getParams().getId())) {
            String string3 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"TAG");
            UploadServiceLogger.error$default(string3, taskCreationParameters.getParams().getId(), null, onStartCommand.2.INSTANCE, 4, null);
            return this.shutdownIfThereArentAnyActiveTasks();
        }
        UploadTaskObserver[] uploadTaskObserverArray = this.getTaskObservers();
        UploadTask uploadTask = ContextExtensionsKt.getUploadTask((Context)this, taskCreationParameters, 1234 + (notificationIncrementalId += 2), Arrays.copyOf(uploadTaskObserverArray, uploadTaskObserverArray.length));
        if (uploadTask == null) {
            return this.shutdownIfThereArentAnyActiveTasks();
        }
        UploadTask currentTask = uploadTask;
        this.clearIdleTimer();
        ((Map)uploadTasksMap).put(currentTask.getParams().getId(), currentTask);
        UploadServiceConfig.getThreadPool().execute(currentTask);
        return 1;
    }

    public void onDestroy() {
        super.onDestroy();
        this.getNotificationActionsObserver().unregister();
        Companion.stopAllUploads();
        if (UploadServiceConfig.isForegroundService()) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            UploadServiceLogger.debug(string, "N/A", (Function0<String>)((Function0)onDestroy.1.INSTANCE));
            this.stopForeground(true);
        }
        WakeLockExtensionsKt.safeRelease(this.wakeLock);
        uploadTasksMap.clear();
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        UploadServiceLogger.debug(string, "N/A", (Function0<String>)((Function0)onDestroy.2.INSTANCE));
    }

    static {
        Companion = new Companion(null);
        TAG = UploadService.class.getSimpleName();
        uploadTasksMap = new ConcurrentHashMap();
    }

    @JvmStatic
    public static final synchronized void stopUpload(@NotNull String uploadId) {
        Companion.stopUpload(uploadId);
    }

    @NotNull
    public static final synchronized List<String> getTaskList() {
        return Companion.getTaskList();
    }

    @JvmStatic
    public static final synchronized void stopAllUploads() {
        Companion.stopAllUploads();
    }

    @JvmStatic
    @JvmOverloads
    public static final synchronized boolean stop(@NotNull Context context, boolean forceStop) {
        return Companion.stop(context, forceStop);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean stop(@NotNull Context context) {
        return net.gotev.uploadservice.UploadService$Companion.stop$default(Companion, context, false, 2, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0015H\u0007J\b\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0004H\u0007R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lnet/gotev/uploadservice/UploadService$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "getTAG$uploadservice_release", "()Ljava/lang/String;", "UPLOAD_NOTIFICATION_BASE_ID", "", "foregroundUploadId", "notificationIncrementalId", "taskList", "", "getTaskList$annotations", "getTaskList", "()Ljava/util/List;", "uploadTasksMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lnet/gotev/uploadservice/UploadTask;", "stop", "", "context", "Landroid/content/Context;", "forceStop", "stopAllUploads", "", "stopUpload", "uploadId", "uploadservice_release"})
    public static final class Companion {
        public final String getTAG$uploadservice_release() {
            return TAG;
        }

        @JvmStatic
        public final synchronized void stopUpload(@NotNull String uploadId) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
                UploadTask uploadTask = (UploadTask)uploadTasksMap.get(uploadId);
                if (uploadTask == null) break block0;
                uploadTask.cancel();
            }
        }

        @JvmStatic
        public static /* synthetic */ void getTaskList$annotations() {
        }

        @NotNull
        public final synchronized List<String> getTaskList() {
            List list;
            if (uploadTasksMap.isEmpty()) {
                list = CollectionsKt.emptyList();
            } else {
                Enumeration enumeration = uploadTasksMap.keys();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"uploadTasksMap.keys()");
                Enumeration enumeration2 = enumeration;
                boolean bl = false;
                ArrayList arrayList = Collections.list(enumeration2);
                Intrinsics.checkNotNullExpressionValue(arrayList, (String)"java.util.Collections.list(this)");
                list = arrayList;
            }
            return list;
        }

        @JvmStatic
        public final synchronized void stopAllUploads() {
            Iterator iterator = uploadTasksMap.keySet().iterator();
            while (iterator.hasNext()) {
                UploadTask uploadTask = (UploadTask)uploadTasksMap.get(iterator.next());
                if (uploadTask == null) continue;
                uploadTask.cancel();
            }
        }

        @JvmStatic
        @JvmOverloads
        public final synchronized boolean stop(@NotNull Context context, boolean forceStop) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (forceStop) {
                this.stopAllUploads();
                bl = context.stopService(new Intent(context, UploadService.class));
            } else {
                bl = uploadTasksMap.isEmpty() && context.stopService(new Intent(context, UploadService.class));
            }
            return bl;
        }

        public static /* synthetic */ boolean stop$default(Companion companion, Context context, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.stop(context, bl);
        }

        @JvmStatic
        @JvmOverloads
        public final boolean stop(@NotNull Context context) {
            return net.gotev.uploadservice.UploadService$Companion.stop$default(this, context, false, 2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

