/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.extensions;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Parcelable;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.gotev.uploadservice.UploadService;
import net.gotev.uploadservice.UploadServiceConfig;
import net.gotev.uploadservice.UploadTask;
import net.gotev.uploadservice.data.UploadNotificationConfig;
import net.gotev.uploadservice.data.UploadTaskParameters;
import net.gotev.uploadservice.extensions.ContextExtensionsKt;
import net.gotev.uploadservice.extensions.UploadTaskCreationParameters;
import net.gotev.uploadservice.logger.UploadServiceLogger;
import net.gotev.uploadservice.observer.task.UploadTaskObserver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0001\u001a\u001a\u0010\u0011\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001\u001a5\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019\"\u00020\u001a\u00a2\u0006\u0002\u0010\u001b\u001a\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u0016*\u0004\u0018\u00010\u0007\u001a\u001a\u0010\u001d\u001a\u00020\u0001*\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\""}, d2={"actionKey", "", "cancelUploadAction", "taskNotificationConfig", "taskParametersKey", "uploadIdKey", "uploadIdToCancel", "Landroid/content/Intent;", "getUploadIdToCancel", "(Landroid/content/Intent;)Ljava/lang/String;", "flagsCompat", "", "flags", "getCancelUploadIntent", "Landroid/app/PendingIntent;", "Landroid/content/Context;", "uploadId", "getNotificationActionIntent", "action", "getUploadTask", "Lnet/gotev/uploadservice/UploadTask;", "creationParameters", "Lnet/gotev/uploadservice/extensions/UploadTaskCreationParameters;", "notificationId", "observers", "", "Lnet/gotev/uploadservice/observer/task/UploadTaskObserver;", "(Landroid/content/Context;Lnet/gotev/uploadservice/extensions/UploadTaskCreationParameters;I[Lnet/gotev/uploadservice/observer/task/UploadTaskObserver;)Lnet/gotev/uploadservice/UploadTask;", "getUploadTaskCreationParameters", "startNewUpload", "params", "Lnet/gotev/uploadservice/data/UploadTaskParameters;", "notificationConfig", "Lnet/gotev/uploadservice/data/UploadNotificationConfig;", "uploadservice_release"})
public final class ContextExtensionsKt {
    private static final String taskParametersKey = "taskParameters";
    private static final String taskNotificationConfig = "taskUploadConfig";
    private static final String actionKey = "action";
    private static final String uploadIdKey = "uploadId";
    private static final String cancelUploadAction = "cancelUpload";

    @NotNull
    public static final String startNewUpload(@NotNull Context $this$startNewUpload, @NotNull UploadTaskParameters params2, @NotNull UploadNotificationConfig notificationConfig2) {
        Intrinsics.checkNotNullParameter((Object)$this$startNewUpload, (String)"$this$startNewUpload");
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        Intrinsics.checkNotNullParameter((Object)notificationConfig2, (String)"notificationConfig");
        Intent intent = new Intent($this$startNewUpload, UploadService.class);
        boolean bl = false;
        boolean bl2 = false;
        Intent $this$apply = intent;
        boolean bl3 = false;
        $this$apply.setAction(UploadServiceConfig.getUploadAction());
        $this$apply.putExtra(taskParametersKey, (Parcelable)params2);
        $this$apply.putExtra(taskNotificationConfig, (Parcelable)notificationConfig2);
        Intent intent2 = intent;
        try {
            $this$startNewUpload.startService(intent2);
        }
        catch (Throwable exc) {
            if (Build.VERSION.SDK_INT >= 26 && exc instanceof IllegalStateException) {
                $this$startNewUpload.startForegroundService(intent2);
            }
            UploadServiceLogger.error("UploadService", params2.getId(), exc, (Function0<String>)((Function0)startNewUpload.1.INSTANCE));
        }
        return params2.getId();
    }

    @Nullable
    public static final UploadTaskCreationParameters getUploadTaskCreationParameters(@Nullable Intent $this$getUploadTaskCreationParameters) {
        Class<?> clazz;
        if ($this$getUploadTaskCreationParameters == null || Intrinsics.areEqual((Object)$this$getUploadTaskCreationParameters.getAction(), (Object)UploadServiceConfig.getUploadAction()) ^ true) {
            String string = UploadService.Companion.getTAG$uploadservice_release();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UploadService.TAG");
            UploadServiceLogger.error$default(string, "N/A", null, getUploadTaskCreationParameters.1.INSTANCE, 4, null);
            return null;
        }
        UploadTaskParameters uploadTaskParameters = (UploadTaskParameters)$this$getUploadTaskCreationParameters.getParcelableExtra(taskParametersKey);
        if (uploadTaskParameters == null) {
            Intent intent = $this$getUploadTaskCreationParameters;
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$run = intent;
            boolean bl3 = false;
            String string = UploadService.Companion.getTAG$uploadservice_release();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UploadService.TAG");
            UploadServiceLogger.error$default(string, "N/A", null, getUploadTaskCreationParameters.params.1.1.INSTANCE, 4, null);
            return null;
        }
        UploadTaskParameters params2 = uploadTaskParameters;
        try {
            clazz = Class.forName(params2.getTaskClass());
        }
        catch (Throwable exc) {
            String string = UploadService.Companion.getTAG$uploadservice_release();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UploadService.TAG");
            UploadServiceLogger.error(string, "N/A", exc, (Function0<String>)((Function0)new Function0<String>(params2){
                final /* synthetic */ UploadTaskParameters $params;

                @NotNull
                public final String invoke() {
                    return "Error while instantiating new task. " + this.$params.getTaskClass() + " does not exist.";
                }
                {
                    this.$params = uploadTaskParameters;
                    super(0);
                }
            }));
            clazz = null;
        }
        Class<?> clazz2 = clazz;
        if (clazz2 == null) {
            return null;
        }
        Class<?> taskClass2 = clazz2;
        if (!UploadTask.class.isAssignableFrom(taskClass2)) {
            String string = UploadService.Companion.getTAG$uploadservice_release();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UploadService.TAG");
            UploadServiceLogger.error$default(string, "N/A", null, (Function0)new Function0<String>(params2){
                final /* synthetic */ UploadTaskParameters $params;

                @NotNull
                public final String invoke() {
                    return "Error while instantiating new task. " + this.$params.getTaskClass() + " does not extend UploadTask.";
                }
                {
                    this.$params = uploadTaskParameters;
                    super(0);
                }
            }, 4, null);
            return null;
        }
        UploadNotificationConfig uploadNotificationConfig = (UploadNotificationConfig)$this$getUploadTaskCreationParameters.getParcelableExtra(taskNotificationConfig);
        if (uploadNotificationConfig == null) {
            Intent intent = $this$getUploadTaskCreationParameters;
            boolean bl = false;
            boolean bl4 = false;
            Intent $this$run = intent;
            boolean bl5 = false;
            String string = UploadService.Companion.getTAG$uploadservice_release();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UploadService.TAG");
            UploadServiceLogger.error$default(string, "N/A", null, getUploadTaskCreationParameters.notificationConfig.1.1.INSTANCE, 4, null);
            return null;
        }
        UploadNotificationConfig notificationConfig2 = uploadNotificationConfig;
        return new UploadTaskCreationParameters(params2, notificationConfig2);
    }

    @Nullable
    public static final UploadTask getUploadTask(@NotNull Context $this$getUploadTask, @NotNull UploadTaskCreationParameters creationParameters, int notificationId, UploadTaskObserver ... observers) {
        UploadTask uploadTask;
        Intrinsics.checkNotNullParameter((Object)$this$getUploadTask, (String)"$this$getUploadTask");
        Intrinsics.checkNotNullParameter((Object)creationParameters, (String)"creationParameters");
        Intrinsics.checkNotNullParameter((Object)observers, (String)"observers");
        try {
            Class<?> clazz = Class.forName(creationParameters.getParams().getTaskClass());
            if (clazz == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<out net.gotev.uploadservice.UploadTask>");
            }
            Class<?> taskClass2 = clazz;
            Object obj = taskClass2.newInstance();
            boolean bl = false;
            boolean bl2 = false;
            UploadTask $this$apply = (UploadTask)obj;
            boolean bl3 = false;
            $this$apply.init($this$getUploadTask, creationParameters.getParams(), creationParameters.getNotificationConfig(), notificationId, Arrays.copyOf(observers, observers.length));
            UploadTask uploadTask2 = (UploadTask)obj;
            String string = UploadService.Companion.getTAG$uploadservice_release();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UploadService.TAG");
            UploadServiceLogger.debug(string, "N/A", (Function0<String>)((Function0)new Function0<String>(taskClass2){
                final /* synthetic */ Class $taskClass;

                @NotNull
                public final String invoke() {
                    return "Successfully created new task with class: " + this.$taskClass.getName();
                }
                {
                    this.$taskClass = clazz;
                    super(0);
                }
            }));
            uploadTask = uploadTask2;
        }
        catch (Throwable exc) {
            String string = UploadService.Companion.getTAG$uploadservice_release();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UploadService.TAG");
            UploadServiceLogger.error(string, "N/A", exc, (Function0<String>)((Function0)getUploadTask.2.INSTANCE));
            uploadTask = null;
        }
        return uploadTask;
    }

    @NotNull
    public static final PendingIntent getNotificationActionIntent(@NotNull Context $this$getNotificationActionIntent, @NotNull String uploadId, @NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)$this$getNotificationActionIntent, (String)"$this$getNotificationActionIntent");
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)uploadIdKey);
        Intrinsics.checkNotNullParameter((Object)action, (String)actionKey);
        Intent intent = new Intent(UploadServiceConfig.getBroadcastNotificationAction());
        boolean bl = false;
        boolean bl2 = false;
        Intent $this$apply = intent;
        boolean bl3 = false;
        $this$apply.setPackage(UploadServiceConfig.getNamespace());
        $this$apply.putExtra(actionKey, action);
        $this$apply.putExtra(uploadIdKey, uploadId);
        Intent intent2 = intent;
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)$this$getNotificationActionIntent, (int)uploadId.hashCode(), (Intent)intent2, (int)ContextExtensionsKt.flagsCompat(0x40000000));
        Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"PendingIntent.getBroadca\u2026tent.FLAG_ONE_SHOT)\n    )");
        return pendingIntent;
    }

    @NotNull
    public static final PendingIntent getCancelUploadIntent(@NotNull Context $this$getCancelUploadIntent, @NotNull String uploadId) {
        Intrinsics.checkNotNullParameter((Object)$this$getCancelUploadIntent, (String)"$this$getCancelUploadIntent");
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)uploadIdKey);
        return ContextExtensionsKt.getNotificationActionIntent($this$getCancelUploadIntent, uploadId, cancelUploadAction);
    }

    @Nullable
    public static final String getUploadIdToCancel(@NotNull Intent $this$uploadIdToCancel) {
        Intrinsics.checkNotNullParameter((Object)$this$uploadIdToCancel, (String)"$this$uploadIdToCancel");
        if (Intrinsics.areEqual((Object)$this$uploadIdToCancel.getStringExtra(actionKey), (Object)cancelUploadAction) ^ true) {
            return null;
        }
        return $this$uploadIdToCancel.getStringExtra(uploadIdKey);
    }

    public static final int flagsCompat(int flags) {
        if (Build.VERSION.SDK_INT > 30) {
            return flags | 0x4000000;
        }
        return flags;
    }
}

