/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.extensions;

import android.webkit.MimeTypeMap;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0001\u001a\f\u0010\n\u001a\u00020\u000b*\u0004\u0018\u00010\u0001\u001a\n\u0010\f\u001a\u00020\u000b*\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\u0004*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\r"}, d2={"APPLICATION_OCTET_STREAM", "", "VIDEO_MP4", "asciiBytes", "", "getAsciiBytes", "(Ljava/lang/String;)[B", "utf8Bytes", "getUtf8Bytes", "autoDetectMimeType", "isASCII", "", "isValidHttpUrl", "uploadservice_release"})
public final class StringExtensionsKt {
    @NotNull
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    @NotNull
    public static final String VIDEO_MP4 = "video/mp4";

    @NotNull
    public static final String autoDetectMimeType(@NotNull String $this$autoDetectMimeType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$autoDetectMimeType, (String)"$this$autoDetectMimeType");
        int index = StringsKt.lastIndexOf$default((CharSequence)$this$autoDetectMimeType, (String)".", (int)0, (boolean)false, (int)6, null);
        int n = index;
        if (0 <= n && StringsKt.getLastIndex((CharSequence)$this$autoDetectMimeType) > n) {
            String string2 = $this$autoDetectMimeType;
            int n2 = index + 1;
            boolean bl = false;
            String string3 = string2.substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            string2 = string3;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
            Locale locale2 = locale;
            bl = false;
            String string4 = string2;
            boolean bl2 = false;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase(locale)");
            String extension = string6;
            if (Intrinsics.areEqual((Object)extension, (Object)"mp4")) {
                string = VIDEO_MP4;
            } else {
                String string7 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
                if (string7 == null) {
                    string7 = APPLICATION_OCTET_STREAM;
                }
                string = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"MimeTypeMap.getSingleton\u2026 APPLICATION_OCTET_STREAM");
            }
        } else {
            string = APPLICATION_OCTET_STREAM;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isASCII(@Nullable String $this$isASCII) {
        CharSequence charSequence = $this$isASCII;
        int n = 0;
        boolean bl = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        int n2 = 0;
        n = $this$isASCII.length();
        while (n2 < n) {
            void index;
            if ($this$isASCII.charAt((int)index) > '\u007f') {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static final boolean isValidHttpUrl(@NotNull String $this$isValidHttpUrl) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isValidHttpUrl, (String)"$this$isValidHttpUrl");
        if (!StringsKt.startsWith$default((String)$this$isValidHttpUrl, (String)"http://", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)$this$isValidHttpUrl, (String)"https://", (boolean)false, (int)2, null)) {
            return false;
        }
        try {
            new URL($this$isValidHttpUrl);
            bl = true;
        }
        catch (Throwable exc) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final byte[] getAsciiBytes(@NotNull String $this$asciiBytes) {
        Intrinsics.checkNotNullParameter((Object)$this$asciiBytes, (String)"$this$asciiBytes");
        String string = $this$asciiBytes;
        Charset charset = Charsets.US_ASCII;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    @NotNull
    public static final byte[] getUtf8Bytes(@NotNull String $this$utf8Bytes) {
        Intrinsics.checkNotNullParameter((Object)$this$utf8Bytes, (String)"$this$utf8Bytes");
        String string = $this$utf8Bytes;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return byArray;
    }
}

