/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice;

import android.content.Context;
import android.util.Base64;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import net.gotev.uploadservice.UploadRequest;
import net.gotev.uploadservice.data.HttpUploadTaskParameters;
import net.gotev.uploadservice.data.NameValue;
import net.gotev.uploadservice.extensions.CollectionsExtensionsKt;
import net.gotev.uploadservice.extensions.StringExtensionsKt;
import net.gotev.uploadservice.persistence.PersistableData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J)\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u00062\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000f\"\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0010J#\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001b\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0017J\u001d\u0010\u0018\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u001b\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u001f\u001a\u00028\u00002\u0006\u0010 \u001a\u00020\u0006\u00a2\u0006\u0002\u0010!J\u0013\u0010\"\u001a\u00028\u00002\u0006\u0010#\u001a\u00020\u0006\u00a2\u0006\u0002\u0010!J\u0013\u0010$\u001a\u00028\u00002\u0006\u0010%\u001a\u00020&\u00a2\u0006\u0002\u0010'R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006("}, d2={"Lnet/gotev/uploadservice/HttpUploadRequest;", "B", "Lnet/gotev/uploadservice/UploadRequest;", "context", "Landroid/content/Context;", "serverUrl", "", "(Landroid/content/Context;Ljava/lang/String;)V", "httpParams", "Lnet/gotev/uploadservice/data/HttpUploadTaskParameters;", "getHttpParams", "()Lnet/gotev/uploadservice/data/HttpUploadTaskParameters;", "addArrayParameter", "paramName", "array", "", "(Ljava/lang/String;[Ljava/lang/String;)Lnet/gotev/uploadservice/HttpUploadRequest;", "list", "", "(Ljava/lang/String;Ljava/util/List;)Lnet/gotev/uploadservice/HttpUploadRequest;", "addHeader", "headerName", "headerValue", "(Ljava/lang/String;Ljava/lang/String;)Lnet/gotev/uploadservice/HttpUploadRequest;", "addParameter", "paramValue", "getAdditionalParameters", "Lnet/gotev/uploadservice/persistence/PersistableData;", "setBasicAuth", "username", "password", "setBearerAuth", "bearerToken", "(Ljava/lang/String;)Lnet/gotev/uploadservice/HttpUploadRequest;", "setMethod", "method", "setUsesFixedLengthStreamingMode", "fixedLength", "", "(Z)Lnet/gotev/uploadservice/HttpUploadRequest;", "uploadservice_release"})
@SourceDebugExtension(value={"SMAP\nHttpUploadRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpUploadRequest.kt\nnet/gotev/uploadservice/HttpUploadRequest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1#2:126\n*E\n"})
public abstract class HttpUploadRequest<B extends HttpUploadRequest<B>>
extends UploadRequest<B> {
    @NotNull
    private final HttpUploadTaskParameters httpParams;

    public HttpUploadRequest(@NotNull Context context, @NotNull String serverUrl) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        super(context, serverUrl);
        this.httpParams = new HttpUploadTaskParameters(null, false, null, null, 15, null);
        if (!StringExtensionsKt.isValidHttpUrl(serverUrl)) {
            boolean bl = false;
            String string = "Specify either http:// or https:// as protocol";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    protected final HttpUploadTaskParameters getHttpParams() {
        return this.httpParams;
    }

    @Override
    @NotNull
    protected PersistableData getAdditionalParameters() {
        return this.httpParams.toPersistableData();
    }

    @NotNull
    public final B addHeader(@NotNull String headerName, @NotNull String headerValue) {
        Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
        Intrinsics.checkNotNullParameter((Object)headerValue, (String)"headerValue");
        CollectionsExtensionsKt.addHeader(this.httpParams.getRequestHeaders(), headerName, headerValue);
        return (B)((HttpUploadRequest)this.self());
    }

    @NotNull
    public final B setBasicAuth(@NotNull String username, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        String string = username + ":" + password;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        String auth = Base64.encodeToString((byte[])byArray, (int)2);
        return this.addHeader("Authorization", "Basic " + auth);
    }

    @NotNull
    public final B setBearerAuth(@NotNull String bearerToken) {
        Intrinsics.checkNotNullParameter((Object)bearerToken, (String)"bearerToken");
        return this.addHeader("Authorization", "Bearer " + bearerToken);
    }

    @NotNull
    public B addParameter(@NotNull String paramName, @NotNull String paramValue) {
        Intrinsics.checkNotNullParameter((Object)paramName, (String)"paramName");
        Intrinsics.checkNotNullParameter((Object)paramValue, (String)"paramValue");
        this.httpParams.getRequestParameters().add(new NameValue(paramName, paramValue));
        return (B)((HttpUploadRequest)this.self());
    }

    @NotNull
    public B addArrayParameter(@NotNull String paramName, String ... array) {
        Intrinsics.checkNotNullParameter((Object)paramName, (String)"paramName");
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        for (String value : array) {
            this.httpParams.getRequestParameters().add(new NameValue(paramName, value));
        }
        return (B)((HttpUploadRequest)this.self());
    }

    @NotNull
    public B addArrayParameter(@NotNull String paramName, @NotNull List<String> list) {
        Intrinsics.checkNotNullParameter((Object)paramName, (String)"paramName");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        for (String value : list) {
            this.httpParams.getRequestParameters().add(new NameValue(paramName, value));
        }
        return (B)((HttpUploadRequest)this.self());
    }

    @NotNull
    public final B setMethod(@NotNull String method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        String string = method.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        this.httpParams.setMethod(string);
        return (B)((HttpUploadRequest)this.self());
    }

    @NotNull
    public final B setUsesFixedLengthStreamingMode(boolean fixedLength) {
        this.httpParams.setUsesFixedLengthStreamingMode(fixedLength);
        return (B)((HttpUploadRequest)this.self());
    }
}

