/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice;

import android.app.Application;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Build;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.gotev.uploadservice.UploadService;
import net.gotev.uploadservice.UploadServiceConfig;
import net.gotev.uploadservice.data.RetryPolicyConfig;
import net.gotev.uploadservice.data.UploadNotificationConfig;
import net.gotev.uploadservice.logger.UploadServiceLogger;
import net.gotev.uploadservice.network.HttpStack;
import net.gotev.uploadservice.network.hurl.HurlStack;
import net.gotev.uploadservice.observer.request.NotificationActionsObserver;
import net.gotev.uploadservice.observer.task.UploadTaskObserver;
import net.gotev.uploadservice.placeholders.DefaultPlaceholdersProcessor;
import net.gotev.uploadservice.placeholders.PlaceholdersProcessor;
import net.gotev.uploadservice.schemehandlers.SchemeHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010{\u001a\u00020|2\u0006\u0010}\u001a\u00020\u00042\u000e\u0010~\u001a\n\u0012\u0006\b\u0001\u0012\u00020d0cH\u0007J\u0011\u0010\u007f\u001a\u00020d2\u0007\u0010\u0080\u0001\u001a\u00020\u0004H\u0007J#\u0010\u0081\u0001\u001a\u00020|2\u0007\u0010F\u001a\u00030\u0082\u00012\u0006\u0010\u001e\u001a\u00020\u00042\u0007\u0010\u0083\u0001\u001a\u00020/H\u0007J\t\u0010\u0084\u0001\u001a\u00020\u0004H\u0016R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\u0007R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0012\u0010\u0002\u001a\u0004\b\u0013\u0010\fR,\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00158\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0017\u0010\u0002\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R*\u0010\u001e\u001a\u0004\u0018\u00010\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u00048F@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001f\u0010\u0002\u001a\u0004\b \u0010\u0007R\u000e\u0010!\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R$\u0010#\u001a\u00020$8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b%\u0010\u0002\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R,\u0010*\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00158\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b+\u0010\u0002\u001a\u0004\b,\u0010\u0019\"\u0004\b-\u0010\u001bR$\u0010.\u001a\u00020/8F@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b0\u0010\u0002\u001a\u0004\b.\u00101\"\u0004\b2\u00103R*\u00104\u001a\u0004\u0018\u00010\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u00048F@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b5\u0010\u0002\u001a\u0004\b6\u0010\u0007R\u000e\u00107\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R0\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020;098\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b<\u0010\u0002\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@RT\u0010A\u001a2\u0012\u0013\u0012\u00110C\u00a2\u0006\f\bD\u0012\b\bE\u0012\u0004\b\b(F\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\bD\u0012\b\bE\u0012\u0004\b\b(G\u0012\u0004\u0012\u00020H0B8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bI\u0010\u0002\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR0\u0010N\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020O098\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bP\u0010\u0002\u001a\u0004\bQ\u0010>\"\u0004\bR\u0010@R$\u0010S\u001a\u00020T8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bU\u0010\u0002\u001a\u0004\bV\u0010W\"\u0004\bX\u0010YR$\u0010Z\u001a\u00020[8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\\\u0010\u0002\u001a\u0004\b]\u0010^\"\u0004\b_\u0010`R/\u0010a\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020d0c0b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bg\u0010h\u001a\u0004\be\u0010fR$\u0010i\u001a\u00020j8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bk\u0010\u0002\u001a\u0004\bl\u0010m\"\u0004\bn\u0010oR\u001a\u0010p\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bq\u0010\u0002\u001a\u0004\br\u0010\u0007R\u000e\u0010s\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R$\u0010t\u001a\u00020u8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bv\u0010\u0002\u001a\u0004\bw\u0010x\"\u0004\by\u0010z\u00a8\u0006\u0085\u0001"}, d2={"Lnet/gotev/uploadservice/UploadServiceConfig;", "", "()V", "broadcastNotificationAction", "", "getBroadcastNotificationAction$annotations", "getBroadcastNotificationAction", "()Ljava/lang/String;", "broadcastNotificationActionIntentFilter", "Landroid/content/IntentFilter;", "getBroadcastNotificationActionIntentFilter$annotations", "getBroadcastNotificationActionIntentFilter", "()Landroid/content/IntentFilter;", "broadcastStatusAction", "getBroadcastStatusAction$annotations", "getBroadcastStatusAction", "broadcastStatusActionSuffix", "broadcastStatusIntentFilter", "getBroadcastStatusIntentFilter$annotations", "getBroadcastStatusIntentFilter", "value", "", "bufferSizeBytes", "getBufferSizeBytes$annotations", "getBufferSizeBytes", "()I", "setBufferSizeBytes", "(I)V", "contentScheme", "<set-?>", "defaultNotificationChannel", "getDefaultNotificationChannel$annotations", "getDefaultNotificationChannel", "defaultUserAgent", "fileScheme", "httpStack", "Lnet/gotev/uploadservice/network/HttpStack;", "getHttpStack$annotations", "getHttpStack", "()Lnet/gotev/uploadservice/network/HttpStack;", "setHttpStack", "(Lnet/gotev/uploadservice/network/HttpStack;)V", "idleTimeoutSeconds", "getIdleTimeoutSeconds$annotations", "getIdleTimeoutSeconds", "setIdleTimeoutSeconds", "isForegroundService", "", "isForegroundService$annotations", "()Z", "setForegroundService", "(Z)V", "namespace", "getNamespace$annotations", "getNamespace", "notificationActionSuffix", "notificationActionsObserverFactory", "Lkotlin/Function1;", "Lnet/gotev/uploadservice/UploadService;", "Lnet/gotev/uploadservice/observer/request/NotificationActionsObserver;", "getNotificationActionsObserverFactory$annotations", "getNotificationActionsObserverFactory", "()Lkotlin/jvm/functions/Function1;", "setNotificationActionsObserverFactory", "(Lkotlin/jvm/functions/Function1;)V", "notificationConfigFactory", "Lkotlin/Function2;", "Landroid/content/Context;", "Lkotlin/ParameterName;", "name", "context", "uploadId", "Lnet/gotev/uploadservice/data/UploadNotificationConfig;", "getNotificationConfigFactory$annotations", "getNotificationConfigFactory", "()Lkotlin/jvm/functions/Function2;", "setNotificationConfigFactory", "(Lkotlin/jvm/functions/Function2;)V", "notificationHandlerFactory", "Lnet/gotev/uploadservice/observer/task/UploadTaskObserver;", "getNotificationHandlerFactory$annotations", "getNotificationHandlerFactory", "setNotificationHandlerFactory", "placeholdersProcessor", "Lnet/gotev/uploadservice/placeholders/PlaceholdersProcessor;", "getPlaceholdersProcessor$annotations", "getPlaceholdersProcessor", "()Lnet/gotev/uploadservice/placeholders/PlaceholdersProcessor;", "setPlaceholdersProcessor", "(Lnet/gotev/uploadservice/placeholders/PlaceholdersProcessor;)V", "retryPolicy", "Lnet/gotev/uploadservice/data/RetryPolicyConfig;", "getRetryPolicy$annotations", "getRetryPolicy", "()Lnet/gotev/uploadservice/data/RetryPolicyConfig;", "setRetryPolicy", "(Lnet/gotev/uploadservice/data/RetryPolicyConfig;)V", "schemeHandlers", "Ljava/util/LinkedHashMap;", "Ljava/lang/Class;", "Lnet/gotev/uploadservice/schemehandlers/SchemeHandler;", "getSchemeHandlers", "()Ljava/util/LinkedHashMap;", "schemeHandlers$delegate", "Lkotlin/Lazy;", "threadPool", "Ljava/util/concurrent/AbstractExecutorService;", "getThreadPool$annotations", "getThreadPool", "()Ljava/util/concurrent/AbstractExecutorService;", "setThreadPool", "(Ljava/util/concurrent/AbstractExecutorService;)V", "uploadAction", "getUploadAction$annotations", "getUploadAction", "uploadActionSuffix", "uploadProgressNotificationIntervalMillis", "", "getUploadProgressNotificationIntervalMillis$annotations", "getUploadProgressNotificationIntervalMillis", "()J", "setUploadProgressNotificationIntervalMillis", "(J)V", "addSchemeHandler", "", "scheme", "handler", "getSchemeHandler", "path", "initialize", "Landroid/app/Application;", "debug", "toString", "uploadservice_release"})
@SourceDebugExtension(value={"SMAP\nUploadServiceConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UploadServiceConfig.kt\nnet/gotev/uploadservice/UploadServiceConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,311:1\n1#2:312\n*E\n"})
public final class UploadServiceConfig {
    @NotNull
    public static final UploadServiceConfig INSTANCE = new UploadServiceConfig();
    @NotNull
    private static final String uploadActionSuffix = ".uploadservice.action.upload";
    @NotNull
    private static final String broadcastStatusActionSuffix = ".uploadservice.broadcast.status";
    @NotNull
    private static final String notificationActionSuffix = ".uploadservice.broadcast.notification.action";
    @NotNull
    private static final String fileScheme = "/";
    @NotNull
    private static final String contentScheme = "content://";
    @NotNull
    public static final String defaultUserAgent = "AndroidUploadService/4.9.2";
    @NotNull
    private static final Lazy schemeHandlers$delegate = LazyKt.lazy((Function0)schemeHandlers.2.INSTANCE);
    @Nullable
    private static String namespace;
    @Nullable
    private static String defaultNotificationChannel;
    @NotNull
    private static AbstractExecutorService threadPool;
    @NotNull
    private static Function1<? super UploadService, ? extends NotificationActionsObserver> notificationActionsObserverFactory;
    @NotNull
    private static Function1<? super UploadService, ? extends UploadTaskObserver> notificationHandlerFactory;
    @NotNull
    private static Function2<? super Context, ? super String, UploadNotificationConfig> notificationConfigFactory;
    private static int idleTimeoutSeconds;
    private static int bufferSizeBytes;
    @NotNull
    private static HttpStack httpStack;
    private static long uploadProgressNotificationIntervalMillis;
    @NotNull
    private static RetryPolicyConfig retryPolicy;
    private static boolean isForegroundService;
    @NotNull
    private static PlaceholdersProcessor placeholdersProcessor;

    private UploadServiceConfig() {
    }

    private final LinkedHashMap<String, Class<? extends SchemeHandler>> getSchemeHandlers() {
        Lazy lazy = schemeHandlers$delegate;
        return (LinkedHashMap)lazy.getValue();
    }

    @JvmStatic
    public static final void initialize(@NotNull Application context, @NotNull String defaultNotificationChannel, boolean debug) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)defaultNotificationChannel, (String)"defaultNotificationChannel");
        namespace = context.getPackageName();
        UploadServiceConfig.defaultNotificationChannel = defaultNotificationChannel;
        UploadServiceLogger.setDevelopmentMode(debug);
    }

    @Nullable
    public static final String getNamespace() {
        if (namespace == null) {
            throw new IllegalArgumentException("You have to set namespace to your app package name (context.packageName) in your Application subclass");
        }
        return namespace;
    }

    @JvmStatic
    public static /* synthetic */ void getNamespace$annotations() {
    }

    @Nullable
    public static final String getDefaultNotificationChannel() {
        if (defaultNotificationChannel == null) {
            throw new IllegalArgumentException("You have to set defaultNotificationChannel in your Application subclass");
        }
        return defaultNotificationChannel;
    }

    @JvmStatic
    public static /* synthetic */ void getDefaultNotificationChannel$annotations() {
    }

    @NotNull
    public static final AbstractExecutorService getThreadPool() {
        return threadPool;
    }

    public static final void setThreadPool(@NotNull AbstractExecutorService abstractExecutorService) {
        Intrinsics.checkNotNullParameter((Object)abstractExecutorService, (String)"<set-?>");
        threadPool = abstractExecutorService;
    }

    @JvmStatic
    public static /* synthetic */ void getThreadPool$annotations() {
    }

    @NotNull
    public static final Function1<UploadService, NotificationActionsObserver> getNotificationActionsObserverFactory() {
        return notificationActionsObserverFactory;
    }

    public static final void setNotificationActionsObserverFactory(@NotNull Function1<? super UploadService, ? extends NotificationActionsObserver> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        notificationActionsObserverFactory = function1;
    }

    @JvmStatic
    public static /* synthetic */ void getNotificationActionsObserverFactory$annotations() {
    }

    @NotNull
    public static final Function1<UploadService, UploadTaskObserver> getNotificationHandlerFactory() {
        return notificationHandlerFactory;
    }

    public static final void setNotificationHandlerFactory(@NotNull Function1<? super UploadService, ? extends UploadTaskObserver> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        notificationHandlerFactory = function1;
    }

    @JvmStatic
    public static /* synthetic */ void getNotificationHandlerFactory$annotations() {
    }

    @NotNull
    public static final Function2<Context, String, UploadNotificationConfig> getNotificationConfigFactory() {
        return notificationConfigFactory;
    }

    public static final void setNotificationConfigFactory(@NotNull Function2<? super Context, ? super String, UploadNotificationConfig> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        notificationConfigFactory = function2;
    }

    @JvmStatic
    public static /* synthetic */ void getNotificationConfigFactory$annotations() {
    }

    public static final int getIdleTimeoutSeconds() {
        return idleTimeoutSeconds;
    }

    public static final void setIdleTimeoutSeconds(int value) {
        if (!(value >= 1)) {
            boolean bl = false;
            String string = "Idle timeout min allowable value is 1. It cannot be " + value;
            throw new IllegalArgumentException(string.toString());
        }
        idleTimeoutSeconds = value;
    }

    @JvmStatic
    public static /* synthetic */ void getIdleTimeoutSeconds$annotations() {
    }

    public static final int getBufferSizeBytes() {
        return bufferSizeBytes;
    }

    public static final void setBufferSizeBytes(int value) {
        if (!(value >= 256)) {
            boolean bl = false;
            String string = "You can't set buffer size lower than 256 bytes";
            throw new IllegalArgumentException(string.toString());
        }
        bufferSizeBytes = value;
    }

    @JvmStatic
    public static /* synthetic */ void getBufferSizeBytes$annotations() {
    }

    @NotNull
    public static final HttpStack getHttpStack() {
        return httpStack;
    }

    public static final void setHttpStack(@NotNull HttpStack httpStack) {
        Intrinsics.checkNotNullParameter((Object)httpStack, (String)"<set-?>");
        UploadServiceConfig.httpStack = httpStack;
    }

    @JvmStatic
    public static /* synthetic */ void getHttpStack$annotations() {
    }

    public static final long getUploadProgressNotificationIntervalMillis() {
        return uploadProgressNotificationIntervalMillis;
    }

    public static final void setUploadProgressNotificationIntervalMillis(long l) {
        uploadProgressNotificationIntervalMillis = l;
    }

    @JvmStatic
    public static /* synthetic */ void getUploadProgressNotificationIntervalMillis$annotations() {
    }

    @NotNull
    public static final RetryPolicyConfig getRetryPolicy() {
        return retryPolicy;
    }

    public static final void setRetryPolicy(@NotNull RetryPolicyConfig retryPolicyConfig) {
        Intrinsics.checkNotNullParameter((Object)retryPolicyConfig, (String)"<set-?>");
        retryPolicy = retryPolicyConfig;
    }

    @JvmStatic
    public static /* synthetic */ void getRetryPolicy$annotations() {
    }

    public static final boolean isForegroundService() {
        return Build.VERSION.SDK_INT >= 26 || isForegroundService;
    }

    public static final void setForegroundService(boolean bl) {
        isForegroundService = bl;
    }

    @JvmStatic
    public static /* synthetic */ void isForegroundService$annotations() {
    }

    @NotNull
    public static final String getUploadAction() {
        return INSTANCE.getNamespace() + uploadActionSuffix;
    }

    @JvmStatic
    public static /* synthetic */ void getUploadAction$annotations() {
    }

    @NotNull
    public static final String getBroadcastStatusAction() {
        return INSTANCE.getNamespace() + broadcastStatusActionSuffix;
    }

    @JvmStatic
    public static /* synthetic */ void getBroadcastStatusAction$annotations() {
    }

    @NotNull
    public static final String getBroadcastNotificationAction() {
        return INSTANCE.getNamespace() + notificationActionSuffix;
    }

    @JvmStatic
    public static /* synthetic */ void getBroadcastNotificationAction$annotations() {
    }

    @NotNull
    public static final IntentFilter getBroadcastStatusIntentFilter() {
        return new IntentFilter(INSTANCE.getBroadcastStatusAction());
    }

    @JvmStatic
    public static /* synthetic */ void getBroadcastStatusIntentFilter$annotations() {
    }

    @NotNull
    public static final IntentFilter getBroadcastNotificationActionIntentFilter() {
        return new IntentFilter(INSTANCE.getBroadcastNotificationAction());
    }

    @JvmStatic
    public static /* synthetic */ void getBroadcastNotificationActionIntentFilter$annotations() {
    }

    @NotNull
    public static final PlaceholdersProcessor getPlaceholdersProcessor() {
        return placeholdersProcessor;
    }

    public static final void setPlaceholdersProcessor(@NotNull PlaceholdersProcessor placeholdersProcessor) {
        Intrinsics.checkNotNullParameter((Object)placeholdersProcessor, (String)"<set-?>");
        UploadServiceConfig.placeholdersProcessor = placeholdersProcessor;
    }

    @JvmStatic
    public static /* synthetic */ void getPlaceholdersProcessor$annotations() {
    }

    @JvmStatic
    public static final void addSchemeHandler(@NotNull String scheme, @NotNull Class<? extends SchemeHandler> handler2) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        if (!(!Intrinsics.areEqual((Object)scheme, (Object)fileScheme) && !Intrinsics.areEqual((Object)scheme, (Object)contentScheme))) {
            boolean bl = false;
            String string = "Cannot override bundled scheme: " + scheme + "! If you found a bug in a bundled scheme handler, please open an issue: https://github.com/gotev/android-upload-service";
            throw new IllegalArgumentException(string.toString());
        }
        ((Map)INSTANCE.getSchemeHandlers()).put(scheme, handler2);
    }

    @JvmStatic
    @NotNull
    public static final SchemeHandler getSchemeHandler(@NotNull String path) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String trimmedPath = ((Object)StringsKt.trim((CharSequence)path)).toString();
        for (Map.Entry entry : ((Map)INSTANCE.getSchemeHandlers()).entrySet()) {
            String scheme = (String)entry.getKey();
            Class handler2 = (Class)entry.getValue();
            if (!StringsKt.startsWith((String)trimmedPath, (String)scheme, (boolean)true)) continue;
            Object t = handler2.newInstance();
            SchemeHandler $this$getSchemeHandler_u24lambda_u243 = (SchemeHandler)t;
            boolean bl = false;
            $this$getSchemeHandler_u24lambda_u243.init(trimmedPath);
            Object t2 = t;
            Intrinsics.checkNotNullExpressionValue(t2, (String)"handler.newInstance().ap\u2026edPath)\n                }");
            return (SchemeHandler)t2;
        }
        throw new UnsupportedOperationException("Unsupported scheme for " + path + ". Currently supported schemes are " + INSTANCE.getSchemeHandlers().keySet());
    }

    @NotNull
    public String toString() {
        String string = UploadServiceConfig.getNamespace();
        int n = Runtime.getRuntime().availableProcessors();
        String string2 = httpStack.getClass().getName();
        boolean bl = UploadServiceConfig.isForegroundService();
        Set<Map.Entry<String, Class<? extends SchemeHandler>>> set = this.getSchemeHandlers().entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"schemeHandlers.entries");
        return StringsKt.trimIndent((String)("\n            {\n                \"uploadServiceVersion\": \"4.9.2\",\n                \"androidApiVersion\": " + Build.VERSION.SDK_INT + ",\n                \"namespace\": \"" + string + "\",\n                \"deviceProcessors\": " + n + ",\n                \"idleTimeoutSeconds\": " + idleTimeoutSeconds + ",\n                \"bufferSizeBytes\": " + bufferSizeBytes + ",\n                \"httpStack\": \"" + string2 + "\",\n                \"uploadProgressNotificationIntervalMillis\": " + uploadProgressNotificationIntervalMillis + ",\n                \"retryPolicy\": " + retryPolicy + ",\n                \"isForegroundService\": " + bl + ",\n                \"schemeHandlers\": {" + CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)31, null) + "}\n            }\n        "));
    }

    static {
        threadPool = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 5L, TimeUnit.SECONDS, new LinkedBlockingQueue());
        notificationActionsObserverFactory = notificationActionsObserverFactory.1.INSTANCE;
        notificationHandlerFactory = notificationHandlerFactory.1.INSTANCE;
        notificationConfigFactory = notificationConfigFactory.1.INSTANCE;
        idleTimeoutSeconds = 10;
        bufferSizeBytes = 4096;
        httpStack = new HurlStack(null, false, false, 0, 0, 31, null);
        uploadProgressNotificationIntervalMillis = 333L;
        retryPolicy = new RetryPolicyConfig(1, 100, 2, 3);
        isForegroundService = true;
        placeholdersProcessor = new DefaultPlaceholdersProcessor();
    }
}

