/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice;

import android.content.Context;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.gotev.uploadservice.UploadServiceConfig;
import net.gotev.uploadservice.UploadTask;
import net.gotev.uploadservice.data.UploadFile;
import net.gotev.uploadservice.data.UploadInfo;
import net.gotev.uploadservice.data.UploadNotificationConfig;
import net.gotev.uploadservice.data.UploadTaskParameters;
import net.gotev.uploadservice.exceptions.UploadError;
import net.gotev.uploadservice.exceptions.UserCancelledUploadException;
import net.gotev.uploadservice.logger.UploadServiceLogger;
import net.gotev.uploadservice.network.HttpStack;
import net.gotev.uploadservice.network.ServerResponse;
import net.gotev.uploadservice.observer.task.UploadTaskObserver;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 Z2\u00020\u0001:\u0001ZB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u00108\u001a\u000209J\"\u0010:\u001a\u0002092\u0017\u0010;\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u0002090<\u00a2\u0006\u0002\b=H\u0082\bJ?\u0010>\u001a\u0002092\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010?\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00042\u0012\u0010@\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0A\"\u00020\u001b\u00a2\u0006\u0002\u0010BJ\u0010\u0010C\u001a\u0002092\u0006\u0010D\u001a\u00020EH\u0002J\u0010\u0010F\u001a\u0002092\u0006\u0010G\u001a\u00020\fH\u0004J\u0010\u0010H\u001a\u0002092\u0006\u0010I\u001a\u00020JH\u0004J\b\u0010K\u001a\u000209H\u0002J\b\u0010L\u001a\u000209H\u0016J\b\u0010M\u001a\u000209H\u0002J\b\u0010N\u001a\u000209H\u0004J\b\u0010O\u001a\u000209H\u0016J\u0012\u0010P\u001a\u0002092\b\b\u0002\u0010Q\u001a\u00020#H\u0004J\u0018\u0010R\u001a\u00020#2\u0006\u00107\u001a\u00020\f2\u0006\u0010.\u001a\u00020\fH\u0002J!\u0010S\u001a\u0002092\b\b\u0002\u0010T\u001a\u00020\f2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020#0VH\u0082\bJ\u0010\u0010W\u001a\u0002092\u0006\u0010X\u001a\u00020YH$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0014\u00103\u001a\u0002048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u000e\u00107\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lnet/gotev/uploadservice/UploadTask;", "Ljava/lang/Runnable;", "()V", "attempts", "", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "setContext", "(Landroid/content/Context;)V", "errorDelay", "", "lastProgressNotificationTime", "notificationConfig", "Lnet/gotev/uploadservice/data/UploadNotificationConfig;", "getNotificationConfig", "()Lnet/gotev/uploadservice/data/UploadNotificationConfig;", "setNotificationConfig", "(Lnet/gotev/uploadservice/data/UploadNotificationConfig;)V", "notificationId", "getNotificationId", "()I", "setNotificationId", "(I)V", "observers", "Ljava/util/ArrayList;", "Lnet/gotev/uploadservice/observer/task/UploadTaskObserver;", "params", "Lnet/gotev/uploadservice/data/UploadTaskParameters;", "getParams", "()Lnet/gotev/uploadservice/data/UploadTaskParameters;", "setParams", "(Lnet/gotev/uploadservice/data/UploadTaskParameters;)V", "shouldContinue", "", "getShouldContinue", "()Z", "setShouldContinue", "(Z)V", "startTime", "successfullyUploadedFiles", "", "Lnet/gotev/uploadservice/data/UploadFile;", "getSuccessfullyUploadedFiles", "()Ljava/util/List;", "totalBytes", "getTotalBytes", "()J", "setTotalBytes", "(J)V", "uploadInfo", "Lnet/gotev/uploadservice/data/UploadInfo;", "getUploadInfo", "()Lnet/gotev/uploadservice/data/UploadInfo;", "uploadedBytes", "cancel", "", "doForEachObserver", "action", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "init", "taskParams", "taskObservers", "", "(Landroid/content/Context;Lnet/gotev/uploadservice/data/UploadTaskParameters;Lnet/gotev/uploadservice/data/UploadNotificationConfig;I[Lnet/gotev/uploadservice/observer/task/UploadTaskObserver;)V", "onError", "exception", "", "onProgress", "bytesSent", "onResponseReceived", "response", "Lnet/gotev/uploadservice/network/ServerResponse;", "onUserCancelledUpload", "performInitialization", "resetAttempts", "resetUploadedBytes", "run", "setAllFilesHaveBeenSuccessfullyUploaded", "value", "shouldThrottle", "sleepWhile", "millis", "condition", "Lkotlin/Function0;", "upload", "httpStack", "Lnet/gotev/uploadservice/network/HttpStack;", "Companion", "uploadservice_release"})
@SourceDebugExtension(value={"SMAP\nUploadTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UploadTask.kt\nnet/gotev/uploadservice/UploadTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,308:1\n88#1:313\n89#1,8:315\n97#1:324\n175#1,8:325\n88#1:333\n89#1,8:335\n97#1:344\n88#1:345\n89#1,8:347\n97#1:356\n88#1:357\n89#1,8:359\n97#1:368\n88#1:369\n89#1,8:371\n97#1:380\n88#1:381\n89#1,8:383\n97#1:392\n88#1:393\n89#1,8:395\n97#1:404\n1855#2,2:309\n1855#2:314\n1856#2:323\n1855#2:334\n1856#2:343\n1855#2:346\n1856#2:355\n1855#2:358\n1856#2:367\n1855#2:370\n1856#2:379\n1855#2:382\n1856#2:391\n1855#2:394\n1856#2:403\n1855#2,2:405\n766#2:407\n857#2,2:408\n13579#3,2:311\n*S KotlinDebug\n*F\n+ 1 UploadTask.kt\nnet/gotev/uploadservice/UploadTask\n*L\n132#1:313\n132#1:315,8\n132#1:324\n157#1:325,8\n198#1:333\n198#1:335,8\n198#1:344\n223#1:345\n223#1:347,8\n223#1:356\n232#1:357\n232#1:359,8\n232#1:368\n242#1:369\n242#1:371,8\n242#1:380\n269#1:381\n269#1:383,8\n269#1:392\n270#1:393\n270#1:395,8\n270#1:404\n88#1:309,2\n132#1:314\n132#1:323\n198#1:334\n198#1:343\n223#1:346\n223#1:355\n232#1:358\n232#1:367\n242#1:370\n242#1:379\n269#1:382\n269#1:391\n270#1:394\n270#1:403\n279#1:405,2\n291#1:407\n291#1:408,2\n120#1:311,2\n*E\n"})
public abstract class UploadTask
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long lastProgressNotificationTime;
    protected Context context;
    public UploadTaskParameters params;
    public UploadNotificationConfig notificationConfig;
    private int notificationId;
    private boolean shouldContinue = true;
    @NotNull
    private final ArrayList<UploadTaskObserver> observers = new ArrayList(2);
    private long totalBytes;
    private long uploadedBytes;
    private final long startTime = new Date().getTime();
    private int attempts;
    private long errorDelay = UploadServiceConfig.getRetryPolicy().getInitialWaitTimeSeconds();
    private static final String TAG = UploadTask.class.getSimpleName();

    @NotNull
    protected final Context getContext() {
        Context context = this.context;
        if (context != null) {
            return context;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        return null;
    }

    protected final void setContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        this.context = context;
    }

    @NotNull
    public final UploadTaskParameters getParams() {
        UploadTaskParameters uploadTaskParameters = this.params;
        if (uploadTaskParameters != null) {
            return uploadTaskParameters;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"params");
        return null;
    }

    public final void setParams(@NotNull UploadTaskParameters uploadTaskParameters) {
        Intrinsics.checkNotNullParameter((Object)uploadTaskParameters, (String)"<set-?>");
        this.params = uploadTaskParameters;
    }

    @NotNull
    public final UploadNotificationConfig getNotificationConfig() {
        UploadNotificationConfig uploadNotificationConfig = this.notificationConfig;
        if (uploadNotificationConfig != null) {
            return uploadNotificationConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"notificationConfig");
        return null;
    }

    public final void setNotificationConfig(@NotNull UploadNotificationConfig uploadNotificationConfig) {
        Intrinsics.checkNotNullParameter((Object)uploadNotificationConfig, (String)"<set-?>");
        this.notificationConfig = uploadNotificationConfig;
    }

    public final int getNotificationId() {
        return this.notificationId;
    }

    public final void setNotificationId(int n) {
        this.notificationId = n;
    }

    public final boolean getShouldContinue() {
        return this.shouldContinue;
    }

    public final void setShouldContinue(boolean bl) {
        this.shouldContinue = bl;
    }

    public final long getTotalBytes() {
        return this.totalBytes;
    }

    public final void setTotalBytes(long l) {
        this.totalBytes = l;
    }

    private final UploadInfo getUploadInfo() {
        return new UploadInfo(this.getParams().getId(), this.startTime, this.uploadedBytes, this.totalBytes, this.attempts, this.getParams().getFiles());
    }

    protected abstract void upload(@NotNull HttpStack var1) throws Exception;

    private final void doForEachObserver(Function1<? super UploadTaskObserver, Unit> action) {
        boolean $i$f$doForEachObserver = false;
        Iterable $this$forEach$iv = this.observers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UploadTaskObserver it = (UploadTaskObserver)element$iv;
            boolean bl = false;
            try {
                action.invoke((Object)it);
            }
            catch (Throwable exc) {
                String string = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                UploadServiceLogger.error(string, this.getParams().getId(), exc, (Function0<String>)((Function0)doForEachObserver.1.1.INSTANCE));
            }
        }
    }

    public final void init(@NotNull Context context, @NotNull UploadTaskParameters taskParams, @NotNull UploadNotificationConfig notificationConfig2, int notificationId, UploadTaskObserver ... taskObservers2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)taskParams, (String)"taskParams");
        Intrinsics.checkNotNullParameter((Object)notificationConfig2, (String)"notificationConfig");
        Intrinsics.checkNotNullParameter((Object)taskObservers2, (String)"taskObservers");
        this.setContext(context);
        this.setParams(taskParams);
        this.notificationId = notificationId;
        this.setNotificationConfig(notificationConfig2);
        UploadTaskObserver[] $this$forEach$iv = taskObservers2;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            UploadTaskObserver element$iv;
            UploadTaskObserver it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.observers.add(it);
        }
        this.performInitialization();
    }

    public void performInitialization() {
    }

    private final void resetAttempts() {
        this.attempts = 0;
        this.errorDelay = UploadServiceConfig.getRetryPolicy().getInitialWaitTimeSeconds();
    }

    @Override
    public void run() {
        UploadTask this_$iv = this;
        boolean $i$f$doForEachObserver = false;
        Iterable $this$forEach$iv$iv = this_$iv.observers;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            UploadTaskObserver it$iv = (UploadTaskObserver)element$iv$iv;
            boolean bl = false;
            try {
                UploadTaskObserver $this$run_u24lambda_u242 = it$iv;
                boolean bl2 = false;
                $this$run_u24lambda_u242.onStart(this.getUploadInfo(), this.notificationId, this.getNotificationConfig());
            }
            catch (Throwable exc$iv) {
                String string = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                UploadServiceLogger.error(string, this_$iv.getParams().getId(), exc$iv, (Function0<String>)((Function0)doForEachObserver.1.1.INSTANCE));
            }
        }
        this.resetAttempts();
        while (this.attempts <= this.getParams().getMaxRetries() && this.shouldContinue) {
            try {
                this.resetUploadedBytes();
                this.upload(UploadServiceConfig.getHttpStack());
                break;
            }
            catch (Throwable exc) {
                if (!this.shouldContinue) {
                    String string = TAG;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                    UploadServiceLogger.error(string, this.getParams().getId(), exc, (Function0<String>)((Function0)run.2.INSTANCE));
                    break;
                }
                if (this.attempts >= this.getParams().getMaxRetries()) {
                    this.onError(exc);
                } else {
                    String string = TAG;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                    UploadServiceLogger.error(string, this.getParams().getId(), exc, (Function0<String>)((Function0)new Function0<String>(this){
                        final /* synthetic */ UploadTask this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "error on attempt " + (UploadTask.access$getAttempts$p(this.this$0) + 1) + ". Waiting " + UploadTask.access$getErrorDelay$p(this.this$0) + "s before next attempt.";
                        }
                    }));
                    long sleepDeadline = System.currentTimeMillis() + this.errorDelay * (long)1000;
                    long millis$iv = 1000L;
                    boolean $i$f$sleepWhile = false;
                    while (true) {
                        boolean bl = false;
                        if (!(this.shouldContinue && System.currentTimeMillis() < sleepDeadline)) break;
                        try {
                            Thread.sleep(millis$iv);
                        }
                        catch (Throwable throwable) {}
                    }
                    this.errorDelay *= (long)UploadServiceConfig.getRetryPolicy().getMultiplier();
                    if (this.errorDelay > (long)UploadServiceConfig.getRetryPolicy().getMaxWaitTimeSeconds()) {
                        this.errorDelay = UploadServiceConfig.getRetryPolicy().getMaxWaitTimeSeconds();
                    }
                }
                int n = this.attempts;
                this.attempts = n + 1;
            }
        }
        if (!this.shouldContinue) {
            this.onUserCancelledUpload();
        }
    }

    private final void sleepWhile(long millis, Function0<Boolean> condition) {
        boolean $i$f$sleepWhile = false;
        while (((Boolean)condition.invoke()).booleanValue()) {
            try {
                Thread.sleep(millis);
            }
            catch (Throwable throwable) {}
        }
    }

    static /* synthetic */ void sleepWhile$default(UploadTask $this, long millis, Function0 condition, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sleepWhile");
        }
        if ((n & 1) != 0) {
            millis = 1000L;
        }
        boolean $i$f$sleepWhile = false;
        while (((Boolean)condition.invoke()).booleanValue()) {
            try {
                Thread.sleep(millis);
            }
            catch (Throwable throwable) {}
        }
    }

    protected final void resetUploadedBytes() {
        this.uploadedBytes = 0L;
    }

    protected final void onProgress(long bytesSent) {
        this.uploadedBytes += bytesSent;
        if (this.shouldThrottle(this.uploadedBytes, this.totalBytes)) {
            return;
        }
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        UploadServiceLogger.debug(string, this.getParams().getId(), (Function0<String>)((Function0)new Function0<String>(this){
            final /* synthetic */ UploadTask this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "uploaded " + UploadTask.access$getUploadedBytes$p(this.this$0) * (long)100 / this.this$0.getTotalBytes() + "%, " + UploadTask.access$getUploadedBytes$p(this.this$0) + " of " + this.this$0.getTotalBytes() + " bytes";
            }
        }));
        UploadTask this_$iv = this;
        boolean $i$f$doForEachObserver = false;
        Iterable $this$forEach$iv$iv = this_$iv.observers;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            UploadTaskObserver it$iv = (UploadTaskObserver)element$iv$iv;
            boolean bl = false;
            try {
                UploadTaskObserver $this$onProgress_u24lambda_u244 = it$iv;
                boolean bl2 = false;
                $this$onProgress_u24lambda_u244.onProgress(this.getUploadInfo(), this.notificationId, this.getNotificationConfig());
            }
            catch (Throwable exc$iv) {
                String string2 = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
                UploadServiceLogger.error(string2, this_$iv.getParams().getId(), exc$iv, (Function0<String>)((Function0)doForEachObserver.1.1.INSTANCE));
            }
        }
    }

    protected final void onResponseReceived(@NotNull ServerResponse response) {
        boolean bl;
        UploadTaskObserver it$iv;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv$iv;
        boolean $i$f$doForEachObserver;
        UploadTask this_$iv;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        UploadServiceLogger.debug(string, this.getParams().getId(), (Function0<String>)((Function0)new Function0<String>(response){
            final /* synthetic */ ServerResponse $response;
            {
                this.$response = $response;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "upload " + (this.$response.isSuccessful() ? "completed" : "error");
            }
        }));
        if (response.isSuccessful()) {
            if (this.getParams().getAutoDeleteSuccessfullyUploadedFiles()) {
                for (UploadFile file2 : this.getSuccessfullyUploadedFiles()) {
                    if (file2.getHandler().delete(this.getContext())) {
                        String string2 = TAG;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
                        UploadServiceLogger.info(string2, this.getParams().getId(), (Function0<String>)((Function0)new Function0<String>(file2){
                            final /* synthetic */ UploadFile $file;
                            {
                                this.$file = $file;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return "successfully deleted: " + this.$file.getPath();
                            }
                        }));
                        continue;
                    }
                    String string3 = TAG;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"TAG");
                    UploadServiceLogger.error$default(string3, this.getParams().getId(), null, (Function0)new Function0<String>(file2){
                        final /* synthetic */ UploadFile $file;
                        {
                            this.$file = $file;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "error while deleting: " + this.$file.getPath();
                        }
                    }, 4, null);
                }
            }
            this_$iv = this;
            $i$f$doForEachObserver = false;
            $this$forEach$iv$iv = this_$iv.observers;
            $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                it$iv = (UploadTaskObserver)element$iv$iv;
                bl = false;
                try {
                    UploadTaskObserver $this$onResponseReceived_u24lambda_u245 = it$iv;
                    boolean bl2 = false;
                    $this$onResponseReceived_u24lambda_u245.onSuccess(this.getUploadInfo(), this.notificationId, this.getNotificationConfig(), response);
                }
                catch (Throwable exc$iv) {
                    String string4 = TAG;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"TAG");
                    UploadServiceLogger.error(string4, this_$iv.getParams().getId(), exc$iv, (Function0<String>)((Function0)doForEachObserver.1.1.INSTANCE));
                }
            }
        } else {
            this_$iv = this;
            $i$f$doForEachObserver = false;
            $this$forEach$iv$iv = this_$iv.observers;
            $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                it$iv = (UploadTaskObserver)element$iv$iv;
                bl = false;
                try {
                    UploadTaskObserver $this$onResponseReceived_u24lambda_u246 = it$iv;
                    boolean bl3 = false;
                    $this$onResponseReceived_u24lambda_u246.onError(this.getUploadInfo(), this.notificationId, this.getNotificationConfig(), new UploadError(response));
                }
                catch (Throwable exc$iv) {
                    String string5 = TAG;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"TAG");
                    UploadServiceLogger.error(string5, this_$iv.getParams().getId(), exc$iv, (Function0<String>)((Function0)doForEachObserver.1.1.INSTANCE));
                }
            }
        }
        this_$iv = this;
        $i$f$doForEachObserver = false;
        $this$forEach$iv$iv = this_$iv.observers;
        $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (UploadTaskObserver)element$iv$iv;
            bl = false;
            try {
                UploadTaskObserver $this$onResponseReceived_u24lambda_u247 = it$iv;
                boolean bl4 = false;
                $this$onResponseReceived_u24lambda_u247.onCompleted(this.getUploadInfo(), this.notificationId, this.getNotificationConfig());
            }
            catch (Throwable exc$iv) {
                String string6 = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"TAG");
                UploadServiceLogger.error(string6, this_$iv.getParams().getId(), exc$iv, (Function0<String>)((Function0)doForEachObserver.1.1.INSTANCE));
            }
        }
    }

    private final void onUserCancelledUpload() {
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        UploadServiceLogger.debug(string, this.getParams().getId(), (Function0<String>)((Function0)onUserCancelledUpload.1.INSTANCE));
        this.onError(new UserCancelledUploadException());
    }

    private final void onError(Throwable exception) {
        boolean bl;
        UploadTaskObserver it$iv;
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        UploadServiceLogger.error(string, this.getParams().getId(), exception, (Function0<String>)((Function0)onError.1.INSTANCE));
        UploadInfo it = this.getUploadInfo();
        boolean bl2 = false;
        UploadTask this_$iv = this;
        boolean $i$f$doForEachObserver = false;
        Iterable $this$forEach$iv$iv = this_$iv.observers;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (UploadTaskObserver)element$iv$iv;
            bl = false;
            try {
                UploadTaskObserver $this$onError_u24lambda_u2410_u24lambda_u248 = it$iv;
                boolean bl3 = false;
                $this$onError_u24lambda_u2410_u24lambda_u248.onError(it, this.notificationId, this.getNotificationConfig(), exception);
            }
            catch (Throwable exc$iv) {
                String string2 = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
                UploadServiceLogger.error(string2, this_$iv.getParams().getId(), exc$iv, (Function0<String>)((Function0)doForEachObserver.1.1.INSTANCE));
            }
        }
        this_$iv = this;
        $i$f$doForEachObserver = false;
        $this$forEach$iv$iv = this_$iv.observers;
        $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (UploadTaskObserver)element$iv$iv;
            bl = false;
            try {
                UploadTaskObserver $this$onError_u24lambda_u2410_u24lambda_u249 = it$iv;
                boolean bl4 = false;
                $this$onError_u24lambda_u2410_u24lambda_u249.onCompleted(it, this.notificationId, this.getNotificationConfig());
            }
            catch (Throwable exc$iv) {
                String string3 = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"TAG");
                UploadServiceLogger.error(string3, this_$iv.getParams().getId(), exc$iv, (Function0<String>)((Function0)doForEachObserver.1.1.INSTANCE));
            }
        }
    }

    protected final void setAllFilesHaveBeenSuccessfullyUploaded(boolean value) {
        Iterable $this$forEach$iv = this.getParams().getFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UploadFile it = (UploadFile)element$iv;
            boolean bl = false;
            it.setSuccessfullyUploaded(value);
        }
    }

    public static /* synthetic */ void setAllFilesHaveBeenSuccessfullyUploaded$default(UploadTask uploadTask, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setAllFilesHaveBeenSuccessfullyUploaded");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        uploadTask.setAllFilesHaveBeenSuccessfullyUploaded(bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<UploadFile> getSuccessfullyUploadedFiles() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getParams().getFiles();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            UploadFile it = (UploadFile)element$iv$iv;
            boolean bl = false;
            if (!it.getSuccessfullyUploaded()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void cancel() {
        this.shouldContinue = false;
    }

    private final boolean shouldThrottle(long uploadedBytes, long totalBytes) {
        long currentTime = System.currentTimeMillis();
        if (uploadedBytes < totalBytes && currentTime < this.lastProgressNotificationTime + UploadServiceConfig.getUploadProgressNotificationIntervalMillis()) {
            return true;
        }
        this.lastProgressNotificationTime = currentTime;
        return false;
    }

    public static final /* synthetic */ int access$getAttempts$p(UploadTask $this) {
        return $this.attempts;
    }

    public static final /* synthetic */ long access$getErrorDelay$p(UploadTask $this) {
        return $this.errorDelay;
    }

    public static final /* synthetic */ long access$getUploadedBytes$p(UploadTask $this) {
        return $this.uploadedBytes;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/gotev/uploadservice/UploadTask$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "uploadservice_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

