/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.data;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.parcelize.Parcelize;
import net.gotev.uploadservice.data.UploadElapsedTime;
import net.gotev.uploadservice.data.UploadFile;
import net.gotev.uploadservice.data.UploadRate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001BG\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0005H\u00c6\u0003J\t\u0010+\u001a\u00020\u0005H\u00c6\u0003J\t\u0010,\u001a\u00020\u0005H\u00c6\u0003J\t\u0010-\u001a\u00020\tH\u00c6\u0003J\u000f\u0010.\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003JK\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0001J\t\u00100\u001a\u00020\tH\u00d6\u0001J\u0013\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u000104H\u00d6\u0003J\t\u00105\u001a\u00020\tH\u00d6\u0001J\t\u00106\u001a\u00020\u0003H\u00d6\u0001J\u0019\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\tH\u00d6\u0001R\u0017\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\u00020\t8F\u00a2\u0006\f\u0012\u0004\b\u0019\u0010\u0011\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\u00020\t8F\u00a2\u0006\f\u0012\u0004\b\u001e\u0010\u0011\u001a\u0004\b\u001f\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0017\u0010#\u001a\u00020$8F\u00a2\u0006\f\u0012\u0004\b%\u0010\u0011\u001a\u0004\b&\u0010'R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001c\u00a8\u0006<"}, d2={"Lnet/gotev/uploadservice/data/UploadInfo;", "Landroid/os/Parcelable;", "uploadId", "", "startTime", "", "uploadedBytes", "totalBytes", "numberOfRetries", "", "files", "Ljava/util/ArrayList;", "Lnet/gotev/uploadservice/data/UploadFile;", "(Ljava/lang/String;JJJILjava/util/ArrayList;)V", "elapsedTime", "Lnet/gotev/uploadservice/data/UploadElapsedTime;", "getElapsedTime$annotations", "()V", "getElapsedTime", "()Lnet/gotev/uploadservice/data/UploadElapsedTime;", "getFiles", "()Ljava/util/ArrayList;", "getNumberOfRetries", "()I", "progressPercent", "getProgressPercent$annotations", "getProgressPercent", "getStartTime", "()J", "successfullyUploadedFiles", "getSuccessfullyUploadedFiles$annotations", "getSuccessfullyUploadedFiles", "getTotalBytes", "getUploadId", "()Ljava/lang/String;", "uploadRate", "Lnet/gotev/uploadservice/data/UploadRate;", "getUploadRate$annotations", "getUploadRate", "()Lnet/gotev/uploadservice/data/UploadRate;", "getUploadedBytes", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "describeContents", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "uploadservice_release"})
@Parcelize
@SourceDebugExtension(value={"SMAP\nUploadInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UploadInfo.kt\nnet/gotev/uploadservice/data/UploadInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1774#2,4:104\n*S KotlinDebug\n*F\n+ 1 UploadInfo.kt\nnet/gotev/uploadservice/data/UploadInfo\n*L\n101#1:104,4\n*E\n"})
public final class UploadInfo
implements Parcelable {
    @NotNull
    private final String uploadId;
    private final long startTime;
    private final long uploadedBytes;
    private final long totalBytes;
    private final int numberOfRetries;
    @NotNull
    private final ArrayList<UploadFile> files;
    @NotNull
    public static final Parcelable.Creator<UploadInfo> CREATOR;

    @JvmOverloads
    public UploadInfo(@NotNull String uploadId, long startTime, long uploadedBytes, long totalBytes, int numberOfRetries, @NotNull ArrayList<UploadFile> files) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        this.uploadId = uploadId;
        this.startTime = startTime;
        this.uploadedBytes = uploadedBytes;
        this.totalBytes = totalBytes;
        this.numberOfRetries = numberOfRetries;
        this.files = files;
    }

    public /* synthetic */ UploadInfo(String string, long l, long l2, long l3, int n, ArrayList arrayList, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            l = 0L;
        }
        if ((n2 & 4) != 0) {
            l2 = 0L;
        }
        if ((n2 & 8) != 0) {
            l3 = 0L;
        }
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        if ((n2 & 0x20) != 0) {
            arrayList = new ArrayList<UploadFile>();
        }
        this(string, l, l2, l3, n, arrayList);
    }

    @NotNull
    public final String getUploadId() {
        return this.uploadId;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final long getUploadedBytes() {
        return this.uploadedBytes;
    }

    public final long getTotalBytes() {
        return this.totalBytes;
    }

    public final int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    @NotNull
    public final ArrayList<UploadFile> getFiles() {
        return this.files;
    }

    @NotNull
    public final UploadElapsedTime getElapsedTime() {
        int seconds = (int)((new Date().getTime() - this.startTime) / (long)1000);
        int minutes = seconds / 60;
        return new UploadElapsedTime(minutes, seconds -= 60 * minutes);
    }

    public static /* synthetic */ void getElapsedTime$annotations() {
    }

    @NotNull
    public final UploadRate getUploadRate() {
        int elapsedSeconds = this.getElapsedTime().getTotalSeconds();
        double kilobitPerSecond = elapsedSeconds < 1 ? 0.0 : (double)this.uploadedBytes / (double)1000 * (double)8 / (double)elapsedSeconds;
        return kilobitPerSecond < 1.0 ? new UploadRate((int)(kilobitPerSecond * (double)1000), UploadRate.UploadRateUnit.BitPerSecond) : (kilobitPerSecond >= 1000.0 ? new UploadRate((int)(kilobitPerSecond / (double)1000), UploadRate.UploadRateUnit.MegabitPerSecond) : new UploadRate((int)kilobitPerSecond, UploadRate.UploadRateUnit.KilobitPerSecond));
    }

    public static /* synthetic */ void getUploadRate$annotations() {
    }

    public final int getProgressPercent() {
        return this.totalBytes == 0L ? 0 : (int)(this.uploadedBytes * (long)100 / this.totalBytes);
    }

    public static /* synthetic */ void getProgressPercent$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    public final int getSuccessfullyUploadedFiles() {
        int n;
        Iterable $this$count$iv = this.files;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                UploadFile it = (UploadFile)element$iv;
                boolean bl = false;
                if (!it.getSuccessfullyUploaded() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    public static /* synthetic */ void getSuccessfullyUploadedFiles$annotations() {
    }

    @NotNull
    public final String component1() {
        return this.uploadId;
    }

    public final long component2() {
        return this.startTime;
    }

    public final long component3() {
        return this.uploadedBytes;
    }

    public final long component4() {
        return this.totalBytes;
    }

    public final int component5() {
        return this.numberOfRetries;
    }

    @NotNull
    public final ArrayList<UploadFile> component6() {
        return this.files;
    }

    @NotNull
    public final UploadInfo copy(@NotNull String uploadId, long startTime, long uploadedBytes, long totalBytes, int numberOfRetries, @NotNull ArrayList<UploadFile> files) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        return new UploadInfo(uploadId, startTime, uploadedBytes, totalBytes, numberOfRetries, files);
    }

    public static /* synthetic */ UploadInfo copy$default(UploadInfo uploadInfo, String string, long l, long l2, long l3, int n, ArrayList arrayList, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = uploadInfo.uploadId;
        }
        if ((n2 & 2) != 0) {
            l = uploadInfo.startTime;
        }
        if ((n2 & 4) != 0) {
            l2 = uploadInfo.uploadedBytes;
        }
        if ((n2 & 8) != 0) {
            l3 = uploadInfo.totalBytes;
        }
        if ((n2 & 0x10) != 0) {
            n = uploadInfo.numberOfRetries;
        }
        if ((n2 & 0x20) != 0) {
            arrayList = uploadInfo.files;
        }
        return uploadInfo.copy(string, l, l2, l3, n, arrayList);
    }

    @NotNull
    public String toString() {
        return "UploadInfo(uploadId=" + this.uploadId + ", startTime=" + this.startTime + ", uploadedBytes=" + this.uploadedBytes + ", totalBytes=" + this.totalBytes + ", numberOfRetries=" + this.numberOfRetries + ", files=" + this.files + ")";
    }

    public int hashCode() {
        int result = this.uploadId.hashCode();
        result = result * 31 + Long.hashCode(this.startTime);
        result = result * 31 + Long.hashCode(this.uploadedBytes);
        result = result * 31 + Long.hashCode(this.totalBytes);
        result = result * 31 + Integer.hashCode(this.numberOfRetries);
        result = result * 31 + this.files.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UploadInfo)) {
            return false;
        }
        UploadInfo uploadInfo = (UploadInfo)other;
        if (!Intrinsics.areEqual((Object)this.uploadId, (Object)uploadInfo.uploadId)) {
            return false;
        }
        if (this.startTime != uploadInfo.startTime) {
            return false;
        }
        if (this.uploadedBytes != uploadInfo.uploadedBytes) {
            return false;
        }
        if (this.totalBytes != uploadInfo.totalBytes) {
            return false;
        }
        if (this.numberOfRetries != uploadInfo.numberOfRetries) {
            return false;
        }
        return Intrinsics.areEqual(this.files, uploadInfo.files);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.uploadId);
        out.writeLong(this.startTime);
        out.writeLong(this.uploadedBytes);
        out.writeLong(this.totalBytes);
        out.writeInt(this.numberOfRetries);
        ArrayList<UploadFile> arrayList = this.files;
        out.writeInt(arrayList.size());
        Iterator<UploadFile> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            iterator.next().writeToParcel(out, flags);
        }
    }

    @JvmOverloads
    public UploadInfo(@NotNull String uploadId, long startTime, long uploadedBytes, long totalBytes, int numberOfRetries) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        this(uploadId, startTime, uploadedBytes, totalBytes, numberOfRetries, null, 32, null);
    }

    @JvmOverloads
    public UploadInfo(@NotNull String uploadId, long startTime, long uploadedBytes, long totalBytes) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        this(uploadId, startTime, uploadedBytes, totalBytes, 0, null, 48, null);
    }

    @JvmOverloads
    public UploadInfo(@NotNull String uploadId, long startTime, long uploadedBytes) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        this(uploadId, startTime, uploadedBytes, 0L, 0, null, 56, null);
    }

    @JvmOverloads
    public UploadInfo(@NotNull String uploadId, long startTime) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        this(uploadId, startTime, 0L, 0L, 0, null, 60, null);
    }

    @JvmOverloads
    public UploadInfo(@NotNull String uploadId) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        this(uploadId, 0L, 0L, 0L, 0, null, 62, null);
    }

    static {
        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<UploadInfo> {
            @NotNull
            public final UploadInfo[] newArray(int size2) {
                return new UploadInfo[size2];
            }

            @NotNull
            public final UploadInfo createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                int n = parcel.readInt();
                ArrayList<UploadFile> arrayList = new ArrayList<UploadFile>(n);
                int n2 = parcel.readInt();
                long l = parcel.readLong();
                long l2 = parcel.readLong();
                long l3 = parcel.readLong();
                String string = parcel.readString();
                for (int i = 0; i != n; ++i) {
                    arrayList.add((UploadFile)UploadFile.CREATOR.createFromParcel(parcel));
                }
                ArrayList<UploadFile> arrayList2 = arrayList;
                int n3 = n2;
                long l4 = l;
                long l5 = l2;
                long l6 = l3;
                String string2 = string;
                return new UploadInfo(string2, l6, l5, l4, n3, arrayList2);
            }
        }
        CREATOR = new Creator();
    }
}

