/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.extensions;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Parcelable;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.gotev.uploadservice.UploadService;
import net.gotev.uploadservice.UploadServiceConfig;
import net.gotev.uploadservice.UploadTask;
import net.gotev.uploadservice.data.UploadNotificationConfig;
import net.gotev.uploadservice.data.UploadTaskParameters;
import net.gotev.uploadservice.extensions.ContextExtensionsKt;
import net.gotev.uploadservice.extensions.UploadTaskCreationParameters;
import net.gotev.uploadservice.logger.UploadServiceLogger;
import net.gotev.uploadservice.observer.task.UploadTaskObserver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0001\u001a\u001a\u0010\u0011\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001\u001a5\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019\"\u00020\u001a\u00a2\u0006\u0002\u0010\u001b\u001a\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u0016*\u0004\u0018\u00010\u0007\u001a(\u0010\u001d\u001a\u0004\u0018\u0001H\u001e\"\n\b\u0000\u0010\u001e\u0018\u0001*\u00020\u001f*\u00020\u00072\u0006\u0010 \u001a\u00020\u0001H\u0086\b\u00a2\u0006\u0002\u0010!\u001a\u001c\u0010\"\u001a\u00020#*\u00020\u000f2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0007\u001a\u001a\u0010(\u001a\u00020\u0001*\u00020\u000f2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006-"}, d2={"actionKey", "", "cancelUploadAction", "taskNotificationConfig", "taskParametersKey", "uploadIdKey", "uploadIdToCancel", "Landroid/content/Intent;", "getUploadIdToCancel", "(Landroid/content/Intent;)Ljava/lang/String;", "flagsCompat", "", "flags", "getCancelUploadIntent", "Landroid/app/PendingIntent;", "Landroid/content/Context;", "uploadId", "getNotificationActionIntent", "action", "getUploadTask", "Lnet/gotev/uploadservice/UploadTask;", "creationParameters", "Lnet/gotev/uploadservice/extensions/UploadTaskCreationParameters;", "notificationId", "observers", "", "Lnet/gotev/uploadservice/observer/task/UploadTaskObserver;", "(Landroid/content/Context;Lnet/gotev/uploadservice/extensions/UploadTaskCreationParameters;I[Lnet/gotev/uploadservice/observer/task/UploadTaskObserver;)Lnet/gotev/uploadservice/UploadTask;", "getUploadTaskCreationParameters", "parcelableCompat", "T", "Landroid/os/Parcelable;", "key", "(Landroid/content/Intent;Ljava/lang/String;)Landroid/os/Parcelable;", "registerReceiverCompat", "", "receiver", "Landroid/content/BroadcastReceiver;", "filter", "Landroid/content/IntentFilter;", "startNewUpload", "params", "Lnet/gotev/uploadservice/data/UploadTaskParameters;", "notificationConfig", "Lnet/gotev/uploadservice/data/UploadNotificationConfig;", "uploadservice_release"})
@SourceDebugExtension(value={"SMAP\nContextExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextExtensions.kt\nnet/gotev/uploadservice/extensions/ContextExtensionsKt\n*L\n1#1,247:1\n234#1,4:248\n234#1,4:252\n*S KotlinDebug\n*F\n+ 1 ContextExtensions.kt\nnet/gotev/uploadservice/extensions/ContextExtensionsKt\n*L\n99#1:248,4\n136#1:252,4\n*E\n"})
public final class ContextExtensionsKt {
    @NotNull
    private static final String taskParametersKey = "taskParameters";
    @NotNull
    private static final String taskNotificationConfig = "taskUploadConfig";
    @NotNull
    private static final String actionKey = "action";
    @NotNull
    private static final String uploadIdKey = "uploadId";
    @NotNull
    private static final String cancelUploadAction = "cancelUpload";

    @NotNull
    public static final String startNewUpload(@NotNull Context $this$startNewUpload, @NotNull UploadTaskParameters params2, @NotNull UploadNotificationConfig notificationConfig2) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)$this$startNewUpload, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        Intrinsics.checkNotNullParameter((Object)notificationConfig2, (String)"notificationConfig");
        Intent $this$startNewUpload_u24lambda_u240 = intent = new Intent($this$startNewUpload, UploadService.class);
        boolean bl = false;
        $this$startNewUpload_u24lambda_u240.setAction(UploadServiceConfig.getUploadAction());
        $this$startNewUpload_u24lambda_u240.putExtra(taskParametersKey, (Parcelable)params2);
        $this$startNewUpload_u24lambda_u240.putExtra(taskNotificationConfig, (Parcelable)notificationConfig2);
        Intent intent2 = intent;
        try {
            $this$startNewUpload.startService(intent2);
        }
        catch (Throwable exc) {
            if (Build.VERSION.SDK_INT >= 26 && exc instanceof IllegalStateException) {
                $this$startNewUpload.startForegroundService(intent2);
            }
            UploadServiceLogger.error("UploadService", params2.getId(), exc, (Function0<String>)((Function0)startNewUpload.1.INSTANCE));
        }
        return params2.getId();
    }

    @Nullable
    public static final UploadTaskCreationParameters getUploadTaskCreationParameters(@Nullable Intent $this$getUploadTaskCreationParameters) {
        Parcelable parcelable;
        Class<?> clazz;
        Parcelable parcelable2;
        if ($this$getUploadTaskCreationParameters == null || !Intrinsics.areEqual((Object)$this$getUploadTaskCreationParameters.getAction(), (Object)UploadServiceConfig.getUploadAction())) {
            String string = UploadService.Companion.getTAG$uploadservice_release();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UploadService.TAG");
            UploadServiceLogger.error$default(string, "N/A", null, getUploadTaskCreationParameters.1.INSTANCE, 4, null);
            return null;
        }
        Intent intent = $this$getUploadTaskCreationParameters;
        String key$iv = taskParametersKey;
        boolean $i$f$parcelableCompat = false;
        if (Build.VERSION.SDK_INT >= 34) {
            parcelable2 = (Parcelable)$this$parcelableCompat$iv.getParcelableExtra(key$iv, UploadTaskParameters.class);
        } else {
            Parcelable parcelable3 = $this$parcelableCompat$iv.getParcelableExtra(key$iv);
            if (!(parcelable3 instanceof UploadTaskParameters)) {
                parcelable3 = null;
            }
            parcelable2 = (UploadTaskParameters)parcelable3;
        }
        UploadTaskParameters uploadTaskParameters = (UploadTaskParameters)parcelable2;
        if (uploadTaskParameters == null) {
            Intent $this$getUploadTaskCreationParameters_u24lambda_u241 = $this$getUploadTaskCreationParameters;
            boolean bl = false;
            String string = UploadService.Companion.getTAG$uploadservice_release();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UploadService.TAG");
            UploadServiceLogger.error$default(string, "N/A", null, getUploadTaskCreationParameters.params.1.1.INSTANCE, 4, null);
            return null;
        }
        UploadTaskParameters params2 = uploadTaskParameters;
        try {
            clazz = Class.forName(params2.getTaskClass());
        }
        catch (Throwable exc) {
            String string = UploadService.Companion.getTAG$uploadservice_release();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UploadService.TAG");
            UploadServiceLogger.error(string, "N/A", exc, (Function0<String>)((Function0)new Function0<String>(params2){
                final /* synthetic */ UploadTaskParameters $params;
                {
                    this.$params = $params;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Error while instantiating new task. " + this.$params.getTaskClass() + " does not exist.";
                }
            }));
            clazz = null;
        }
        Class<?> clazz2 = clazz;
        if (clazz2 == null) {
            return null;
        }
        Class<?> taskClass2 = clazz2;
        if (!UploadTask.class.isAssignableFrom(taskClass2)) {
            String string = UploadService.Companion.getTAG$uploadservice_release();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UploadService.TAG");
            UploadServiceLogger.error$default(string, "N/A", null, (Function0)new Function0<String>(params2){
                final /* synthetic */ UploadTaskParameters $params;
                {
                    this.$params = $params;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Error while instantiating new task. " + this.$params.getTaskClass() + " does not extend UploadTask.";
                }
            }, 4, null);
            return null;
        }
        Intent exc = $this$getUploadTaskCreationParameters;
        String key$iv2 = taskNotificationConfig;
        boolean $i$f$parcelableCompat2 = false;
        if (Build.VERSION.SDK_INT >= 34) {
            parcelable = (Parcelable)$this$parcelableCompat$iv.getParcelableExtra(key$iv2, UploadNotificationConfig.class);
        } else {
            Parcelable parcelable4 = $this$parcelableCompat$iv.getParcelableExtra(key$iv2);
            if (!(parcelable4 instanceof UploadNotificationConfig)) {
                parcelable4 = null;
            }
            parcelable = (UploadNotificationConfig)parcelable4;
        }
        UploadNotificationConfig uploadNotificationConfig = (UploadNotificationConfig)parcelable;
        if (uploadNotificationConfig == null) {
            Intent $this$getUploadTaskCreationParameters_u24lambda_u242 = $this$getUploadTaskCreationParameters;
            boolean bl = false;
            String string = UploadService.Companion.getTAG$uploadservice_release();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UploadService.TAG");
            UploadServiceLogger.error$default(string, "N/A", null, getUploadTaskCreationParameters.notificationConfig.1.1.INSTANCE, 4, null);
            return null;
        }
        UploadNotificationConfig notificationConfig2 = uploadNotificationConfig;
        return new UploadTaskCreationParameters(params2, notificationConfig2);
    }

    @Nullable
    public static final UploadTask getUploadTask(@NotNull Context $this$getUploadTask, @NotNull UploadTaskCreationParameters creationParameters, int notificationId, UploadTaskObserver ... observers) {
        UploadTask uploadTask;
        Intrinsics.checkNotNullParameter((Object)$this$getUploadTask, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)creationParameters, (String)"creationParameters");
        Intrinsics.checkNotNullParameter((Object)observers, (String)"observers");
        try {
            Class<?> clazz = Class.forName(creationParameters.getParams().getTaskClass());
            Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<out net.gotev.uploadservice.UploadTask>");
            Class<?> taskClass2 = clazz;
            Object obj = taskClass2.newInstance();
            UploadTask $this$getUploadTask_u24lambda_u243 = (UploadTask)obj;
            boolean bl = false;
            $this$getUploadTask_u24lambda_u243.init($this$getUploadTask, creationParameters.getParams(), creationParameters.getNotificationConfig(), notificationId, Arrays.copyOf(observers, observers.length));
            UploadTask uploadTask2 = (UploadTask)obj;
            String string = UploadService.Companion.getTAG$uploadservice_release();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UploadService.TAG");
            UploadServiceLogger.debug(string, "N/A", (Function0<String>)((Function0)new Function0<String>(taskClass2){
                final /* synthetic */ Class<? extends UploadTask> $taskClass;
                {
                    this.$taskClass = $taskClass;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Successfully created new task with class: " + this.$taskClass.getName();
                }
            }));
            uploadTask = uploadTask2;
        }
        catch (Throwable exc) {
            String string = UploadService.Companion.getTAG$uploadservice_release();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UploadService.TAG");
            UploadServiceLogger.error(string, "N/A", exc, (Function0<String>)((Function0)getUploadTask.2.INSTANCE));
            uploadTask = null;
        }
        return uploadTask;
    }

    @NotNull
    public static final PendingIntent getNotificationActionIntent(@NotNull Context $this$getNotificationActionIntent, @NotNull String uploadId, @NotNull String action) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)$this$getNotificationActionIntent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)uploadIdKey);
        Intrinsics.checkNotNullParameter((Object)action, (String)actionKey);
        Intent $this$getNotificationActionIntent_u24lambda_u244 = intent = new Intent(UploadServiceConfig.getBroadcastNotificationAction());
        boolean bl = false;
        $this$getNotificationActionIntent_u24lambda_u244.setPackage(UploadServiceConfig.getNamespace());
        $this$getNotificationActionIntent_u24lambda_u244.putExtra(actionKey, action);
        $this$getNotificationActionIntent_u24lambda_u244.putExtra(uploadIdKey, uploadId);
        Intent intent2 = intent;
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)$this$getNotificationActionIntent, (int)uploadId.hashCode(), (Intent)intent2, (int)ContextExtensionsKt.flagsCompat(0x40000000));
        Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"getBroadcast(\n        th\u2026tent.FLAG_ONE_SHOT)\n    )");
        return pendingIntent;
    }

    @NotNull
    public static final PendingIntent getCancelUploadIntent(@NotNull Context $this$getCancelUploadIntent, @NotNull String uploadId) {
        Intrinsics.checkNotNullParameter((Object)$this$getCancelUploadIntent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)uploadIdKey);
        return ContextExtensionsKt.getNotificationActionIntent($this$getCancelUploadIntent, uploadId, cancelUploadAction);
    }

    @Nullable
    public static final String getUploadIdToCancel(@NotNull Intent $this$uploadIdToCancel) {
        Intrinsics.checkNotNullParameter((Object)$this$uploadIdToCancel, (String)"<this>");
        if (!Intrinsics.areEqual((Object)$this$uploadIdToCancel.getStringExtra(actionKey), (Object)cancelUploadAction)) {
            return null;
        }
        return $this$uploadIdToCancel.getStringExtra(uploadIdKey);
    }

    public static final int flagsCompat(int flags) {
        if (Build.VERSION.SDK_INT > 30) {
            return flags | 0x4000000;
        }
        return flags;
    }

    public static final /* synthetic */ <T extends Parcelable> T parcelableCompat(Intent $this$parcelableCompat, String key) {
        Parcelable parcelable;
        Intrinsics.checkNotNullParameter((Object)$this$parcelableCompat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        boolean $i$f$parcelableCompat = false;
        if (Build.VERSION.SDK_INT >= 34) {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            parcelable = (Parcelable)$this$parcelableCompat.getParcelableExtra(key, Parcelable.class);
        } else {
            Parcelable parcelable2 = $this$parcelableCompat.getParcelableExtra(key);
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            parcelable = parcelable2;
        }
        return (T)parcelable;
    }

    @SuppressLint(value={"UnspecifiedRegisterReceiverFlag"})
    public static final void registerReceiverCompat(@NotNull Context $this$registerReceiverCompat, @NotNull BroadcastReceiver receiver, @NotNull IntentFilter filter) {
        Intrinsics.checkNotNullParameter((Object)$this$registerReceiverCompat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (Build.VERSION.SDK_INT >= 34) {
            $this$registerReceiverCompat.registerReceiver(receiver, filter, 4);
        } else {
            $this$registerReceiverCompat.registerReceiver(receiver, filter);
        }
    }
}

