/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.extensions;

import android.webkit.MimeTypeMap;
import java.net.URL;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0001\u001a\f\u0010\n\u001a\u00020\u000b*\u0004\u0018\u00010\u0001\u001a\n\u0010\f\u001a\u00020\u000b*\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\u0004*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\r"}, d2={"APPLICATION_OCTET_STREAM", "", "VIDEO_MP4", "asciiBytes", "", "getAsciiBytes", "(Ljava/lang/String;)[B", "utf8Bytes", "getUtf8Bytes", "autoDetectMimeType", "isASCII", "", "isValidHttpUrl", "uploadservice_release"})
public final class StringExtensionsKt {
    @NotNull
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    @NotNull
    public static final String VIDEO_MP4 = "video/mp4";

    @NotNull
    public static final String autoDetectMimeType(@NotNull String $this$autoDetectMimeType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$autoDetectMimeType, (String)"<this>");
        int index = StringsKt.lastIndexOf$default((CharSequence)$this$autoDetectMimeType, (String)".", (int)0, (boolean)false, (int)6, null);
        boolean bl = 0 <= index ? index < StringsKt.getLastIndex((CharSequence)$this$autoDetectMimeType) : false;
        if (bl) {
            String string2 = $this$autoDetectMimeType.substring(index + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String extension = string3;
            if (Intrinsics.areEqual((Object)extension, (Object)"mp4")) {
                string = VIDEO_MP4;
            } else {
                string = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
                if (string == null) {
                    string = APPLICATION_OCTET_STREAM;
                }
            }
        } else {
            string = APPLICATION_OCTET_STREAM;
        }
        return string;
    }

    public static final boolean isASCII(@Nullable String $this$isASCII) {
        CharSequence charSequence = $this$isASCII;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        int n = $this$isASCII.length();
        for (int index = 0; index < n; ++index) {
            if ($this$isASCII.charAt(index) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public static final boolean isValidHttpUrl(@NotNull String $this$isValidHttpUrl) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isValidHttpUrl, (String)"<this>");
        if (!StringsKt.startsWith$default((String)$this$isValidHttpUrl, (String)"http://", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)$this$isValidHttpUrl, (String)"https://", (boolean)false, (int)2, null)) {
            return false;
        }
        try {
            new URL($this$isValidHttpUrl);
            bl = true;
        }
        catch (Throwable exc) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final byte[] getAsciiBytes(@NotNull String $this$asciiBytes) {
        Intrinsics.checkNotNullParameter((Object)$this$asciiBytes, (String)"<this>");
        byte[] byArray = $this$asciiBytes.getBytes(Charsets.US_ASCII);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    @NotNull
    public static final byte[] getUtf8Bytes(@NotNull String $this$utf8Bytes) {
        Intrinsics.checkNotNullParameter((Object)$this$utf8Bytes, (String)"<this>");
        byte[] byArray = $this$utf8Bytes.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return byArray;
    }
}

