/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.network.hurl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.gotev.uploadservice.data.NameValue;
import net.gotev.uploadservice.logger.UploadServiceLogger;
import net.gotev.uploadservice.network.BodyWriter;
import net.gotev.uploadservice.network.HttpRequest;
import net.gotev.uploadservice.network.ServerResponse;
import net.gotev.uploadservice.network.hurl.HurlBodyWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0016\u0010\"\u001a\u00020\u00012\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0016J\u0018\u0010&\u001a\u00020\u00012\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\bH\u0016J\f\u0010*\u001a\u00020\u000f*\u00020\u0003H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R0\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0015j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lnet/gotev/uploadservice/network/hurl/HurlStackRequest;", "Lnet/gotev/uploadservice/network/HttpRequest;", "userAgent", "", "uploadId", "method", "url", "followRedirects", "", "useCaches", "connectTimeoutMillis", "", "readTimeoutMillis", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZII)V", "connection", "Ljava/net/HttpURLConnection;", "responseBody", "", "getResponseBody", "()[B", "responseHeaders", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "getResponseHeaders", "()Ljava/util/LinkedHashMap;", "uuid", "close", "", "getResponse", "Lnet/gotev/uploadservice/network/ServerResponse;", "delegate", "Lnet/gotev/uploadservice/network/HttpRequest$RequestBodyDelegate;", "listener", "Lnet/gotev/uploadservice/network/BodyWriter$OnStreamWriteListener;", "setHeaders", "requestHeaders", "", "Lnet/gotev/uploadservice/data/NameValue;", "setTotalBodyBytes", "totalBodyBytes", "", "isFixedLengthStreamingMode", "createConnection", "uploadservice_release"})
@SourceDebugExtension(value={"SMAP\nHurlStackRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HurlStackRequest.kt\nnet/gotev/uploadservice/network/hurl/HurlStackRequest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n766#2:145\n857#2,2:146\n1855#2,2:148\n*S KotlinDebug\n*F\n+ 1 HurlStackRequest.kt\nnet/gotev/uploadservice/network/hurl/HurlStackRequest\n*L\n73#1:145\n73#1:146,2\n74#1:148,2\n*E\n"})
public final class HurlStackRequest
implements HttpRequest {
    @NotNull
    private final String userAgent;
    @NotNull
    private final String uploadId;
    @NotNull
    private final HttpURLConnection connection;
    @NotNull
    private final String uuid;

    /*
     * WARNING - void declaration
     */
    public HurlStackRequest(@NotNull String userAgent, @NotNull String uploadId, @NotNull String method, @NotNull String url, boolean followRedirects, boolean useCaches, int connectTimeoutMillis, int readTimeoutMillis) {
        void $this$_init__u24lambda_u240;
        HttpURLConnection httpURLConnection;
        Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.userAgent = userAgent;
        this.uploadId = uploadId;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        this.uuid = string;
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"javaClass.simpleName");
        UploadServiceLogger.debug(string2, this.uploadId, (Function0<String>)((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                return "creating new HttpURLConnection (uuid: " + uuid + ")";
            }
        }));
        HttpURLConnection httpURLConnection2 = httpURLConnection = this.createConnection(url);
        HurlStackRequest hurlStackRequest = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.setDoInput(true);
        $this$_init__u24lambda_u240.setDoOutput(true);
        $this$_init__u24lambda_u240.setConnectTimeout(connectTimeoutMillis);
        $this$_init__u24lambda_u240.setReadTimeout(readTimeoutMillis);
        $this$_init__u24lambda_u240.setUseCaches(useCaches);
        $this$_init__u24lambda_u240.setInstanceFollowRedirects(followRedirects);
        $this$_init__u24lambda_u240.setRequestMethod(method);
        hurlStackRequest.connection = httpURLConnection;
    }

    private final HttpURLConnection createConnection(String $this$createConnection) {
        HttpURLConnection httpURLConnection;
        URL url = new URL(((Object)StringsKt.trim((CharSequence)$this$createConnection)).toString());
        if (StringsKt.equals((String)"https", (String)url.getProtocol(), (boolean)true)) {
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
            httpURLConnection = (HttpsURLConnection)uRLConnection;
        } else {
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            httpURLConnection = (HttpURLConnection)uRLConnection;
        }
        return httpURLConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] getResponseBody() throws IOException {
        byte[] byArray;
        Closeable closeable = this.connection.getResponseCode() / 100 == 2 ? this.connection.getInputStream() : this.connection.getErrorStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            byArray = ByteStreamsKt.readBytes((InputStream)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    /*
     * Unable to fully structure code
     */
    private final LinkedHashMap<String, String> getResponseHeaders() throws IOException {
        v0 = this.connection.getHeaderFields();
        if (v0 == null) {
            return new LinkedHashMap<String, String>(0);
        }
        headers = v0;
        $this$_get_responseHeaders__u24lambda_u244 = var2_2 = new LinkedHashMap<String, String>(headers.size());
        $i$a$-apply-HurlStackRequest$responseHeaders$1 = false;
        var5_5 = headers.entrySet();
        $i$f$filter = false;
        var7_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            $i$a$-filter-HurlStackRequest$responseHeaders$1$1 = false;
            if (it.getKey() == null || it.getValue() == null) ** GOTO lbl-1000
            v1 = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v1, (String)"it.value");
            if (((Collection)v1).isEmpty() == false) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            var9_10 = (Map.Entry)element$iv;
            $i$a$-forEach-HurlStackRequest$responseHeaders$1$2 = false;
            key = (String)var9_10.getKey();
            values = (List)var9_10.getValue();
            var13_16 = $this$_get_responseHeaders__u24lambda_u244;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            var14_17 = key;
            Intrinsics.checkNotNullExpressionValue((Object)values, (String)"values");
            Intrinsics.checkNotNullExpressionValue((Object)CollectionsKt.first((List)values), (String)"values.first()");
            var13_16.put(var14_17, var15_18);
        }
        return var2_2;
    }

    @Override
    @NotNull
    public HttpRequest setHeaders(@NotNull List<NameValue> requestHeaders) throws IOException {
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        this.connection.setRequestProperty("User-Agent", this.userAgent);
        for (NameValue param : requestHeaders) {
            this.connection.setRequestProperty(((Object)StringsKt.trim((CharSequence)param.getName())).toString(), ((Object)StringsKt.trim((CharSequence)param.getValue())).toString());
        }
        return this;
    }

    @Override
    @NotNull
    public HttpRequest setTotalBodyBytes(long totalBodyBytes, boolean isFixedLengthStreamingMode) {
        HttpURLConnection httpURLConnection;
        HttpURLConnection $this$setTotalBodyBytes_u24lambda_u245 = httpURLConnection = this.connection;
        boolean bl = false;
        if (isFixedLengthStreamingMode) {
            $this$setTotalBodyBytes_u24lambda_u245.setFixedLengthStreamingMode(totalBodyBytes);
        } else {
            $this$setTotalBodyBytes_u24lambda_u245.setChunkedStreamingMode(0);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ServerResponse getResponse(@NotNull HttpRequest.RequestBodyDelegate delegate, @NotNull BodyWriter.OnStreamWriteListener listener) throws IOException {
        ServerResponse serverResponse;
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Closeable closeable = this;
        Throwable throwable = null;
        try {
            HurlStackRequest it = (HurlStackRequest)closeable;
            boolean bl = false;
            OutputStream outputStream = this.connection.getOutputStream();
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"connection.outputStream");
            Closeable closeable2 = new HurlBodyWriter(outputStream, listener);
            Throwable throwable2 = null;
            try {
                HurlBodyWriter it2 = (HurlBodyWriter)closeable2;
                boolean bl2 = false;
                delegate.onWriteRequestBody(it2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            serverResponse = new ServerResponse(this.connection.getResponseCode(), this.getResponseBody(), this.getResponseHeaders());
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return serverResponse;
    }

    @Override
    public void close() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        UploadServiceLogger.debug(string, this.uploadId, (Function0<String>)((Function0)new Function0<String>(this){
            final /* synthetic */ HurlStackRequest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "closing HttpURLConnection (uuid: " + HurlStackRequest.access$getUuid$p(this.this$0) + ")";
            }
        }));
        try {
            this.connection.getInputStream().close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.connection.getOutputStream().flush();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.connection.getOutputStream().close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.connection.disconnect();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

