/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.observer.request;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.gotev.uploadservice.UploadServiceConfig;
import net.gotev.uploadservice.data.BroadcastData;
import net.gotev.uploadservice.data.UploadInfo;
import net.gotev.uploadservice.data.UploadStatus;
import net.gotev.uploadservice.extensions.ContextExtensionsKt;
import net.gotev.uploadservice.network.ServerResponse;
import net.gotev.uploadservice.observer.request.RequestObserverDelegate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B8\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012!\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR5\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lnet/gotev/uploadservice/observer/request/BaseRequestObserver;", "Landroid/content/BroadcastReceiver;", "context", "Landroid/content/Context;", "delegate", "Lnet/gotev/uploadservice/observer/request/RequestObserverDelegate;", "shouldAcceptEventsFrom", "Lkotlin/Function1;", "Lnet/gotev/uploadservice/data/UploadInfo;", "Lkotlin/ParameterName;", "name", "uploadInfo", "", "(Landroid/content/Context;Lnet/gotev/uploadservice/observer/request/RequestObserverDelegate;Lkotlin/jvm/functions/Function1;)V", "getDelegate$uploadservice_release", "()Lnet/gotev/uploadservice/observer/request/RequestObserverDelegate;", "getShouldAcceptEventsFrom$uploadservice_release", "()Lkotlin/jvm/functions/Function1;", "setShouldAcceptEventsFrom$uploadservice_release", "(Lkotlin/jvm/functions/Function1;)V", "onReceive", "", "intent", "Landroid/content/Intent;", "register", "unregister", "uploadservice_release"})
public class BaseRequestObserver
extends BroadcastReceiver {
    @NotNull
    private final Context context;
    @NotNull
    private final RequestObserverDelegate delegate;
    @NotNull
    private Function1<? super UploadInfo, Boolean> shouldAcceptEventsFrom;

    public BaseRequestObserver(@NotNull Context context, @NotNull RequestObserverDelegate delegate, @NotNull Function1<? super UploadInfo, Boolean> shouldAcceptEventsFrom) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(shouldAcceptEventsFrom, (String)"shouldAcceptEventsFrom");
        this.context = context;
        this.delegate = delegate;
        this.shouldAcceptEventsFrom = shouldAcceptEventsFrom;
    }

    @NotNull
    public final RequestObserverDelegate getDelegate$uploadservice_release() {
        return this.delegate;
    }

    @NotNull
    public final Function1<UploadInfo, Boolean> getShouldAcceptEventsFrom$uploadservice_release() {
        return this.shouldAcceptEventsFrom;
    }

    public final void setShouldAcceptEventsFrom$uploadservice_release(@NotNull Function1<? super UploadInfo, Boolean> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.shouldAcceptEventsFrom = function1;
    }

    public void onReceive(@NotNull Context context, @Nullable Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent intent2 = intent;
        if (intent2 == null) {
            return;
        }
        Intent safeIntent = intent2;
        if (!Intrinsics.areEqual((Object)safeIntent.getAction(), (Object)UploadServiceConfig.getBroadcastStatusAction())) {
            return;
        }
        BroadcastData broadcastData = BroadcastData.Companion.fromIntent(safeIntent);
        if (broadcastData == null) {
            return;
        }
        BroadcastData data = broadcastData;
        UploadInfo uploadInfo = data.getUploadInfo();
        if (!((Boolean)this.shouldAcceptEventsFrom.invoke((Object)uploadInfo)).booleanValue()) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[data.getStatus().ordinal()]) {
            case 1: {
                this.delegate.onProgress(context, uploadInfo);
                break;
            }
            case 2: {
                Throwable throwable = data.getException();
                Intrinsics.checkNotNull((Object)throwable);
                this.delegate.onError(context, uploadInfo, throwable);
                break;
            }
            case 3: {
                ServerResponse serverResponse = data.getServerResponse();
                Intrinsics.checkNotNull((Object)serverResponse);
                this.delegate.onSuccess(context, uploadInfo, serverResponse);
                break;
            }
            case 4: {
                this.delegate.onCompleted(context, uploadInfo);
            }
        }
    }

    public void register() {
        ContextExtensionsKt.registerReceiverCompat(this.context, this, UploadServiceConfig.getBroadcastStatusIntentFilter());
    }

    public void unregister() {
        this.context.unregisterReceiver((BroadcastReceiver)this);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UploadStatus.values().length];
            try {
                nArray[UploadStatus.InProgress.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UploadStatus.Error.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UploadStatus.Success.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UploadStatus.Completed.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

