/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.observer.task;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.core.app.NotificationCompat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import net.gotev.uploadservice.UploadService;
import net.gotev.uploadservice.UploadServiceConfig;
import net.gotev.uploadservice.data.UploadInfo;
import net.gotev.uploadservice.data.UploadNotificationConfig;
import net.gotev.uploadservice.data.UploadNotificationStatusConfig;
import net.gotev.uploadservice.exceptions.UserCancelledUploadException;
import net.gotev.uploadservice.extensions.NotificationManagerExtensionsKt;
import net.gotev.uploadservice.network.ServerResponse;
import net.gotev.uploadservice.observer.task.UploadTaskObserver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0002*+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\rJ.\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\"2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0$H&J \u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010(\u001a\u00020)H\u0002R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lnet/gotev/uploadservice/observer/task/AbstractSingleNotificationHandler;", "Lnet/gotev/uploadservice/observer/task/UploadTaskObserver;", "service", "Lnet/gotev/uploadservice/UploadService;", "(Lnet/gotev/uploadservice/UploadService;)V", "notificationManager", "Landroid/app/NotificationManager;", "getNotificationManager", "()Landroid/app/NotificationManager;", "notificationManager$delegate", "Lkotlin/Lazy;", "tasks", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lnet/gotev/uploadservice/observer/task/AbstractSingleNotificationHandler$TaskData;", "onCompleted", "", "info", "Lnet/gotev/uploadservice/data/UploadInfo;", "notificationId", "", "notificationConfig", "Lnet/gotev/uploadservice/data/UploadNotificationConfig;", "onError", "exception", "", "onProgress", "onStart", "onSuccess", "response", "Lnet/gotev/uploadservice/network/ServerResponse;", "removeTask", "uploadId", "updateNotification", "Landroidx/core/app/NotificationCompat$Builder;", "notificationBuilder", "", "updateTask", "status", "Lnet/gotev/uploadservice/observer/task/AbstractSingleNotificationHandler$TaskStatus;", "config", "Lnet/gotev/uploadservice/data/UploadNotificationStatusConfig;", "TaskData", "TaskStatus", "uploadservice_release"})
public abstract class AbstractSingleNotificationHandler
implements UploadTaskObserver {
    @NotNull
    private final UploadService service;
    @NotNull
    private final ConcurrentHashMap<String, TaskData> tasks;
    @NotNull
    private final Lazy notificationManager$delegate;

    public AbstractSingleNotificationHandler(@NotNull UploadService service) {
        Intrinsics.checkNotNullParameter((Object)((Object)service), (String)"service");
        this.service = service;
        this.tasks = new ConcurrentHashMap();
        this.notificationManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NotificationManager>(this){
            final /* synthetic */ AbstractSingleNotificationHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NotificationManager invoke() {
                Object object = AbstractSingleNotificationHandler.access$getService$p(this.this$0).getSystemService("notification");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
                return (NotificationManager)object;
            }
        }));
        NotificationManager notificationManager2 = this.getNotificationManager();
        String string = UploadServiceConfig.getDefaultNotificationChannel();
        Intrinsics.checkNotNull((Object)string);
        NotificationManagerExtensionsKt.validateNotificationChannel(notificationManager2, string);
    }

    private final NotificationManager getNotificationManager() {
        Lazy lazy = this.notificationManager$delegate;
        return (NotificationManager)lazy.getValue();
    }

    public final void removeTask(@NotNull String uploadId) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        this.tasks.remove(uploadId);
    }

    @Nullable
    public abstract NotificationCompat.Builder updateNotification(@NotNull NotificationManager var1, @NotNull NotificationCompat.Builder var2, @NotNull Map<String, TaskData> var3);

    private final synchronized void updateTask(TaskStatus status, UploadInfo info, UploadNotificationStatusConfig config) {
        Notification notification;
        NotificationCompat.Builder builder;
        NotificationCompat.Builder builder2;
        ((Map)this.tasks).put(info.getUploadId(), new TaskData(status, info, config));
        Context context = (Context)this.service;
        String string = UploadServiceConfig.getDefaultNotificationChannel();
        Intrinsics.checkNotNull((Object)string);
        NotificationCompat.Builder builder3 = new NotificationCompat.Builder(context, string);
        NotificationCompat.Builder builder4 = this.updateNotification(this.getNotificationManager(), builder3, new HashMap(this.tasks));
        if (builder4 == null || (builder2 = builder4.setGroup(UploadServiceConfig.getNamespace())) == null || (builder = builder2.setOngoing(true)) == null || (notification = builder.build()) == null) {
            return;
        }
        Notification notification2 = notification;
        String string2 = this.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"javaClass.name");
        this.service.holdForegroundNotification(string2, notification2);
    }

    @Override
    public void onStart(@NotNull UploadInfo info, int notificationId, @NotNull UploadNotificationConfig notificationConfig2) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)notificationConfig2, (String)"notificationConfig");
        this.updateTask(TaskStatus.InProgress, info, notificationConfig2.getProgress());
    }

    @Override
    public void onProgress(@NotNull UploadInfo info, int notificationId, @NotNull UploadNotificationConfig notificationConfig2) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)notificationConfig2, (String)"notificationConfig");
        this.updateTask(TaskStatus.InProgress, info, notificationConfig2.getProgress());
    }

    @Override
    public void onSuccess(@NotNull UploadInfo info, int notificationId, @NotNull UploadNotificationConfig notificationConfig2, @NotNull ServerResponse response) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)notificationConfig2, (String)"notificationConfig");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.updateTask(TaskStatus.Succeeded, info, notificationConfig2.getSuccess());
    }

    @Override
    public void onError(@NotNull UploadInfo info, int notificationId, @NotNull UploadNotificationConfig notificationConfig2, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)notificationConfig2, (String)"notificationConfig");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        if (exception instanceof UserCancelledUploadException) {
            this.updateTask(TaskStatus.Cancelled, info, notificationConfig2.getCancelled());
        } else {
            this.updateTask(TaskStatus.Failed, info, notificationConfig2.getCancelled());
        }
    }

    @Override
    public void onCompleted(@NotNull UploadInfo info, int notificationId, @NotNull UploadNotificationConfig notificationConfig2) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)notificationConfig2, (String)"notificationConfig");
    }

    public static final /* synthetic */ UploadService access$getService$p(AbstractSingleNotificationHandler $this) {
        return $this.service;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u0019\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lnet/gotev/uploadservice/observer/task/AbstractSingleNotificationHandler$TaskData;", "Landroid/os/Parcelable;", "status", "Lnet/gotev/uploadservice/observer/task/AbstractSingleNotificationHandler$TaskStatus;", "info", "Lnet/gotev/uploadservice/data/UploadInfo;", "config", "Lnet/gotev/uploadservice/data/UploadNotificationStatusConfig;", "(Lnet/gotev/uploadservice/observer/task/AbstractSingleNotificationHandler$TaskStatus;Lnet/gotev/uploadservice/data/UploadInfo;Lnet/gotev/uploadservice/data/UploadNotificationStatusConfig;)V", "getConfig", "()Lnet/gotev/uploadservice/data/UploadNotificationStatusConfig;", "getInfo", "()Lnet/gotev/uploadservice/data/UploadInfo;", "getStatus", "()Lnet/gotev/uploadservice/observer/task/AbstractSingleNotificationHandler$TaskStatus;", "component1", "component2", "component3", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "uploadservice_release"})
    @Parcelize
    public static final class TaskData
    implements Parcelable {
        @NotNull
        private final TaskStatus status;
        @NotNull
        private final UploadInfo info;
        @NotNull
        private final UploadNotificationStatusConfig config;
        @NotNull
        public static final Parcelable.Creator<TaskData> CREATOR;

        public TaskData(@NotNull TaskStatus status, @NotNull UploadInfo info, @NotNull UploadNotificationStatusConfig config) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.status = status;
            this.info = info;
            this.config = config;
        }

        @NotNull
        public final TaskStatus getStatus() {
            return this.status;
        }

        @NotNull
        public final UploadInfo getInfo() {
            return this.info;
        }

        @NotNull
        public final UploadNotificationStatusConfig getConfig() {
            return this.config;
        }

        @NotNull
        public final TaskStatus component1() {
            return this.status;
        }

        @NotNull
        public final UploadInfo component2() {
            return this.info;
        }

        @NotNull
        public final UploadNotificationStatusConfig component3() {
            return this.config;
        }

        @NotNull
        public final TaskData copy(@NotNull TaskStatus status, @NotNull UploadInfo info, @NotNull UploadNotificationStatusConfig config) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return new TaskData(status, info, config);
        }

        public static /* synthetic */ TaskData copy$default(TaskData taskData, TaskStatus taskStatus, UploadInfo uploadInfo, UploadNotificationStatusConfig uploadNotificationStatusConfig, int n, Object object) {
            if ((n & 1) != 0) {
                taskStatus = taskData.status;
            }
            if ((n & 2) != 0) {
                uploadInfo = taskData.info;
            }
            if ((n & 4) != 0) {
                uploadNotificationStatusConfig = taskData.config;
            }
            return taskData.copy(taskStatus, uploadInfo, uploadNotificationStatusConfig);
        }

        @NotNull
        public String toString() {
            return "TaskData(status=" + this.status + ", info=" + this.info + ", config=" + this.config + ")";
        }

        public int hashCode() {
            int result = this.status.hashCode();
            result = result * 31 + this.info.hashCode();
            result = result * 31 + this.config.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TaskData)) {
                return false;
            }
            TaskData taskData = (TaskData)other;
            if (this.status != taskData.status) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.info, (Object)taskData.info)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.config, (Object)taskData.config);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeString(this.status.name());
            this.info.writeToParcel(out, flags);
            this.config.writeToParcel(out, flags);
        }

        static {
            @Metadata(mv={1, 8, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<TaskData> {
                @NotNull
                public final TaskData[] newArray(int size2) {
                    return new TaskData[size2];
                }

                @NotNull
                public final TaskData createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new TaskData(TaskStatus.valueOf(parcel.readString()), (UploadInfo)UploadInfo.CREATOR.createFromParcel(parcel), (UploadNotificationStatusConfig)UploadNotificationStatusConfig.CREATOR.createFromParcel(parcel));
                }
            }
            CREATOR = new Creator();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/gotev/uploadservice/observer/task/AbstractSingleNotificationHandler$TaskStatus;", "", "(Ljava/lang/String;I)V", "InProgress", "Succeeded", "Failed", "Cancelled", "uploadservice_release"})
    public static final class TaskStatus
    extends Enum<TaskStatus> {
        public static final /* enum */ TaskStatus InProgress = new TaskStatus();
        public static final /* enum */ TaskStatus Succeeded = new TaskStatus();
        public static final /* enum */ TaskStatus Failed = new TaskStatus();
        public static final /* enum */ TaskStatus Cancelled = new TaskStatus();
        private static final /* synthetic */ TaskStatus[] $VALUES;

        public static TaskStatus[] values() {
            return (TaskStatus[])$VALUES.clone();
        }

        public static TaskStatus valueOf(String value) {
            return Enum.valueOf(TaskStatus.class, value);
        }

        static {
            $VALUES = taskStatusArray = new TaskStatus[]{TaskStatus.InProgress, TaskStatus.Succeeded, TaskStatus.Failed, TaskStatus.Cancelled};
        }
    }
}

