/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.persistence;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 .2\u00020\u0001:\u0001.B\u000f\b\u0013\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\tH\u0096\u0002J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00000\u00132\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bJ\b\u0010\u001c\u001a\u00020\u000eH\u0016J\u001c\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\u0013J\u0016\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0010J\u0016\u0010!\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0000J\u0016\u0010\"\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0017J\u0016\u0010#\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u000eJ\u0016\u0010$\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u001aJ\u0016\u0010%\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010 \u001a\u00020\bJ\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020\bJ\u0018\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u000eH\u0016J\u0016\u0010,\u001a\u00020\b*\u00020\b2\b\b\u0002\u0010-\u001a\u00020\u0010H\u0002R0\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006/"}, d2={"Lnet/gotev/uploadservice/persistence/PersistableData;", "Landroid/os/Parcelable;", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "()V", "data", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "getData", "()Ljava/util/HashMap;", "describeContents", "", "equals", "", "other", "getArrayData", "", "key", "getBoolean", "getDouble", "", "getInt", "getLong", "", "getString", "hashCode", "putArrayData", "", "putBoolean", "value", "putData", "putDouble", "putInt", "putLong", "putString", "toBundle", "Landroid/os/Bundle;", "toJson", "writeToParcel", "dest", "flags", "validated", "checkExists", "CREATOR", "uploadservice_release"})
@SourceDebugExtension(value={"SMAP\nPersistableData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistableData.kt\nnet/gotev/uploadservice/persistence/PersistableData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,175:1\n1855#2,2:176\n766#2:180\n857#2,2:181\n1855#2,2:183\n1864#2,2:185\n1866#2:189\n766#2:190\n857#2,2:191\n766#2:193\n857#2,2:194\n1855#2,2:196\n766#2:198\n857#2,2:199\n1855#2,2:201\n1855#2,2:203\n215#3,2:178\n215#3,2:187\n*S KotlinDebug\n*F\n+ 1 PersistableData.kt\nnet/gotev/uploadservice/persistence/PersistableData\n*L\n35#1:176,2\n102#1:180\n102#1:181,2\n106#1:183,2\n113#1:185,2\n113#1:189\n121#1:190\n121#1:191,2\n126#1:193\n126#1:194,2\n132#1:196,2\n139#1:198\n139#1:199,2\n149#1:201,2\n168#1:203,2\n96#1:178,2\n114#1:187,2\n*E\n"})
public class PersistableData
implements Parcelable {
    @NotNull
    public static final CREATOR CREATOR = new CREATOR(null);
    @NotNull
    private final HashMap<String, Object> data;
    @NotNull
    private static final String separator = "$";

    public PersistableData() {
        this.data = new HashMap();
    }

    @NotNull
    protected final HashMap<String, Object> getData() {
        return this.data;
    }

    public boolean equals(@Nullable Object other) {
        if (other == null || !(other instanceof PersistableData)) {
            return false;
        }
        return Intrinsics.areEqual(this.data, ((PersistableData)other).data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    @SuppressLint(value={"ParcelClassLoader"})
    private PersistableData(Parcel parcel) {
        block1: {
            this();
            Bundle bundle = parcel.readBundle();
            if (bundle == null) break block1;
            Bundle bundle2 = bundle;
            boolean bl = false;
            Set set = bundle2.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"bundle.keySet()");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String key = (String)element$iv;
                boolean bl2 = false;
                Object value = bundle2.get(key);
                if (!((((value instanceof Boolean ? true : value instanceof Double) ? true : value instanceof Integer) ? true : value instanceof Long) ? true : value instanceof String)) continue;
                Map map = this.data;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                map.put(key, value);
            }
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        this.toBundle().writeToParcel(dest, flags);
    }

    private final String validated(String $this$validated, boolean checkExists) {
        if (StringsKt.contains$default((CharSequence)$this$validated, (CharSequence)separator, (boolean)false, (int)2, null)) {
            throw new IllegalArgumentException("key cannot contain $ as it's a reserved character, used for nested data");
        }
        if (checkExists && !this.data.containsKey($this$validated)) {
            throw new IllegalArgumentException("no data found for key \"" + $this$validated + "\"");
        }
        return $this$validated;
    }

    static /* synthetic */ String validated$default(PersistableData persistableData, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: validated");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return persistableData.validated(string, bl);
    }

    public final void putBoolean(@NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Boolean bl = value;
        ((Map)this.data).put(PersistableData.validated$default(this, key, false, 1, null), bl);
    }

    public final boolean getBoolean(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.data.get(this.validated(key, true));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
        return (Boolean)object;
    }

    public final void putDouble(@NotNull String key, double value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Double d = value;
        ((Map)this.data).put(PersistableData.validated$default(this, key, false, 1, null), d);
    }

    public final double getDouble(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.data.get(this.validated(key, true));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
        return (Double)object;
    }

    public final void putInt(@NotNull String key, int value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Integer n = value;
        ((Map)this.data).put(PersistableData.validated$default(this, key, false, 1, null), n);
    }

    public final int getInt(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.data.get(this.validated(key, true));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        return (Integer)object;
    }

    public final void putLong(@NotNull String key, long value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Long l = value;
        ((Map)this.data).put(PersistableData.validated$default(this, key, false, 1, null), l);
    }

    public final long getLong(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.data.get(this.validated(key, true));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
        return (Long)object;
    }

    public final void putString(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ((Map)this.data).put(PersistableData.validated$default(this, key, false, 1, null), value);
    }

    @NotNull
    public final String getString(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.data.get(this.validated(key, true));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)object;
    }

    public final void putData(@NotNull String key, @NotNull PersistableData data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Map $this$forEach$iv = data.data;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String dataKey = (String)entry.getKey();
            Object value = entry.getValue();
            ((Map)this.data).put(key + separator + dataKey, value);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PersistableData getData(@NotNull String key) {
        PersistableData persistableData;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Set<Map.Entry<String, Object>> set = this.data.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"data.entries");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            if (!StringsKt.startsWith$default((String)((String)k), (String)(key + separator), (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List entries = (List)destination$iv$iv;
        if (entries.isEmpty()) {
            return new PersistableData();
        }
        PersistableData extractedData = persistableData = new PersistableData();
        boolean bl = false;
        Iterable $this$forEach$iv = entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(entryKey, entryValue)");
            String entryKey = (String)entry.getKey();
            Object entryValue = entry.getValue();
            Map map = extractedData.data;
            Intrinsics.checkNotNullExpressionValue((Object)entryKey, (String)"entryKey");
            String string = StringsKt.removePrefix((String)entryKey, (CharSequence)(key + separator));
            Intrinsics.checkNotNullExpressionValue(entryValue, (String)"entryValue");
            map.put(string, entryValue);
        }
        return persistableData;
    }

    /*
     * WARNING - void declaration
     */
    public final void putArrayData(@NotNull String key, @NotNull List<? extends PersistableData> data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Iterable $this$forEachIndexed$iv = data;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void persistableData;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            PersistableData persistableData2 = (PersistableData)item$iv;
            int index = n;
            boolean bl = false;
            Map $this$forEach$iv = persistableData.data;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl2 = false;
                String dataKey = (String)entry.getKey();
                Object value = entry.getValue();
                ((Map)this.data).put(key + separator + index + separator + dataKey, value);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PersistableData> getArrayData(@NotNull String key) {
        void $this$filterTo$iv$iv4;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Set<Map.Entry<String, Object>> set = this.data.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"data.entries");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            if (!StringsKt.startsWith$default((String)((String)k), (String)(key + separator), (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection collection = (List)destination$iv$iv;
        ArrayList entries = new ArrayList(collection);
        if (entries.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        int index = 0;
        List elements = null;
        Iterable $this$filter$iv2 = entries;
        boolean $i$f$filter2 = false;
        Iterable $i$f$filterTo22 = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv4) {
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            if (!StringsKt.startsWith$default((String)((String)k), (String)(key + separator + index + separator), (boolean)false, (int)2, null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        elements = (List)destination$iv$iv2;
        ArrayList<PersistableData> outList = new ArrayList<PersistableData>();
        while (!((Collection)elements).isEmpty()) {
            void $this$filterTo$iv$iv3;
            PersistableData $this$filterTo$iv$iv4 = $i$f$filter2 = new PersistableData();
            ArrayList<PersistableData> arrayList = outList;
            boolean $i$a$-also-PersistableData$getArrayData$22 = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void extractedData;
                Map.Entry bl = (Map.Entry)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"(entryKey, entryValue)");
                String entryKey = (String)bl.getKey();
                Object entryValue = bl.getValue();
                Map map = extractedData.data;
                Intrinsics.checkNotNullExpressionValue((Object)entryKey, (String)"entryKey");
                String string = StringsKt.removePrefix((String)entryKey, (CharSequence)(key + separator + index + separator));
                Intrinsics.checkNotNullExpressionValue(entryValue, (String)"entryValue");
                map.put(string, entryValue);
            }
            entries.removeAll(elements);
            arrayList.add($i$f$filter2);
            ++index;
            Iterable $this$filter$iv3 = entries;
            boolean $i$f$filter3 = false;
            Iterable $i$a$-also-PersistableData$getArrayData$22 = $this$filter$iv3;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
                if (!StringsKt.startsWith$default((String)((String)k), (String)(key + separator + index + separator), (boolean)false, (int)2, null)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            elements = (List)destination$iv$iv3;
        }
        return outList;
    }

    @NotNull
    public final Bundle toBundle() {
        Bundle bundle;
        Bundle bundle2 = bundle = new Bundle();
        boolean bl = false;
        Set<String> set = this.data.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"data.keys");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key = (String)element$iv;
            boolean bl2 = false;
            Object value = this.data.get(key);
            if (value instanceof Boolean) {
                bundle2.putBoolean(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Double) {
                bundle2.putDouble(key, ((Number)value).doubleValue());
                continue;
            }
            if (value instanceof Integer) {
                bundle2.putInt(key, ((Number)value).intValue());
                continue;
            }
            if (value instanceof Long) {
                bundle2.putLong(key, ((Number)value).longValue());
                continue;
            }
            if (!(value instanceof String)) continue;
            bundle2.putString(key, (String)value);
        }
        return bundle;
    }

    @NotNull
    public final String toJson() {
        JSONObject jSONObject;
        JSONObject json = jSONObject = new JSONObject();
        boolean bl = false;
        Set<String> set = this.data.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"data.keys");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key = (String)element$iv;
            boolean bl2 = false;
            Object value = this.data.get(key);
            if (!((((value instanceof Boolean ? true : value instanceof Double) ? true : value instanceof Integer) ? true : value instanceof Long) ? true : value instanceof String)) continue;
            json.put(key, value);
        }
        String string = jSONObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSONObject().also { json\u2026       }\n    }.toString()");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final PersistableData fromJson(@NotNull String rawJsonString) {
        return CREATOR.fromJson(rawJsonString);
    }

    public /* synthetic */ PersistableData(Parcel parcel, DefaultConstructorMarker $constructor_marker) {
        this(parcel);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u001d\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnet/gotev/uploadservice/persistence/PersistableData$CREATOR;", "Landroid/os/Parcelable$Creator;", "Lnet/gotev/uploadservice/persistence/PersistableData;", "()V", "separator", "", "createFromParcel", "parcel", "Landroid/os/Parcel;", "fromJson", "rawJsonString", "newArray", "", "size", "", "(I)[Lnet/gotev/uploadservice/persistence/PersistableData;", "uploadservice_release"})
    @SourceDebugExtension(value={"SMAP\nPersistableData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistableData.kt\nnet/gotev/uploadservice/persistence/PersistableData$CREATOR\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,175:1\n32#2,2:176\n*S KotlinDebug\n*F\n+ 1 PersistableData.kt\nnet/gotev/uploadservice/persistence/PersistableData$CREATOR\n*L\n62#1:176,2\n*E\n"})
    public static final class CREATOR
    implements Parcelable.Creator<PersistableData> {
        private CREATOR() {
        }

        @NotNull
        public PersistableData createFromParcel(@NotNull Parcel parcel) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            return new PersistableData(parcel, null);
        }

        @NotNull
        public PersistableData[] newArray(int size2) {
            return new PersistableData[size2];
        }

        @JvmStatic
        @NotNull
        public final PersistableData fromJson(@NotNull String rawJsonString) {
            Intrinsics.checkNotNullParameter((Object)rawJsonString, (String)"rawJsonString");
            JSONObject json = new JSONObject(rawJsonString);
            PersistableData data = new PersistableData();
            Iterator iterator = json.keys();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"json.keys()");
            Iterator $this$forEach$iv = iterator;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv;
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                String key = (String)element$iv;
                boolean bl = false;
                Object value = json.get(key);
                if (!((((value instanceof Boolean ? true : value instanceof Double) ? true : value instanceof Integer) ? true : value instanceof Long) ? true : value instanceof String)) continue;
                Map map = data.getData();
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                map.put(key, value);
            }
            return data;
        }

        public /* synthetic */ CREATOR(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

